/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.core;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.mylyn.context.core.ContextCorePlugin;
import org.eclipse.mylyn.internal.tasks.core.TaskDataManager;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.FileAttachment;
import org.eclipse.mylyn.tasks.core.ITaskAttachment;
import org.eclipse.mylyn.tasks.core.RepositoryAttachment;
import org.eclipse.mylyn.tasks.core.RepositoryStatus;
import org.eclipse.mylyn.tasks.core.RepositoryTaskData;
import org.eclipse.mylyn.tasks.core.TaskRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAttachmentHandler {
    protected static final int BUFFER_SIZE = 1024;
    private TaskDataManager taskDataManager = null;
    public static final String MESSAGE_ATTACHMENTS_NOT_SUPPORTED = "Attachments not supported by connector: ";
    public static final String MYLAR_CONTEXT_DESCRIPTION_LEGACY = "mylar/context/zip";
    public static final String MYLAR_CONTEXT_FILENAME = "mylyn-context.zip";
    public static final String MYLAR_CONTEXT_DESCRIPTION = "mylyn/context/zip";

    public abstract void uploadAttachment(TaskRepository var1, AbstractTask var2, ITaskAttachment var3, String var4, IProgressMonitor var5) throws CoreException;

    public abstract InputStream getAttachmentAsStream(TaskRepository var1, RepositoryAttachment var2, IProgressMonitor var3) throws CoreException;

    public abstract boolean canUploadAttachment(TaskRepository var1, AbstractTask var2);

    public abstract boolean canDownloadAttachment(TaskRepository var1, AbstractTask var2);

    public abstract boolean canDeprecate(TaskRepository var1, RepositoryAttachment var2);

    public abstract void updateAttachment(TaskRepository var1, RepositoryAttachment var2) throws CoreException;

    /*
     * Exception decompiling
     */
    public void downloadAttachment(TaskRepository repository, RepositoryAttachment attachment, OutputStream out, IProgressMonitor monitor) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [14[DOLOOP]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public final boolean hasRepositoryContext(TaskRepository repository, AbstractTask task) {
        if (repository == null || task == null) {
            return false;
        }
        Set<RepositoryAttachment> remoteContextAttachments = this.getContextAttachments(repository, task);
        return remoteContextAttachments != null && remoteContextAttachments.size() > 0;
    }

    public final Set<RepositoryAttachment> getContextAttachments(TaskRepository repository, AbstractTask task) {
        RepositoryTaskData newData;
        HashSet<RepositoryAttachment> contextAttachments = new HashSet<RepositoryAttachment>();
        if (this.taskDataManager != null && (newData = this.taskDataManager.getNewTaskData(task.getRepositoryUrl(), task.getTaskId())) != null) {
            for (RepositoryAttachment attachment : newData.getAttachments()) {
                if (attachment.getDescription().equals(MYLAR_CONTEXT_DESCRIPTION)) {
                    contextAttachments.add(attachment);
                    continue;
                }
                if (!attachment.getDescription().equals(MYLAR_CONTEXT_DESCRIPTION_LEGACY)) continue;
                contextAttachments.add(attachment);
            }
        }
        return contextAttachments;
    }

    public final boolean attachContext(TaskRepository repository, AbstractTask task, String longComment, IProgressMonitor monitor) throws CoreException {
        ContextCorePlugin.getContextManager().saveContext(task.getHandleIdentifier());
        File sourceContextFile = ContextCorePlugin.getContextManager().getFileForContext(task.getHandleIdentifier());
        AbstractTask.RepositoryTaskSyncState previousState = task.getSynchronizationState();
        if (sourceContextFile != null && sourceContextFile.exists()) {
            try {
                task.setSubmitting(true);
                task.setSynchronizationState(AbstractTask.RepositoryTaskSyncState.OUTGOING);
                FileAttachment attachment = new FileAttachment(sourceContextFile);
                attachment.setDescription(MYLAR_CONTEXT_DESCRIPTION);
                attachment.setFilename(MYLAR_CONTEXT_FILENAME);
                this.uploadAttachment(repository, task, attachment, longComment, monitor);
            }
            catch (CoreException e) {
                task.setSynchronizationState(previousState);
                throw e;
            }
            catch (OperationCanceledException operationCanceledException) {
                return true;
            }
        }
        return true;
    }

    public final boolean retrieveContext(TaskRepository repository, AbstractTask task, RepositoryAttachment attachment, String destinationPath, IProgressMonitor monitor) throws CoreException {
        File destinationContextFile = ContextCorePlugin.getContextManager().getFileForContext(task.getHandleIdentifier());
        if (destinationContextFile.exists() && !destinationContextFile.delete()) {
            return false;
        }
        try {
            FileOutputStream out = new FileOutputStream(destinationContextFile);
            try {
                this.downloadAttachment(repository, attachment, out, monitor);
            }
            finally {
                try {
                    out.close();
                }
                catch (IOException e) {
                    StatusHandler.fail((Throwable)e, (String)"Could not close context file", (boolean)false);
                }
            }
        }
        catch (FileNotFoundException e) {
            throw new CoreException((IStatus)new RepositoryStatus(4, "org.eclipse.mylyn.tasks.core", 7, "Could not create context file", e));
        }
        return true;
    }

    public void setTaskDataManager(TaskDataManager taskDataManager) {
        this.taskDataManager = taskDataManager;
    }
}

