/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.core;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.AbstractTaskContainer;

public abstract class AbstractRepositoryQuery
extends AbstractTaskContainer {
    protected String repositoryUrl;
    protected String lastSynchronizedStamp = "<never>";
    private boolean synchronizing = false;
    protected IStatus status = null;

    public abstract String getRepositoryKind();

    public AbstractRepositoryQuery(String description) {
        super(description);
    }

    public String getPriority() {
        if (super.isEmpty()) {
            return AbstractTask.PriorityLevel.P1.toString();
        }
        String highestPriority = AbstractTask.PriorityLevel.P5.toString();
        for (AbstractTask hit : this.getChildren()) {
            if (highestPriority.compareTo(hit.getPriority()) <= 0) continue;
            highestPriority = hit.getPriority();
        }
        return highestPriority;
    }

    public String getRepositoryUrl() {
        return this.repositoryUrl;
    }

    public void setRepositoryUrl(String newRepositoryUrl) {
        if (this.repositoryUrl != null && this.url != null) {
            this.url = String.valueOf(newRepositoryUrl) + this.url.substring(this.repositoryUrl.length());
        }
        this.repositoryUrl = newRepositoryUrl;
    }

    public boolean isSynchronizing() {
        return this.synchronizing;
    }

    public void setSynchronizing(boolean synchronizing) {
        this.synchronizing = synchronizing;
    }

    public String getLastSynchronizedTimeStamp() {
        return this.lastSynchronizedStamp;
    }

    public void setLastSynchronizedStamp(String lastRefreshTimeStamp) {
        this.lastSynchronizedStamp = lastRefreshTimeStamp;
    }

    public IStatus getSynchronizationStatus() {
        return this.status;
    }

    public void setSynchronizationStatus(IStatus status) {
        this.status = status;
    }
}

