/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui;

import java.text.MessageFormat;
import java.util.Calendar;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityUtil;
import org.eclipse.mylyn.internal.tasks.core.TaskCategory;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.AbstractTaskCategory;
import org.eclipse.mylyn.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class AddExistingTaskJob
extends Job {
    private TaskRepository repository;
    private String taskId;
    private AbstractTaskCategory taskContainer;

    public AddExistingTaskJob(TaskRepository repository, String taskId) {
        this(repository, taskId, null);
    }

    public AddExistingTaskJob(TaskRepository repository, String taskId, AbstractTaskCategory taskContainer) {
        super(MessageFormat.format("Adding task: \"{0}\"...", taskId));
        this.repository = repository;
        this.taskId = taskId;
        this.taskContainer = taskContainer;
    }

    public IStatus run(IProgressMonitor monitor) {
        block6: {
            AbstractRepositoryConnector connector = TasksUiPlugin.getRepositoryManager().getRepositoryConnector(this.repository.getConnectorKind());
            try {
                try {
                    final AbstractTask newTask = connector.createTaskFromExistingId(this.repository, this.taskId, monitor);
                    if (newTask != null) {
                        Calendar newSchedule = Calendar.getInstance();
                        TaskActivityUtil.snapEndOfWorkDay((Calendar)newSchedule);
                        TasksUiPlugin.getTaskActivityManager().setScheduledFor(newTask, newSchedule.getTime());
                        TasksUiUtil.refreshAndOpenTaskListElement((AbstractTaskContainer)newTask);
                        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                Object category = AddExistingTaskJob.this.taskContainer;
                                TaskListView taskListView = TaskListView.getFromActivePerspective();
                                if (category == null) {
                                    Object selectedObject = ((IStructuredSelection)taskListView.getViewer().getSelection()).getFirstElement();
                                    category = selectedObject instanceof TaskCategory ? (TaskCategory)selectedObject : TasksUiPlugin.getTaskListManager().getTaskList().getOrphanContainer("local");
                                }
                                TasksUiPlugin.getTaskListManager().getTaskList().moveTask(newTask, (AbstractTaskContainer)category);
                                taskListView.getViewer().setSelection((ISelection)new StructuredSelection((Object)newTask));
                            }
                        });
                        break block6;
                    }
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                            if (window != null) {
                                MessageDialog.openWarning((Shell)window.getShell(), (String)"Add Existing Task Failed", (String)MessageFormat.format("Unable to retrieve task \"{0}\" from repository.", AddExistingTaskJob.this.taskId));
                            }
                        }
                    });
                }
                catch (CoreException e) {
                    StatusHandler.displayStatus((String)"Unable to open task", (IStatus)e.getStatus());
                    monitor.done();
                }
            }
            finally {
                monitor.done();
            }
        }
        return Status.OK_STATUS;
    }
}

