/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui;

import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.mylyn.context.core.ContextCorePlugin;
import org.eclipse.mylyn.context.core.IInteractionContext;
import org.eclipse.mylyn.context.core.IInteractionContextListener;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.menus.UIElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextCapturePauseHandler
extends AbstractHandler
implements IElementUpdater,
IInteractionContextListener {
    public ContextCapturePauseHandler() {
        ContextCorePlugin.getContextManager().addListener((IInteractionContextListener)this);
    }

    public void dispose() {
        ContextCorePlugin.getContextManager().removeListener((IInteractionContextListener)this);
        super.dispose();
    }

    public Object execute(ExecutionEvent e) throws ExecutionException {
        if (ContextCorePlugin.getContextManager().isContextCapturePaused()) {
            this.resume();
        } else {
            this.pause();
        }
        return null;
    }

    public void resume() {
        ContextCorePlugin.getContextManager().setContextCapturePaused(false);
        if (TaskListView.getFromActivePerspective() != null) {
            TaskListView.getFromActivePerspective().indicatePaused(false);
        }
        this.refreshCommands();
    }

    public void pause() {
        ContextCorePlugin.getContextManager().setContextCapturePaused(true);
        TaskListView.getFromActivePerspective().indicatePaused(true);
        this.refreshCommands();
    }

    private void refreshCommands() {
        ICommandService service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        if (service != null) {
            service.refreshElements("org.eclipse.mylyn.tasks.ui.command.previousTask", null);
            service.refreshElements("org.eclipse.mylyn.ui.context.capture.pause.command", null);
        }
    }

    public void updateElement(UIElement element, Map parameters) {
        element.setChecked(ContextCorePlugin.getContextManager().isContextCapturePaused());
    }

    public void contextActivated(IInteractionContext context) {
        this.resume();
    }

    public void contextDeactivated(IInteractionContext context) {
        this.resume();
    }

    public void contextCleared(IInteractionContext context) {
    }

    public void elementDeleted(IInteractionElement element) {
    }

    public void interestChanged(List<IInteractionElement> elements) {
    }

    public void landmarkAdded(IInteractionElement element) {
    }

    public void landmarkRemoved(IInteractionElement element) {
    }

    public void relationsChanged(IInteractionElement element) {
    }
}

