/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.RepositoryAttachment;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;

public class ContextUiUtil {
    public static boolean downloadContext(final AbstractTask task, final RepositoryAttachment attachment, IRunnableContext context) {
        final AbstractRepositoryConnector connector = TasksUiPlugin.getRepositoryManager().getRepositoryConnector(task);
        final TaskRepository repository = TasksUiPlugin.getRepositoryManager().getRepository(attachment.getRepositoryUrl());
        final String directory = TasksUiPlugin.getDefault().getDataDirectory();
        try {
            if (task.isActive()) {
                TasksUiPlugin.getTaskListManager().deactivateTask(task);
            }
            final boolean[] result = new boolean[1];
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        result[0] = connector.getAttachmentHandler() != null ? connector.getAttachmentHandler().retrieveContext(repository, task, attachment, directory, monitor) : false;
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            context.run(true, true, runnable);
            if (!result[0]) {
                MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Mylyn Information", (String)("Attachments not supported by connector: " + connector.getLabel()));
            } else {
                TasksUiPlugin.getTaskListManager().getTaskList().notifyTaskChanged(task, false);
                TasksUiPlugin.getTaskListManager().activateTask(task);
            }
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof CoreException) {
                StatusHandler.displayStatus((String)"Mylyn Information", (IStatus)((CoreException)e.getCause()).getStatus());
            } else {
                StatusHandler.fail((Throwable)e, (String)"Unexpected error while attaching context", (boolean)true);
            }
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    public static boolean uploadContext(final TaskRepository repository, final AbstractTask task, final String comment, IRunnableContext context) {
        final AbstractRepositoryConnector connector = TasksUiPlugin.getRepositoryManager().getRepositoryConnector(repository.getConnectorKind());
        try {
            final boolean[] result = new boolean[1];
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        result[0] = connector.getAttachmentHandler() != null ? connector.getAttachmentHandler().attachContext(repository, task, comment, monitor) : false;
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            context.run(true, true, runnable);
            if (!result[0]) {
                MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Mylyn Information", (String)("Attachments not supported by connector: " + connector.getLabel()));
            } else {
                task.setSynchronizationState(AbstractTask.RepositoryTaskSyncState.SYNCHRONIZED);
                IWorkbenchPartSite site = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart().getSite();
                if (site instanceof IViewSite) {
                    IStatusLineManager statusLineManager = ((IViewSite)site).getActionBars().getStatusLineManager();
                    statusLineManager.setMessage(TasksUiImages.getImage(TasksUiImages.TASKLIST), "Context attached to task: " + task.getSummary());
                    TasksUiPlugin.getSynchronizationManager().synchronize(connector, task, true, null);
                }
            }
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof CoreException) {
                StatusHandler.displayStatus((String)"Mylyn Information", (IStatus)((CoreException)e.getCause()).getStatus());
            } else {
                StatusHandler.fail((Throwable)e, (String)"Unexpected error while attaching context", (boolean)true);
            }
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }
}

