/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.mylyn.internal.tasks.ui.PersonContentProposal;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.RepositoryAttachment;
import org.eclipse.mylyn.tasks.core.RepositoryTaskData;
import org.eclipse.mylyn.tasks.core.TaskComment;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersonProposalProvider
implements IContentProposalProvider {
    private AbstractTask currentTask;
    private RepositoryTaskData currentTaskData;
    private String currentUser;
    private SortedSet<String> addressSet = null;

    public PersonProposalProvider(AbstractTask repositoryTask, RepositoryTaskData taskData) {
        this.currentTask = repositoryTask;
        this.currentTaskData = taskData;
    }

    public IContentProposal[] getProposals(String contents, int position) {
        if (contents == null) {
            throw new IllegalArgumentException();
        }
        SortedSet<String> addressSet = this.getAddressSet();
        if (position > 0) {
            char[] chars = contents.toLowerCase().toCharArray();
            String contents1 = new String(chars, 0, position);
            int n = position - 1;
            chars[n] = (char)(chars[n] + '\u0001');
            String contents2 = new String(chars, 0, position);
            addressSet = addressSet.subSet(contents1, contents2);
        }
        Object[] result = new IContentProposal[addressSet.size()];
        int i = 0;
        for (String address : addressSet) {
            result[i++] = new PersonContentProposal(address, address.equalsIgnoreCase(this.currentUser));
        }
        Arrays.sort(result);
        return result;
    }

    private SortedSet<String> getAddressSet() {
        if (this.addressSet != null) {
            return this.addressSet;
        }
        this.addressSet = new TreeSet<String>(new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                return s1.compareToIgnoreCase(s2);
            }
        });
        if (this.currentTask != null) {
            this.addAddress(this.currentTask.getOwner(), this.addressSet);
        }
        this.addAddresses(this.currentTaskData, this.addressSet);
        String repositoryUrl = null;
        String repositoryKind = null;
        if (this.currentTask != null) {
            repositoryUrl = this.currentTask.getRepositoryUrl();
            repositoryKind = this.currentTask.getConnectorKind();
        }
        if ((repositoryUrl == null || repositoryKind == null) && this.currentTaskData != null) {
            repositoryUrl = this.currentTaskData.getRepositoryUrl();
            repositoryKind = this.currentTaskData.getRepositoryKind();
        }
        if (repositoryUrl != null && repositoryKind != null) {
            TaskRepository repository;
            HashSet<AbstractTask> tasks = new HashSet<AbstractTask>();
            if (this.currentTask != null) {
                tasks.add(this.currentTask);
            }
            if ((repository = TasksUiPlugin.getRepositoryManager().getRepository(repositoryKind, repositoryUrl)) != null) {
                this.currentUser = repository.getUserName();
                if (this.currentUser != null && !repository.isAnonymous()) {
                    this.addressSet.add(this.currentUser);
                }
            }
            Collection allTasks = TasksUiPlugin.getTaskListManager().getTaskList().getAllTasks();
            for (AbstractTask task : allTasks) {
                AbstractTask repositoryTask;
                if (task == null || !(repositoryTask = task).getRepositoryUrl().equals(repositoryUrl)) continue;
                tasks.add(repositoryTask);
            }
            for (AbstractTask task : tasks) {
                this.addAddresses(task, this.addressSet);
            }
        }
        return this.addressSet;
    }

    private void addAddresses(AbstractTask task, Set<String> addressSet) {
        this.addAddress(task.getOwner(), addressSet);
    }

    private void addAddresses(RepositoryTaskData data, Set<String> addressSet) {
        if (data != null) {
            this.addAddress(data.getReporter(), addressSet);
            for (String address : data.getCc()) {
                this.addAddress(address, addressSet);
            }
            for (TaskComment comment : this.currentTaskData.getComments()) {
                this.addAddress(comment.getAuthor(), addressSet);
            }
            for (RepositoryAttachment attachment : this.currentTaskData.getAttachments()) {
                this.addAddress(attachment.getCreator(), addressSet);
            }
        }
    }

    private void addAddress(String address, Set<String> addressSet) {
        if (address != null && address.trim().length() > 0) {
            addressSet.add(address.trim());
        }
    }
}

