/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public abstract class RetrieveTitleFromUrlJob
extends Job
implements TitleListener {
    public static final String LABEL_TITLE = "Retrieving summary from URL";
    private static final long MAX_WAIT_TIME_MILLIS = 10000L;
    private static final long SLEEP_INTERVAL_MILLIS = 500L;
    private String url = null;
    private String pageTitle = null;
    private boolean retrievalFailed = false;
    private long timeWaitedMillis = 0L;
    boolean ignoreChangeCall = false;
    private boolean titleRetrieved = false;
    private Shell shell = null;
    private Browser browser = null;

    public RetrieveTitleFromUrlJob(String url) {
        super(LABEL_TITLE);
        this.url = url;
    }

    protected abstract void setTitle(String var1);

    public IStatus run(IProgressMonitor monitor) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                RetrieveTitleFromUrlJob.this.shell = new Shell(Display.getDefault());
                RetrieveTitleFromUrlJob.this.shell.setVisible(false);
                RetrieveTitleFromUrlJob.this.browser = new Browser((Composite)RetrieveTitleFromUrlJob.this.shell, 0);
                RetrieveTitleFromUrlJob.this.browser.addTitleListener((TitleListener)RetrieveTitleFromUrlJob.this);
                RetrieveTitleFromUrlJob.this.browser.setUrl(RetrieveTitleFromUrlJob.this.url);
            }
        });
        while (this.pageTitle == null && !this.retrievalFailed && this.timeWaitedMillis <= 10000L) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                StatusHandler.fail((Throwable)e, (String)"Thread interrupted during sleep", (boolean)false);
            }
            this.timeWaitedMillis += 500L;
        }
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (RetrieveTitleFromUrlJob.this.pageTitle == null) {
                    RetrieveTitleFromUrlJob.this.pageTitle = RetrieveTitleFromUrlJob.this.url;
                    RetrieveTitleFromUrlJob.this.titleRetrieved = false;
                } else {
                    RetrieveTitleFromUrlJob.this.titleRetrieved = true;
                }
                RetrieveTitleFromUrlJob.this.setTitle(RetrieveTitleFromUrlJob.this.pageTitle);
                if (RetrieveTitleFromUrlJob.this.shell != null && !RetrieveTitleFromUrlJob.this.shell.isDisposed()) {
                    RetrieveTitleFromUrlJob.this.shell.dispose();
                }
                if (RetrieveTitleFromUrlJob.this.browser != null && !RetrieveTitleFromUrlJob.this.browser.isDisposed()) {
                    RetrieveTitleFromUrlJob.this.browser.dispose();
                }
            }
        });
        return Status.OK_STATUS;
    }

    public void changed(TitleEvent event) {
        if (!this.ignoreChangeCall) {
            if (event.title.equals(this.url)) {
                return;
            }
            this.ignoreChangeCall = true;
            if (event.title.equals(String.valueOf(this.url) + "/") || event.title.equals("Object not found!") || event.title.equals("No page to display") || event.title.equals("Cannot find server") || event.title.equals("Invalid Bug ID")) {
                this.retrievalFailed = true;
            } else {
                this.pageTitle = event.title;
            }
        }
    }

    public boolean isTitleRetrieved() {
        return this.titleRetrieved;
    }

    public String getPageTitle() {
        return this.pageTitle;
    }
}

