/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityUtil;
import org.eclipse.mylyn.internal.tasks.ui.IDynamicSubMenuContributor;
import org.eclipse.mylyn.internal.tasks.ui.planner.DateSelectionDialog;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.tasks.ui.TaskListManager;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScheduleTaskMenuContributor
implements IDynamicSubMenuContributor {
    private static final String LABEL_REMINDER = "Schedule";
    private static final String LABEL_TODAY = "Today";
    private static final String LABEL_NEXT_WEEK = "Next Week";
    private static final String LABEL_TWO_WEEKS = "Two Weeks";
    private static final String LABEL_FUTURE = "Future";
    private static final String LABEL_CALENDAR = "Choose Date...";
    private static final String LABEL_NOT_SCHEDULED = "Not Scheduled";

    @Override
    public MenuManager getSubMenuManager(List<AbstractTaskContainer> selectedElements) {
        AbstractTaskContainer selectedElement;
        final TaskListManager tasklistManager = TasksUiPlugin.getTaskListManager();
        MenuManager subMenuManager = new MenuManager(LABEL_REMINDER);
        subMenuManager.setVisible(selectedElements.size() > 0 && selectedElements.get(0) instanceof AbstractTask);
        AbstractTaskContainer singleSelection = null;
        if (selectedElements.size() == 1 && (selectedElement = selectedElements.get(0)) instanceof AbstractTask) {
            singleSelection = selectedElement;
        }
        final AbstractTask singleTaskSelection = tasklistManager.getTaskForElement(singleSelection, false);
        final ArrayList<AbstractTaskContainer> taskListElementsToSchedule = new ArrayList<AbstractTaskContainer>();
        for (AbstractTaskContainer selectedElement2 : selectedElements) {
            if (!(selectedElement2 instanceof AbstractTask)) continue;
            taskListElementsToSchedule.add(selectedElement2);
        }
        Action action = new Action(){

            public void run() {
                Calendar reminderCalendar = GregorianCalendar.getInstance();
                TasksUiPlugin.getTaskListManager().setScheduledEndOfDay(reminderCalendar);
                for (AbstractTaskContainer element : taskListElementsToSchedule) {
                    AbstractTask task = tasklistManager.getTaskForElement(element, true);
                    TasksUiPlugin.getTaskListManager().setScheduledFor(task, reminderCalendar.getTime());
                }
            }
        };
        action.setText(LABEL_TODAY);
        action.setEnabled(this.canSchedule(singleSelection, taskListElementsToSchedule));
        subMenuManager.add((IAction)action);
        if (singleTaskSelection != null && TasksUiPlugin.getTaskListManager().isScheduledForToday(singleTaskSelection)) {
            action.setChecked(true);
        }
        subMenuManager.add((IContributionItem)new Separator());
        final int today = Calendar.getInstance().get(7);
        boolean reachedEndOfWeek = false;
        int i = today + 1;
        while (i <= 8 && !reachedEndOfWeek) {
            final int day = i;
            action = new Action(){

                public void run() {
                    Calendar reminderCalendar = GregorianCalendar.getInstance();
                    int dueIn = day - today;
                    TasksUiPlugin.getTaskListManager().setSecheduledIn(reminderCalendar, dueIn);
                    for (AbstractTaskContainer element : taskListElementsToSchedule) {
                        AbstractTask task = tasklistManager.getTaskForElement(element, true);
                        TasksUiPlugin.getTaskListManager().setScheduledFor(task, reminderCalendar.getTime());
                    }
                }
            };
            this.getDayLabel(i, action);
            if (singleTaskSelection != null && singleTaskSelection.getScheduledForDate() != null) {
                int tasksCheduledOn = singleTaskSelection.getScheduledForDate().getDay();
                if (TasksUiPlugin.getTaskListManager().isScheduledForThisWeek(singleTaskSelection)) {
                    if (tasksCheduledOn + 1 == day) {
                        action.setChecked(true);
                    } else if (tasksCheduledOn == 0 && day == 8) {
                        action.setChecked(true);
                    }
                }
            }
            action.setEnabled(this.canSchedule(singleSelection, taskListElementsToSchedule));
            subMenuManager.add((IAction)action);
            ++i;
        }
        subMenuManager.add((IContributionItem)new Separator());
        action = new Action(){

            public void run() {
                for (AbstractTaskContainer element : taskListElementsToSchedule) {
                    AbstractTask task = tasklistManager.getTaskForElement(element, true);
                    Calendar startNextWeek = Calendar.getInstance();
                    TasksUiPlugin.getTaskListManager().setScheduledNextWeek(startNextWeek);
                    TasksUiPlugin.getTaskListManager().setScheduledFor(task, startNextWeek.getTime());
                }
            }
        };
        action.setText(LABEL_NEXT_WEEK);
        action.setEnabled(this.canSchedule(singleSelection, taskListElementsToSchedule));
        if (singleTaskSelection != null && TasksUiPlugin.getTaskListManager().isScheduledAfterThisWeek(singleTaskSelection) && !TasksUiPlugin.getTaskListManager().isScheduledForLater(singleTaskSelection)) {
            action.setChecked(true);
        }
        subMenuManager.add((IAction)action);
        action = new Action(){

            public void run() {
                for (AbstractTaskContainer element : taskListElementsToSchedule) {
                    AbstractTask task = tasklistManager.getTaskForElement(element, true);
                    TasksUiPlugin.getTaskListManager().setScheduledFor(task, TasksUiPlugin.getTaskActivityManager().getActivityFuture().getStart().getTime());
                }
            }
        };
        action.setText(LABEL_TWO_WEEKS);
        action.setEnabled(this.canSchedule(singleSelection, taskListElementsToSchedule));
        if (singleTaskSelection != null && singleTaskSelection.getScheduledForDate() != null) {
            Calendar time = TaskActivityUtil.getCalendar();
            time.setTime(singleTaskSelection.getScheduledForDate());
            Calendar start = TaskActivityUtil.getCalendar();
            start.setTime(TasksUiPlugin.getTaskActivityManager().getActivityFuture().getStart().getTime());
            Calendar end = TaskActivityUtil.getCalendar();
            end.setTime(TasksUiPlugin.getTaskActivityManager().getActivityFuture().getStart().getTime());
            TaskActivityUtil.snapEndOfWeek((Calendar)end);
            if (TaskActivityUtil.isBetween((Calendar)time, (Calendar)start, (Calendar)end)) {
                action.setChecked(true);
            }
        }
        subMenuManager.add((IAction)action);
        if (singleTaskSelection != null && singleTaskSelection.getScheduledForDate() != null) {
            Calendar time = TaskActivityUtil.getCalendar();
            time.setTime(singleTaskSelection.getScheduledForDate());
            Calendar start = TaskActivityUtil.getCalendar();
            start.setTime(TasksUiPlugin.getTaskActivityManager().getActivityFuture().getStart().getTime());
            start.add(4, 1);
            if (time.compareTo(start) >= 0) {
                action = new Action(){

                    public void run() {
                    }
                };
                action.setChecked(true);
                action.setText(LABEL_FUTURE);
                subMenuManager.add((IAction)action);
            }
        }
        subMenuManager.add((IContributionItem)new Separator());
        action = new Action(){

            public void run() {
                DateSelectionDialog reminderDialog;
                int result;
                Calendar theCalendar = GregorianCalendar.getInstance();
                if (singleTaskSelection != null && singleTaskSelection.getScheduledForDate() != null) {
                    theCalendar.setTime(singleTaskSelection.getScheduledForDate());
                }
                if ((result = (reminderDialog = new DateSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), theCalendar, "Choose Date")).open()) == 0) {
                    for (AbstractTaskContainer element : taskListElementsToSchedule) {
                        AbstractTask task = null;
                        if (element instanceof AbstractTask) {
                            task = (AbstractTask)element;
                        }
                        TasksUiPlugin.getTaskListManager().setScheduledFor(task, reminderDialog.getDate());
                    }
                }
            }
        };
        action.setText(LABEL_CALENDAR);
        action.setEnabled(this.canSchedule(singleSelection, taskListElementsToSchedule));
        subMenuManager.add((IAction)action);
        action = new Action(){

            public void run() {
                for (AbstractTaskContainer element : taskListElementsToSchedule) {
                    AbstractTask task = tasklistManager.getTaskForElement(element, true);
                    TasksUiPlugin.getTaskListManager().setScheduledFor(task, null);
                }
            }
        };
        action.setText(LABEL_NOT_SCHEDULED);
        if (singleTaskSelection != null && singleTaskSelection.getScheduledForDate() == null) {
            action.setChecked(true);
        }
        subMenuManager.add((IAction)action);
        return subMenuManager;
    }

    private void getDayLabel(int i, Action action) {
        switch (i) {
            case 2: {
                action.setText("Monday");
                break;
            }
            case 3: {
                action.setText("Tuesday");
                break;
            }
            case 4: {
                action.setText("Wednesday");
                break;
            }
            case 5: {
                action.setText("Thursday");
                break;
            }
            case 6: {
                action.setText("Friday");
                break;
            }
            case 7: {
                action.setText("Saturday");
                break;
            }
            case 8: {
                action.setText("Sunday");
                break;
            }
        }
    }

    private boolean canSchedule(AbstractTaskContainer singleSelection, List<AbstractTaskContainer> elements) {
        if (singleSelection instanceof AbstractTask) {
            return !((AbstractTask)singleSelection).isCompleted() || elements.size() > 0;
        }
        return elements.size() > 0;
    }
}

