/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui;

import java.util.Date;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.TaskList;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.RepositorySynchronizationManager;
import org.eclipse.mylyn.tasks.ui.TaskListManager;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScheduledTaskListSynchJob
extends Job {
    private static final int UPDATE_ATTRIBUTES_FREQUENCY = 10;
    private static final String LABEL_TASK = "Task Repository Synchronization";
    private static final String JOB_NAME = "Synchronizing repository tasks";
    private long scheduleDelay = 1200000L;
    private TaskList taskList = null;
    private static long count = 0L;
    private TaskListManager taskListManager;
    private List<TaskRepository> repositories = null;
    private boolean fullSynchronization = true;

    public ScheduledTaskListSynchJob(long schedule, TaskListManager taskListManager) {
        super(JOB_NAME);
        this.scheduleDelay = schedule;
        this.taskListManager = taskListManager;
        this.setSystem(true);
        this.setPriority(40);
    }

    public ScheduledTaskListSynchJob(TaskListManager taskListManager) {
        super(JOB_NAME);
        this.taskListManager = taskListManager;
        this.setPriority(40);
        this.scheduleDelay = -1L;
    }

    public boolean isFullSynchronization() {
        return this.fullSynchronization;
    }

    public void setFullSynchronization(boolean fullSynchronization) {
        this.fullSynchronization = fullSynchronization;
    }

    public IStatus run(IProgressMonitor monitor) {
        try {
            this.taskList = this.taskListManager.getTaskList();
            if (this.repositories == null) {
                this.repositories = TasksUiPlugin.getRepositoryManager().getAllRepositories();
            }
            monitor.beginTask(LABEL_TASK, this.repositories.size());
            for (final TaskRepository repository : this.repositories) {
                if (monitor.isCanceled()) {
                    this.scheduleDelay = -1L;
                    throw new OperationCanceledException();
                }
                if (repository.isOffline()) continue;
                final AbstractRepositoryConnector connector = TasksUiPlugin.getRepositoryManager().getRepositoryConnector(repository.getConnectorKind());
                if (connector == null) {
                    monitor.worked(1);
                    continue;
                }
                RepositorySynchronizationManager synchronizationManager = TasksUiPlugin.getSynchronizationManager();
                Set queries = this.taskList.getRepositoryQueries(repository.getUrl());
                try {
                    if (queries != null && queries.size() > 0 && connector.isRepositoryConfigurationStale(repository)) {
                        Job updateJob = new Job("Updating attributes for " + repository.getUrl()){

                            protected IStatus run(IProgressMonitor monitor) {
                                try {
                                    connector.updateAttributes(repository, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                    TasksUiPlugin.getRepositoryManager().saveRepositories(TasksUiPlugin.getDefault().getRepositoriesFilePath());
                                }
                                catch (Exception exception) {}
                                return Status.OK_STATUS;
                            }
                        };
                        updateJob.setPriority(30);
                        updateJob.schedule();
                        repository.setConfigurationDate(new Date());
                    }
                }
                catch (Exception exception) {}
                synchronizationManager.synchronize(connector, repository, queries, null, 50, 0L, false, this.fullSynchronization);
                monitor.worked(1);
            }
        }
        catch (Throwable throwable) {
            long l = count = count >= 10L ? 0L : count + 1L;
            if (monitor != null) {
                monitor.done();
            }
            throw throwable;
        }
        long l = count = count >= 10L ? 0L : count + 1L;
        if (monitor != null) {
            monitor.done();
        }
        return Status.OK_STATUS;
    }

    public void setSchedule(long schedule) {
        this.scheduleDelay = schedule;
    }

    public void setRepositories(List<TaskRepository> repositories) {
        this.repositories = repositories;
    }

    public static long getCount() {
        return count;
    }

    public static void resetCount() {
        try {
            if (TasksUiPlugin.getSynchronizationScheduler().getRefreshJob() != null) {
                TasksUiPlugin.getSynchronizationScheduler().getRefreshJob().join();
            }
            TasksUiPlugin.getSynchronizationScheduler().cancelAll();
            TasksUiPlugin.getSynchronizationScheduler().startSynchJob();
            count = 0L;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public long getScheduleDelay() {
        return this.scheduleDelay;
    }
}

