/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.mylyn.internal.tasks.ui.CompositeContainerImageDescriptor;
import org.eclipse.mylyn.internal.tasks.ui.CompositeSynchImageDescriptor;
import org.eclipse.mylyn.internal.tasks.ui.CompositeTaskImageDescriptor;
import org.eclipse.mylyn.internal.tasks.ui.TaskListImageDescriptor;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.swt.graphics.Image;

public class TasksUiImages {
    private static ImageRegistry imageRegistry;
    private static final String T_ELCL = "elcl16";
    private static final String T_EVIEW = "eview16";
    private static final String T_TOOL = "etool16";
    private static final String T_OBJ = "obj16";
    private static final String T_WIZBAN = "wizban";
    private static final String T_OVR = "ovr16";
    private static final URL baseURL;
    public static final ImageDescriptor TASK_ACTIVE;
    public static final ImageDescriptor TASK_ACTIVE_CENTERED;
    public static final ImageDescriptor TASK_INACTIVE;
    public static final ImageDescriptor TASK_INACTIVE_CONTEXT;
    public static final ImageDescriptor TASK_COMPLETE;
    public static final ImageDescriptor TASK_INCOMPLETE;
    public static final ImageDescriptor TASK;
    public static final ImageDescriptor TASK_COMPLETED;
    public static final ImageDescriptor TASK_NOTES;
    public static final ImageDescriptor TASK_NEW;
    public static final ImageDescriptor TASK_REPOSITORY_HISTORY;
    public static final ImageDescriptor TASK_REPOSITORY_NOTES;
    public static final ImageDescriptor TASK_REPOSITORY_COMPLETED;
    public static final ImageDescriptor TASK_REMOTE;
    public static final ImageDescriptor TASK_WORKING_SET;
    public static final ImageDescriptor TASKLIST;
    public static final ImageDescriptor REPOSITORY;
    public static final ImageDescriptor REPOSITORY_OFFLINE;
    public static final ImageDescriptor REPOSITORY_SUBMIT;
    public static final ImageDescriptor REPOSITORY_SMALL;
    public static final ImageDescriptor REPOSITORY_NEW;
    public static final ImageDescriptor REPOSITORIES;
    public static final ImageDescriptor REMOVE;
    public static final ImageDescriptor DELETE;
    public static final ImageDescriptor FILTER_COMPLETE;
    public static final ImageDescriptor FILTER_ARCHIVE;
    public static final ImageDescriptor FILTER_PRIORITY;
    public static final ImageDescriptor COLOR_PALETTE;
    public static final ImageDescriptor FILTER;
    public static final ImageDescriptor FIND_CLEAR;
    public static final ImageDescriptor FIND_CLEAR_DISABLED;
    public static final ImageDescriptor WARNING;
    public static final ImageDescriptor OVERLAY_WEB;
    public static final ImageDescriptor OVERLAY_OFFLINE;
    public static final ImageDescriptor BROWSER_SMALL;
    public static final ImageDescriptor BROWSER_OPEN_TASK;
    public static final ImageDescriptor OVERLAY_SYNCHRONIZING;
    public static final ImageDescriptor OVERLAY_HAS_DUE;
    public static final ImageDescriptor OVERLAY_OVER_DUE;
    public static final ImageDescriptor OVERLAY_SOLID_WHITE;
    public static final ImageDescriptor TASK_WEB_REMOTE;
    public static final ImageDescriptor CATEGORY;
    public static final ImageDescriptor CATEGORY_NEW;
    public static final ImageDescriptor CATEGORY_ARCHIVE;
    public static final ImageDescriptor QUERY_UNMATCHED;
    public static final ImageDescriptor TASK_REPOSITORY;
    public static final ImageDescriptor TASK_REPOSITORY_NEW;
    public static final ImageDescriptor TOOLBAR_ARROW_RIGHT;
    public static final ImageDescriptor TOOLBAR_ARROW_DOWN;
    public static final ImageDescriptor COMMENT;
    public static final ImageDescriptor LINK_EDITOR;
    public static final ImageDescriptor PERSON;
    public static final ImageDescriptor PERSON_NARROW;
    public static final ImageDescriptor PERSON_ME;
    public static final ImageDescriptor PERSON_ME_NARROW;
    public static final ImageDescriptor CONTEXT_FOCUS;
    public static final ImageDescriptor CONTEXT_ATTACH;
    public static final ImageDescriptor CONTEXT_RETRIEVE;
    public static final ImageDescriptor CONTEXT_TRANSFER;
    public static final ImageDescriptor CONTEXT_CLEAR;
    public static final ImageDescriptor ATTACHMENT_PATCH;
    public static final ImageDescriptor TASK_RETRIEVE;
    public static final ImageDescriptor OVERLAY_LOCAL_TASK;
    public static final ImageDescriptor OVERLAY_INCOMMING;
    public static final ImageDescriptor OVERLAY_INCOMMING_NEW;
    public static final ImageDescriptor OVERLAY_OUTGOING;
    public static final ImageDescriptor OVERLAY_SYNCH_INCOMMING;
    public static final ImageDescriptor OVERLAY_SYNCH_INCOMMING_NEW;
    public static final ImageDescriptor OVERLAY_SYNCH_OUTGOING;
    public static final ImageDescriptor OVERLAY_CONFLICT;
    public static final ImageDescriptor OVERLAY_REPOSITORY;
    public static final ImageDescriptor OVERLAY_REPOSITORY_CONTEXT;
    public static final ImageDescriptor OVERLAY_WARNING;
    public static final ImageDescriptor OVERLAY_BLANK;
    public static final ImageDescriptor STATUS_NORMAL;
    public static final ImageDescriptor STATUS_CONTEXT;
    public static final ImageDescriptor QUERY;
    public static final ImageDescriptor QUERY_NEW;
    public static final ImageDescriptor REPOSITORY_SYNCHRONIZE;
    public static final ImageDescriptor NAVIGATE_PREVIOUS;
    public static final ImageDescriptor NAVIGATE_PREVIOUS_PAUSE;
    public static final ImageDescriptor NAVIGATE_PREVIOUS_ACTIVE;
    public static final ImageDescriptor CAPTURE_PAUSE;
    public static final ImageDescriptor NAVIGATE_NEXT;
    public static final ImageDescriptor TASKLIST_MODE;
    public static final ImageDescriptor TASK_GROUPING;
    public static final ImageDescriptor COPY;
    public static final ImageDescriptor GO_UP;
    public static final ImageDescriptor GO_INTO;
    public static final ImageDescriptor REFRESH;
    public static final ImageDescriptor REFRESH_SMALL;
    public static final ImageDescriptor COLLAPSE_ALL;
    public static final ImageDescriptor NOTIFICATION_CLOSE;
    public static final ImageDescriptor EXPAND_ALL;
    public static final ImageDescriptor REPLY;
    public static final ImageDescriptor PRIORITY_1;
    public static final ImageDescriptor PRIORITY_2;
    public static final ImageDescriptor PRIORITY_3;
    public static final ImageDescriptor PRIORITY_4;
    public static final ImageDescriptor PRIORITY_5;
    public static final ImageDescriptor CALENDAR;
    public static final ImageDescriptor CALENDAR_SMALL;
    public static final ImageDescriptor BANNER_REPOSITORY;
    public static final ImageDescriptor BANNER_SCREENSHOT;
    public static final ImageDescriptor BANNER_WORKING_SET;
    public static final ImageDescriptor BANNER_REPOSITORY_SETTINGS;
    public static final ImageDescriptor BANNER_REPOSITORY_CONTEXT;
    public static final ImageDescriptor BANNER_IMPORT;
    public static final ImageDescriptor BLANK_TINY;
    public static final ImageDescriptor BLANK;
    public static final ImageDescriptor IMAGE_CAPTURE;
    public static final ImageDescriptor IMAGE_FIT;
    public static final ImageDescriptor IMAGE_FILE;
    public static final ImageDescriptor NEW_SUB_TASK;
    public static final ImageDescriptor QUESTION;
    private static Image[] progressImages;

    static {
        baseURL = TasksUiPlugin.getDefault().getBundle().getEntry("/icons/");
        TASK_ACTIVE = TasksUiImages.create(T_TOOL, "task-active.gif");
        TASK_ACTIVE_CENTERED = TasksUiImages.create(T_TOOL, "task-active-centered.gif");
        TASK_INACTIVE = TasksUiImages.create(T_TOOL, "task-inactive.gif");
        TASK_INACTIVE_CONTEXT = TasksUiImages.create(T_TOOL, "task-context.gif");
        TASK_COMPLETE = TasksUiImages.create(T_TOOL, "task-complete.gif");
        TASK_INCOMPLETE = TasksUiImages.create(T_TOOL, "task-incomplete.gif");
        TASK = TasksUiImages.create(T_TOOL, "task.gif");
        TASK_COMPLETED = TasksUiImages.create(T_TOOL, "task-completed.gif");
        TASK_NOTES = TasksUiImages.create(T_TOOL, "task-notes.gif");
        TASK_NEW = TasksUiImages.create(T_TOOL, "task-new.gif");
        TASK_REPOSITORY_HISTORY = TasksUiImages.create(T_TOOL, "task-repository-history.gif");
        TASK_REPOSITORY_NOTES = TasksUiImages.create(T_TOOL, "task-repository-notes.gif");
        TASK_REPOSITORY_COMPLETED = TasksUiImages.create(T_TOOL, "task-repository-completed.gif");
        TASK_REMOTE = TasksUiImages.create(T_TOOL, "task-remote.gif");
        TASK_WORKING_SET = TasksUiImages.create(T_TOOL, "open-task.gif");
        TASKLIST = TasksUiImages.create(T_EVIEW, "task-list.gif");
        REPOSITORY = TasksUiImages.create(T_EVIEW, "repository.gif");
        REPOSITORY_OFFLINE = ImageDescriptor.createWithFlags((ImageDescriptor)REPOSITORY, (int)2);
        REPOSITORY_SUBMIT = TasksUiImages.create(T_TOOL, "repository-submit.gif");
        REPOSITORY_SMALL = TasksUiImages.create(T_OBJ, "repository-small.gif");
        REPOSITORY_NEW = TasksUiImages.create(T_TOOL, "repository-new.gif");
        REPOSITORIES = TasksUiImages.create(T_EVIEW, "repositories.gif");
        REMOVE = TasksUiImages.create(T_ELCL, "remove.gif");
        DELETE = TasksUiImages.create(T_ELCL, "delete.gif");
        FILTER_COMPLETE = TasksUiImages.create(T_ELCL, "filter-complete.gif");
        FILTER_ARCHIVE = TasksUiImages.create(T_ELCL, "filter-archive.gif");
        FILTER_PRIORITY = TasksUiImages.create(T_ELCL, "filter-priority.gif");
        COLOR_PALETTE = TasksUiImages.create(T_ELCL, "color-palette.gif");
        FILTER = TasksUiImages.create(T_TOOL, "view-filter.gif");
        FIND_CLEAR = TasksUiImages.create(T_TOOL, "find-clear.gif");
        FIND_CLEAR_DISABLED = TasksUiImages.create(T_TOOL, "find-clear-disabled.gif");
        WARNING = TasksUiImages.create(T_ELCL, "warning.gif");
        OVERLAY_WEB = TasksUiImages.create(T_TOOL, "overlay-web.gif");
        OVERLAY_OFFLINE = TasksUiImages.create(T_EVIEW, "overlay-offline.gif");
        BROWSER_SMALL = TasksUiImages.create(T_OBJ, "browser-small.gif");
        BROWSER_OPEN_TASK = TasksUiImages.create(T_TOOL, "open-browser.gif");
        OVERLAY_SYNCHRONIZING = TasksUiImages.create(T_EVIEW, "overlay-synchronizing.gif");
        OVERLAY_HAS_DUE = TasksUiImages.create(T_EVIEW, "overlay-has-due.gif");
        OVERLAY_OVER_DUE = TasksUiImages.create(T_EVIEW, "overlay-overdue.gif");
        OVERLAY_SOLID_WHITE = TasksUiImages.create(T_OVR, "solid-white.gif");
        TASK_WEB_REMOTE = TasksUiImages.create(T_TOOL, "overlay-web.gif");
        CATEGORY = TasksUiImages.create(T_TOOL, "category.gif");
        CATEGORY_NEW = TasksUiImages.create(T_TOOL, "category-new.gif");
        CATEGORY_ARCHIVE = TasksUiImages.create(T_TOOL, "category-archive.gif");
        QUERY_UNMATCHED = TasksUiImages.create(T_TOOL, "query-unmatched.gif");
        TASK_REPOSITORY = TasksUiImages.create(T_TOOL, "task-repository.gif");
        TASK_REPOSITORY_NEW = TasksUiImages.create(T_TOOL, "task-repository-new.gif");
        TOOLBAR_ARROW_RIGHT = TasksUiImages.create(T_TOOL, "toolbar-arrow-right.gif");
        TOOLBAR_ARROW_DOWN = TasksUiImages.create(T_TOOL, "toolbar-arrow-down.gif");
        COMMENT = TasksUiImages.create(T_TOOL, "comment.gif");
        LINK_EDITOR = TasksUiImages.create(T_TOOL, "link-editor.gif");
        PERSON = TasksUiImages.create(T_TOOL, "person.gif");
        PERSON_NARROW = TasksUiImages.create(T_TOOL, "person-narrow.gif");
        PERSON_ME = TasksUiImages.create(T_TOOL, "person-me.gif");
        PERSON_ME_NARROW = TasksUiImages.create(T_TOOL, "person-me-narrow.gif");
        CONTEXT_FOCUS = TasksUiImages.create(T_EVIEW, "focus-view.gif");
        CONTEXT_ATTACH = TasksUiImages.create(T_TOOL, "context-attach.gif");
        CONTEXT_RETRIEVE = TasksUiImages.create(T_TOOL, "context-retrieve.gif");
        CONTEXT_TRANSFER = TasksUiImages.create(T_TOOL, "context-transfer.gif");
        CONTEXT_CLEAR = TasksUiImages.create(T_TOOL, "context-clear.gif");
        ATTACHMENT_PATCH = TasksUiImages.create(T_OBJ, "attachment-patch.gif");
        TASK_RETRIEVE = TasksUiImages.create(T_TOOL, "task-retrieve.gif");
        OVERLAY_LOCAL_TASK = TasksUiImages.create(T_OVR, "overlay-local-task.gif");
        OVERLAY_INCOMMING = TasksUiImages.create(T_EVIEW, "overlay-incoming.gif");
        OVERLAY_INCOMMING_NEW = TasksUiImages.create(T_EVIEW, "overlay-incoming-new.gif");
        OVERLAY_OUTGOING = TasksUiImages.create(T_EVIEW, "overlay-outgoing.gif");
        OVERLAY_SYNCH_INCOMMING = TasksUiImages.create(T_EVIEW, "overlay-synch-incoming.gif");
        OVERLAY_SYNCH_INCOMMING_NEW = TasksUiImages.create(T_EVIEW, "overlay-synch-incoming-new.gif");
        OVERLAY_SYNCH_OUTGOING = TasksUiImages.create(T_EVIEW, "overlay-synch-outgoing.gif");
        OVERLAY_CONFLICT = TasksUiImages.create(T_EVIEW, "overlay-conflicting.gif");
        OVERLAY_REPOSITORY = TasksUiImages.create(T_EVIEW, "overlay-repository.gif");
        OVERLAY_REPOSITORY_CONTEXT = TasksUiImages.create(T_EVIEW, "overlay-repository-context.gif");
        OVERLAY_WARNING = TasksUiImages.create(T_OVR, "overlay-warning.gif");
        OVERLAY_BLANK = TasksUiImages.create(T_OVR, "overlay-blank.gif");
        STATUS_NORMAL = TasksUiImages.create(T_EVIEW, "status-normal.gif");
        STATUS_CONTEXT = TasksUiImages.create(T_EVIEW, "status-server-context.gif");
        QUERY = TasksUiImages.create(T_TOOL, "query.gif");
        QUERY_NEW = TasksUiImages.create(T_TOOL, "query-new.gif");
        REPOSITORY_SYNCHRONIZE = TasksUiImages.create(T_TOOL, "repository-synchronize.gif");
        NAVIGATE_PREVIOUS = TasksUiImages.create(T_TOOL, "navigate-previous.gif");
        NAVIGATE_PREVIOUS_PAUSE = TasksUiImages.create(T_TOOL, "navigate-previous-pause.gif");
        NAVIGATE_PREVIOUS_ACTIVE = TasksUiImages.create(T_TOOL, "navigate-previous-active.gif");
        CAPTURE_PAUSE = TasksUiImages.create(T_TOOL, "capture-pause.gif");
        NAVIGATE_NEXT = TasksUiImages.create(T_TOOL, "navigate-next.gif");
        TASKLIST_MODE = TasksUiImages.create(T_TOOL, "presentation.gif");
        TASK_GROUPING = TasksUiImages.create(T_TOOL, "grouping.gif");
        COPY = TasksUiImages.create(T_TOOL, "copy.png");
        GO_UP = TasksUiImages.create(T_TOOL, "go-up.gif");
        GO_INTO = TasksUiImages.create(T_TOOL, "go-into.gif");
        REFRESH = TasksUiImages.create(T_ELCL, "refresh.gif");
        REFRESH_SMALL = TasksUiImages.create(T_ELCL, "refresh-small.gif");
        COLLAPSE_ALL = TasksUiImages.create(T_ELCL, "collapseall.png");
        NOTIFICATION_CLOSE = TasksUiImages.create(T_EVIEW, "notification-close.gif");
        EXPAND_ALL = TasksUiImages.create(T_ELCL, "expandall.gif");
        REPLY = TasksUiImages.create(T_ELCL, "reply.gif");
        PRIORITY_1 = TasksUiImages.create(T_EVIEW, "priority-1.gif");
        PRIORITY_2 = TasksUiImages.create(T_EVIEW, "priority-2.gif");
        PRIORITY_3 = TasksUiImages.create(T_EVIEW, "priority-3.gif");
        PRIORITY_4 = TasksUiImages.create(T_EVIEW, "priority-4.gif");
        PRIORITY_5 = TasksUiImages.create(T_EVIEW, "priority-5.gif");
        CALENDAR = TasksUiImages.create(T_TOOL, "calendar.gif");
        CALENDAR_SMALL = TasksUiImages.create(T_OBJ, "calendar-small.gif");
        BANNER_REPOSITORY = TasksUiImages.create(T_WIZBAN, "banner-repository.gif");
        BANNER_SCREENSHOT = TasksUiImages.create(T_WIZBAN, "banner-screenshot.png");
        BANNER_WORKING_SET = TasksUiImages.create(T_WIZBAN, "workset_wiz.png");
        BANNER_REPOSITORY_SETTINGS = TasksUiImages.create(T_WIZBAN, "banner-repository-settings.gif");
        BANNER_REPOSITORY_CONTEXT = TasksUiImages.create(T_WIZBAN, "banner-repository-context.gif");
        BANNER_IMPORT = TasksUiImages.create(T_WIZBAN, "banner-import.gif");
        BLANK_TINY = TasksUiImages.create(T_ELCL, "clearDot.gif");
        BLANK = TasksUiImages.create(T_ELCL, "blank.gif");
        IMAGE_CAPTURE = TasksUiImages.create(T_TOOL, "capture-screen.png");
        IMAGE_FIT = TasksUiImages.create(T_TOOL, "capture-fit.png");
        IMAGE_FILE = TasksUiImages.create(T_OBJ, "file-image.gif");
        NEW_SUB_TASK = TasksUiImages.create(T_TOOL, "sub-task-new.gif");
        QUESTION = TasksUiImages.create(T_OBJ, "question.gif");
    }

    private static ImageDescriptor create(String prefix, String name) {
        try {
            return ImageDescriptor.createFromURL((URL)TasksUiImages.makeIconFileURL(prefix, name));
        }
        catch (MalformedURLException malformedURLException) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    public static Image getImage(ImageDescriptor imageDescriptor) {
        ImageRegistry imageRegistry = TasksUiImages.getImageRegistry();
        Image image = imageRegistry.get("" + imageDescriptor.hashCode());
        if (image == null) {
            image = imageDescriptor.createImage(true);
            imageRegistry.put("" + imageDescriptor.hashCode(), image);
        }
        return image;
    }

    public static Image getImageWithOverlay(ImageDescriptor icon, ImageDescriptor overlay, boolean top, boolean left) {
        if (icon == null) {
            return null;
        }
        String key = "" + icon.hashCode();
        if (overlay != null) {
            key = String.valueOf(key) + overlay.hashCode();
        }
        key = String.valueOf(key) + new Boolean(top).hashCode();
        key = String.valueOf(key) + new Boolean(left).hashCode();
        Image image = TasksUiImages.getImageRegistry().get(key);
        if (image == null) {
            TaskListImageDescriptor imageDescriptor = new TaskListImageDescriptor(icon, overlay, top, left);
            image = imageDescriptor.createImage(true);
            TasksUiImages.getImageRegistry().put(key, image);
        }
        return image;
    }

    public static Image getCompositeTaskImage(ImageDescriptor icon, ImageDescriptor overlayKind, boolean wide) {
        Image image;
        if (icon == null) {
            return null;
        }
        String key = "" + icon.hashCode();
        if (overlayKind != null) {
            key = String.valueOf(key) + overlayKind.hashCode();
        }
        if (wide) {
            key = String.valueOf(key) + ".wide";
        }
        if ((image = TasksUiImages.getImageRegistry().get(key)) == null) {
            CompositeTaskImageDescriptor imageDescriptor = new CompositeTaskImageDescriptor(icon, overlayKind, wide);
            image = imageDescriptor.createImage(true);
            TasksUiImages.getImageRegistry().put(key, image);
        }
        return image;
    }

    public static Image getCompositeContainerImage(ImageDescriptor icon, boolean wide) {
        Image image;
        if (icon == null) {
            return null;
        }
        String key = "" + icon.hashCode();
        if (wide) {
            key = String.valueOf(key) + ".wide";
        }
        if ((image = TasksUiImages.getImageRegistry().get(key)) == null) {
            CompositeContainerImageDescriptor imageDescriptor = new CompositeContainerImageDescriptor(icon, OVERLAY_BLANK, wide);
            image = imageDescriptor.createImage(true);
            TasksUiImages.getImageRegistry().put(key, image);
        }
        return image;
    }

    public static Image getCompositeSynchImage(ImageDescriptor icon, boolean background) {
        Image image;
        String key = "" + icon.hashCode();
        if (background) {
            key = String.valueOf(key) + ".background";
        }
        if ((image = TasksUiImages.getImageRegistry().get(key)) == null) {
            CompositeSynchImageDescriptor imageDescriptor = new CompositeSynchImageDescriptor(icon, background);
            image = imageDescriptor.createImage(true);
            TasksUiImages.getImageRegistry().put(key, image);
        }
        return image;
    }

    private static ImageRegistry getImageRegistry() {
        if (imageRegistry == null) {
            imageRegistry = new ImageRegistry();
        }
        return imageRegistry;
    }

    private static URL makeIconFileURL(String prefix, String name) throws MalformedURLException {
        if (baseURL == null) {
            throw new MalformedURLException();
        }
        StringBuffer buffer = new StringBuffer(prefix);
        buffer.append('/');
        buffer.append(name);
        return new URL(baseURL, buffer.toString());
    }

    public static Image[] getProgressImages() {
        if (progressImages != null) {
            return progressImages;
        }
        progressImages = new Image[8];
        int i = 1;
        while (i <= 8) {
            ImageDescriptor imageDescriptor = TasksUiImages.create("eview16/progress", String.valueOf(i) + ".png");
            TasksUiImages.progressImages[i - 1] = TasksUiImages.getImage(imageDescriptor);
            ++i;
        }
        return progressImages;
    }

    public static Image getImageForPriority(AbstractTask.PriorityLevel priorityLevel) {
        if (priorityLevel == null) {
            return null;
        }
        ImageDescriptor imageDescriptor = TasksUiImages.getImageDescriptorForPriority(priorityLevel);
        if (imageDescriptor != null) {
            return TasksUiImages.getImage(imageDescriptor);
        }
        return null;
    }

    public static ImageDescriptor getImageDescriptorForPriority(AbstractTask.PriorityLevel priorityLevel) {
        if (priorityLevel == null) {
            return null;
        }
        switch (priorityLevel) {
            case P1: {
                return PRIORITY_1;
            }
            case P2: {
                return PRIORITY_2;
            }
            case P3: {
                return PRIORITY_3;
            }
            case P4: {
                return PRIORITY_4;
            }
            case P5: {
                return PRIORITY_5;
            }
        }
        return null;
    }
}

