/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import org.eclipse.jface.wizard.IWizard;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.internal.tasks.ui.actions.AbstractTaskEditorAction;
import org.eclipse.mylyn.internal.tasks.ui.wizards.NewAttachmentWizard;
import org.eclipse.mylyn.internal.tasks.ui.wizards.NewAttachmentWizardDialog;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.ui.PlatformUI;

public class AttachScreenshotAction
extends AbstractTaskEditorAction {
    public static final String LABEL = "Attach Screenshot...";

    public AttachScreenshotAction() {
        super(LABEL);
        this.setId("org.eclipse.mylyn.tasks.ui.actions.add.screenshot");
        this.setImageDescriptor(TasksUiImages.IMAGE_CAPTURE);
    }

    public void run() {
        Object selection;
        if (this.editor != null) {
            this.editor.showBusy(true);
        }
        if ((selection = super.getStructuredSelection().getFirstElement()) instanceof AbstractTask) {
            if (this.taskDirty((AbstractTask)selection)) {
                this.openInformationDialog(LABEL, "Submit changes or synchronize task before adding attachments.");
                return;
            }
            AbstractTask repositoryTask = (AbstractTask)selection;
            TaskRepository repository = TasksUiPlugin.getRepositoryManager().getRepository(repositoryTask.getConnectorKind(), repositoryTask.getRepositoryUrl());
            NewAttachmentWizard attachmentWizard = new NewAttachmentWizard(repository, repositoryTask, true);
            NewAttachmentWizardDialog dialog = new NewAttachmentWizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)attachmentWizard, false);
            attachmentWizard.setDialog(dialog);
            dialog.create();
            int result = dialog.open();
            if (result != 0 && this.editor != null) {
                this.editor.showBusy(false);
            }
        }
    }
}

