/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.internal.tasks.ui.actions.CopyTaskDetailsAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.NewTaskAction;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.RepositoryTaskData;
import org.eclipse.mylyn.tasks.core.TaskSelection;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.swt.SWT;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

public class CloneTaskAction
extends BaseSelectionListenerAction
implements IViewActionDelegate {
    private static final String LABEL = "Clone This Task";
    private static final String ID = "org.eclipse.mylyn.tasklist.actions.clone";
    protected ISelection selection;

    public CloneTaskAction() {
        super(LABEL);
        this.setId(ID);
        this.setImageDescriptor(TasksUiImages.TASK_NEW);
        this.setAccelerator(SWT.MOD1 + 100);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            super.selectionChanged((IStructuredSelection)selection);
        }
    }

    public void run(IAction action) {
        this.run();
    }

    public void run() {
        try {
            for (Object selectedObject : this.getStructuredSelection().toList()) {
                TaskSelection taskSelection;
                if (!(selectedObject instanceof AbstractTask)) continue;
                AbstractTask task = (AbstractTask)selectedObject;
                String description = "Clone of " + CopyTaskDetailsAction.getTextForTask(task);
                RepositoryTaskData taskData = TasksUiPlugin.getTaskDataManager().getNewTaskData(task.getRepositoryUrl(), task.getTaskId());
                if (taskData != null) {
                    taskSelection = new TaskSelection(taskData);
                    taskSelection.getTaskData().setDescription(String.valueOf(description) + "\n\n> " + taskData.getDescription());
                } else {
                    taskSelection = new TaskSelection(task);
                    taskSelection.getTaskData().setDescription(description);
                }
                NewTaskAction action = new NewTaskAction();
                if (action.showWizard(taskSelection) == 0) continue;
                return;
            }
        }
        catch (NullPointerException npe) {
            StatusHandler.fail((Throwable)npe, (String)"Could not remove task from category, it may still be refreshing.", (boolean)true);
        }
    }

    public void init(IViewPart view) {
    }
}

