/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.internal.tasks.ui.editors.RepositoryTaskSelection;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryQuery;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

public class CopyTaskDetailsAction
extends BaseSelectionListenerAction {
    private static final String LABEL = "Copy Details";
    public static final String ID = "org.eclipse.mylyn.tasklist.actions.copy";
    private Clipboard clipboard;

    public CopyTaskDetailsAction(boolean setAccelerator) {
        super(LABEL);
        this.setToolTipText(LABEL);
        this.setId(ID);
        this.setImageDescriptor(TasksUiImages.COPY);
        if (setAccelerator) {
            this.setAccelerator(SWT.MOD1 + 99);
        }
        Display display = PlatformUI.getWorkbench().getDisplay();
        this.clipboard = new Clipboard(display);
    }

    public void run() {
        IStructuredSelection selection = super.getStructuredSelection();
        Object object = selection.getFirstElement();
        String text = CopyTaskDetailsAction.getTextForTask(object);
        TextTransfer textTransfer = TextTransfer.getInstance();
        if (text != null && !text.equals("")) {
            this.clipboard.setContents(new Object[]{text}, new Transfer[]{textTransfer});
        }
    }

    public static String getTextForTask(Object object) {
        String text = "";
        if (object instanceof AbstractTask) {
            AbstractTask task = null;
            if (object instanceof AbstractTask) {
                task = (AbstractTask)object;
            }
            if (task != null) {
                text = String.valueOf(text) + task.getTaskKey() + ": ";
                text = String.valueOf(text) + task.getSummary();
                if (task.hasValidUrl()) {
                    text = String.valueOf(text) + "\n" + task.getUrl();
                }
            }
        } else if (object instanceof AbstractRepositoryQuery) {
            AbstractRepositoryQuery query = (AbstractRepositoryQuery)object;
            text = String.valueOf(text) + query.getSummary();
            text = String.valueOf(text) + "\n" + query.getUrl();
        } else if (object instanceof AbstractTaskContainer) {
            AbstractTaskContainer element = (AbstractTaskContainer)object;
            text = element.getSummary();
        } else if (object instanceof RepositoryTaskSelection) {
            RepositoryTaskSelection selection = (RepositoryTaskSelection)object;
            text = String.valueOf(text) + selection.getId() + ": " + selection.getBugSummary();
            AbstractRepositoryConnector connector = TasksUiPlugin.getRepositoryManager().getRepositoryConnector(selection.getRepositoryKind());
            text = connector != null ? String.valueOf(text) + "\n" + connector.getTaskUrl(selection.getRepositoryUrl(), selection.getId()) : String.valueOf(text) + "\n" + selection.getRepositoryUrl();
        }
        return text;
    }
}

