/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.AbstractAttributeFactory;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.AbstractTaskDataHandler;
import org.eclipse.mylyn.tasks.core.RepositoryTaskData;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.mylyn.tasks.ui.editors.NewTaskEditorInput;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class NewSubTaskAction
extends Action
implements IViewActionDelegate,
IExecutableExtension {
    private static final String TOOLTIP = "Create a new subtask";
    private static final String LABEL = "Subtask";
    public static final String ID = "org.eclipse.mylyn.tasks.ui.new.subtask";
    private AbstractTask selectedTask;

    public NewSubTaskAction() {
        super(LABEL);
        this.setToolTipText(TOOLTIP);
        this.setId(ID);
        this.setImageDescriptor(TasksUiImages.NEW_SUB_TASK);
    }

    public void run() {
        if (this.selectedTask == null) {
            return;
        }
        AbstractRepositoryConnector connector = TasksUiPlugin.getRepositoryManager().getRepositoryConnector(this.selectedTask.getConnectorKind());
        final AbstractTaskDataHandler taskDataHandler = connector.getTaskDataHandler();
        if (taskDataHandler == null) {
            return;
        }
        String repositoryUrl = this.selectedTask.getRepositoryUrl();
        final RepositoryTaskData selectedTaskData = TasksUiPlugin.getTaskDataManager().getNewTaskData(repositoryUrl, this.selectedTask.getTaskId());
        if (selectedTaskData == null) {
            StatusHandler.displayStatus((String)"Unable to create subtask", (IStatus)new Status(2, "org.eclipse.mylyn.tasks.ui", "Could not retrieve task data for task: " + this.selectedTask.getUrl()));
            return;
        }
        if (!taskDataHandler.canInitializeSubTaskData(this.selectedTask, selectedTaskData)) {
            return;
        }
        final TaskRepository taskRepository = TasksUiPlugin.getRepositoryManager().getRepository(repositoryUrl);
        AbstractAttributeFactory attributeFactory = taskDataHandler.getAttributeFactory(taskRepository.getUrl(), taskRepository.getConnectorKind(), "task");
        final RepositoryTaskData taskData = new RepositoryTaskData(attributeFactory, this.selectedTask.getConnectorKind(), taskRepository.getUrl(), TasksUiPlugin.getDefault().getNextNewRepositoryTaskId());
        taskData.setNew(true);
        final boolean[] result = new boolean[1];
        IProgressService service = PlatformUI.getWorkbench().getProgressService();
        try {
            service.busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        result[0] = taskDataHandler.initializeSubTaskData(taskRepository, taskData, selectedTaskData, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            StatusHandler.displayStatus((String)"Unable to create subtask", (IStatus)((CoreException)e.getCause()).getStatus());
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        if (result[0]) {
            NewTaskEditorInput editorInput = new NewTaskEditorInput(taskRepository, taskData);
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            TasksUiUtil.openEditor(editorInput, "org.eclipse.mylyn.tasks.ui.editors.task", page);
        } else {
            StatusHandler.displayStatus((String)"Unable to create subtask", (IStatus)new Status(1, "org.eclipse.mylyn.tasks.ui", "The connector does not support creating subtasks for this task"));
        }
    }

    public void run(IAction action) {
        this.run();
    }

    public void init(IViewPart view) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object selectedObject;
        this.selectedTask = null;
        if (selection instanceof StructuredSelection && (selectedObject = ((StructuredSelection)selection).getFirstElement()) instanceof AbstractTask) {
            this.selectedTask = (AbstractTask)selectedObject;
            AbstractRepositoryConnector connector = TasksUiPlugin.getRepositoryManager().getRepositoryConnector(this.selectedTask.getConnectorKind());
            AbstractTaskDataHandler taskDataHandler = connector.getTaskDataHandler();
            if (taskDataHandler == null || !taskDataHandler.canInitializeSubTaskData(this.selectedTask, null)) {
                this.selectedTask = null;
            }
        }
        action.setEnabled(this.selectedTask != null);
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
    }
}

