/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mylyn.internal.tasks.ui.actions.TaskActivateAction;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskActivationHistory;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskElementLabelProvider;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;

public abstract class TaskNavigateDropDownAction
extends Action
implements IMenuCreator {
    protected TaskActivationHistory taskHistory;
    protected Menu dropDownMenu = null;
    protected TaskElementLabelProvider labelProvider = new TaskElementLabelProvider(false);
    protected static final int MAX_ITEMS_TO_DISPLAY = 12;

    public TaskNavigateDropDownAction(TaskActivationHistory history) {
        this.taskHistory = history;
        this.setMenuCreator(this);
    }

    public void dispose() {
        if (this.dropDownMenu != null) {
            this.dropDownMenu.dispose();
            this.dropDownMenu = null;
        }
    }

    public Menu getMenu(Control parent) {
        if (this.dropDownMenu != null) {
            this.dropDownMenu.dispose();
        }
        this.dropDownMenu = new Menu(parent);
        this.addActionsToMenu();
        return this.dropDownMenu;
    }

    public Menu getMenu(Menu parent) {
        if (this.dropDownMenu != null) {
            this.dropDownMenu.dispose();
        }
        this.dropDownMenu = new Menu(parent);
        this.addActionsToMenu();
        return this.dropDownMenu;
    }

    public void setButtonStatus() {
        this.setEnabled(this.taskHistory.getPreviousTasks() != null && this.taskHistory.getPreviousTasks().size() > 0);
    }

    protected abstract void addActionsToMenu();

    public class TaskNavigateAction
    extends Action {
        private AbstractTask targetTask;
        private static final int MAX_LABEL_LENGTH = 70;

        public TaskNavigateAction(AbstractTask task) {
            this.targetTask = task;
            String taskDescription = task.getSummary();
            if (taskDescription.length() > 70) {
                taskDescription = taskDescription.subSequence(0, 67) + "...";
            }
            this.setText(taskDescription);
            this.setEnabled(true);
            this.setToolTipText(task.getSummary());
            Image image = TaskNavigateDropDownAction.this.labelProvider.getImage(task);
            this.setImageDescriptor(ImageDescriptor.createFromImage((Image)image));
        }

        public void run() {
            if (this.targetTask.isActive()) {
                return;
            }
            new TaskActivateAction().run(this.targetTask);
            TaskNavigateDropDownAction.this.setButtonStatus();
        }
    }
}

