/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.commands;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.mylyn.internal.tasks.ui.wizards.NewRepositoryWizard;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.AbstractRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class AddTaskRepositoryHandler
extends AbstractHandler {
    private static final String PREF_ADD_QUERY = "org.eclipse.mylyn.internal.tasks.add.query";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        String param = event.getParameter("org.eclipse.mylyn.tasks.command.taskRepositoryId");
        NewRepositoryWizard repositoryWizard = new NewRepositoryWizard(param);
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        if (shell != null && !shell.isDisposed()) {
            IPreferenceStore preferenceStore;
            WizardDialog repositoryDialog = new WizardDialog(shell, (IWizard)repositoryWizard);
            repositoryDialog.create();
            repositoryDialog.getShell().setText("Add Task Repository");
            repositoryDialog.setBlockOnOpen(true);
            repositoryDialog.open();
            if (repositoryDialog.getReturnCode() == 0 && !(preferenceStore = TasksUiPlugin.getDefault().getPreferenceStore()).getBoolean(PREF_ADD_QUERY)) {
                MessageDialogWithToggle messageDialog = MessageDialogWithToggle.openYesNoQuestion((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)"Add new query", (String)"Would you like to add a query to the Task List for this repository?", (String)"Do not show again", (boolean)false, (IPreferenceStore)preferenceStore, (String)PREF_ADD_QUERY);
                preferenceStore.setValue(PREF_ADD_QUERY, messageDialog.getToggleState());
                if (messageDialog.getReturnCode() == 2) {
                    TaskRepository taskRepository = repositoryWizard.getRepository();
                    AbstractRepositoryConnectorUi connectorUi = TasksUiPlugin.getConnectorUi(taskRepository.getConnectorKind());
                    IWizard queryWizard = connectorUi.getQueryWizard(taskRepository, null);
                    ((Wizard)queryWizard).setForcePreviousAndNextButtons(true);
                    WizardDialog queryDialog = new WizardDialog(shell, queryWizard);
                    queryDialog.create();
                    queryDialog.setTitle("Add Repository Query");
                    queryDialog.setBlockOnOpen(true);
                    queryDialog.open();
                }
            }
        }
        return null;
    }
}

