/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import org.eclipse.mylyn.internal.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.internal.tasks.ui.editors.IBusyEditor;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchPlugin;

public class EditorBusyIndicator {
    public static final int DELAY = 90;
    private Animator animator;
    private final IBusyEditor editor;
    private Image[] images;
    private Image oldImage;

    public EditorBusyIndicator(IBusyEditor editor) {
        this.editor = editor;
    }

    public void start() {
        if (this.animator != null) {
            this.stop();
        }
        try {
            if (this.images == null) {
                this.images = TasksUiImages.getProgressImages();
                if (this.images == null) {
                    return;
                }
            }
            this.oldImage = this.editor.getTitleImage();
            if (this.images.length > 1) {
                this.animator = new Animator(this.images);
                this.animator.run();
            }
        }
        catch (SWTException e) {
            WorkbenchPlugin.log((Throwable)e);
        }
    }

    public void stop() {
        if (this.animator != null) {
            this.animator.stop();
            this.animator = null;
            this.updateTitleImage(this.oldImage);
            this.oldImage = null;
        }
    }

    private boolean updateTitleImage(Image image) {
        if (!PlatformUI.getWorkbench().isClosing()) {
            if (image != null && !image.isDisposed()) {
                this.editor.setTitleImage(image);
                return true;
            }
            if (this.oldImage != null && !this.oldImage.isDisposed()) {
                this.editor.setTitleImage(this.oldImage);
            }
        }
        return false;
    }

    private class Animator
    implements Runnable {
        int imageDataIndex = 0;
        private final Image[] images;
        private boolean stopped;

        public Animator(Image[] images) {
            this.images = images;
        }

        public void run() {
            if (this.stopped) {
                return;
            }
            try {
                Image image = this.images[this.imageDataIndex];
                this.imageDataIndex = (this.imageDataIndex + 1) % this.images.length;
                if (EditorBusyIndicator.this.updateTitleImage(image)) {
                    PlatformUI.getWorkbench().getDisplay().timerExec(90, (Runnable)this);
                }
            }
            catch (Exception e) {
                WorkbenchPlugin.log((Throwable)e);
            }
        }

        public void stop() {
            this.stopped = true;
        }
    }
}

