/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SpellingDialog
extends Dialog {
    private String title;
    private Text wordToFix;
    private List suggestions;
    private IDocument document;
    private ICompletionProposal[] proposals;

    protected SpellingDialog(Shell parentShell, String title, IDocument document) {
        super(parentShell);
        this.title = title;
        this.document = document;
    }

    protected Control createDialogArea(Composite parent) {
        Control c = super.createDialogArea(parent);
        Composite spellingComposite = new Composite(parent, 0);
        GridLayout spellingLayout = new GridLayout();
        spellingLayout.numColumns = 1;
        spellingComposite.setLayout((Layout)spellingLayout);
        this.wordToFix = new Text(spellingComposite, 2056);
        GridData gd = new GridData(32);
        gd.widthHint = 150;
        this.wordToFix.setLayoutData((Object)gd);
        this.suggestions = new List(spellingComposite, 2048);
        gd = new GridData(32);
        gd.widthHint = 150;
        gd.heightHint = 120;
        this.suggestions.setLayoutData((Object)gd);
        return c;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.title);
    }

    public void open(String word, ICompletionProposal[] proposals) {
        this.create();
        this.proposals = proposals;
        this.wordToFix.setText(word);
        this.suggestions.removeAll();
        int i = 0;
        while (i < proposals.length) {
            this.suggestions.setItem(i, proposals[i].getDisplayString());
            ++i;
        }
        super.open();
    }

    protected void handleShellCloseEvent() {
        int i;
        if (this.getReturnCode() == 0 && (i = this.suggestions.getSelectionIndex()) > 0 && i < this.proposals.length) {
            this.proposals[i].apply(this.document);
        }
        super.handleShellCloseEvent();
    }
}

