/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import java.io.File;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.mylyn.context.core.ContextCorePlugin;
import org.eclipse.mylyn.internal.tasks.core.LocalTask;
import org.eclipse.mylyn.internal.tasks.ui.RetrieveTitleFromUrlJob;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.internal.tasks.ui.actions.TaskActivateAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.TaskDeactivateAction;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylyn.monitor.core.DateUtil;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.monitor.ui.MonitorUiPlugin;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.ITaskListChangeListener;
import org.eclipse.mylyn.tasks.core.TaskContainerDelta;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.AbstractRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.ui.DatePicker;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditor;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditorInput;
import org.eclipse.mylyn.tasks.ui.editors.TaskFormPage;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class TaskPlanningEditor
extends TaskFormPage {
    private static final int WIDTH_SUMMARY = 500;
    private static final int NOTES_MINSIZE = 100;
    public static final String ID = "org.eclipse.mylyn.tasks.ui.editors.planning";
    private static final String CLEAR = "Clear";
    private static final String LABEL_DUE = "Due:";
    private static final String LABEL_SCHEDULE = "Scheduled for:";
    private static final String DESCRIPTION_ESTIMATED = "Time that the task has been actively worked on in Eclipse.\n Inactivity timeout is " + MonitorUiPlugin.getDefault().getInactivityTimeout() / 60000 + " minutes.";
    public static final String LABEL_INCOMPLETE = "Incomplete";
    public static final String LABEL_COMPLETE = "Complete";
    private static final String LABEL_PLAN = "Personal Planning";
    private static final String NO_TIME_ELAPSED = "0 seconds";
    private static final String LABEL_NOTES = "Notes";
    private DatePicker dueDatePicker;
    private DatePicker datePicker;
    private AbstractTask task;
    private Composite editorComposite;
    protected static final String CONTEXT_MENU_ID = "#MylynPlanningEditor";
    private Text pathText;
    private Text endDate;
    private ScrolledForm form;
    private TextViewer summaryEditor;
    private Text issueReportURL;
    private CCombo priorityCombo;
    private CCombo statusCombo;
    private TextViewer noteEditor;
    private Spinner estimated;
    private ImageHyperlink getDescLink;
    private ImageHyperlink openUrlLink;
    private TaskEditor parentEditor = null;
    private ITaskListChangeListener TASK_LIST_LISTENER = new ITaskListChangeListener(){

        public void containersChanged(Set<TaskContainerDelta> containers) {
            for (TaskContainerDelta taskContainerDelta : containers) {
                AbstractTask updateTask;
                if (!(taskContainerDelta.getContainer() instanceof AbstractTask) || (updateTask = (AbstractTask)taskContainerDelta.getContainer()) == null || TaskPlanningEditor.this.task == null || !updateTask.getHandleIdentifier().equals(TaskPlanningEditor.this.task.getHandleIdentifier()) || PlatformUI.getWorkbench() == null || PlatformUI.getWorkbench().isClosing()) continue;
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (TaskPlanningEditor.this.summaryEditor != null && TaskPlanningEditor.this.summaryEditor.getTextWidget() != null) {
                            TaskPlanningEditor.this.updateTaskData(updateTask);
                        }
                    }
                });
            }
        }
    };
    private FormToolkit toolkit;
    private Action activateAction;

    public TaskPlanningEditor(FormEditor editor) {
        super(editor, ID, "Planning");
        TasksUiPlugin.getTaskListManager().getTaskList().addChangeListener(this.TASK_LIST_LISTENER);
    }

    public void updateTaskData(AbstractTask updateTask) {
        AbstractTask.PriorityLevel level;
        if (this.datePicker != null && !this.datePicker.isDisposed()) {
            if (updateTask.getScheduledForDate() != null) {
                Calendar cal = Calendar.getInstance();
                cal.setTime(updateTask.getScheduledForDate());
                this.datePicker.setDate(cal);
            } else {
                this.datePicker.setDate(null);
            }
        }
        if (this.summaryEditor == null) {
            return;
        }
        if (!this.summaryEditor.getTextWidget().isDisposed()) {
            if (!this.summaryEditor.getTextWidget().getText().equals(updateTask.getSummary())) {
                boolean wasDirty = this.isDirty;
                this.summaryEditor.getTextWidget().setText(updateTask.getSummary());
                this.markDirty(wasDirty);
            }
            if (this.parentEditor != null) {
                this.parentEditor.changeTitle();
                this.parentEditor.updateTitle(updateTask.getSummary());
            }
        }
        if (!this.priorityCombo.isDisposed() && updateTask != null && (level = AbstractTask.PriorityLevel.fromString((String)updateTask.getPriority())) != null) {
            int prioritySelectionIndex = this.priorityCombo.indexOf(level.getDescription());
            this.priorityCombo.select(prioritySelectionIndex);
        }
        if (!this.statusCombo.isDisposed()) {
            if (this.task.isCompleted()) {
                this.statusCombo.select(0);
            } else {
                this.statusCombo.select(1);
            }
        }
        if (updateTask instanceof LocalTask && !this.endDate.isDisposed()) {
            this.endDate.setText(this.getTaskDateString(updateTask));
        }
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.task instanceof LocalTask) {
            String label = this.summaryEditor.getTextWidget().getText();
            TasksUiPlugin.getTaskListManager().getTaskList().renameTask(this.task, label);
            this.task.setUrl(this.issueReportURL.getText());
            String priorityDescription = this.priorityCombo.getItem(this.priorityCombo.getSelectionIndex());
            AbstractTask.PriorityLevel level = AbstractTask.PriorityLevel.fromDescription((String)priorityDescription);
            if (level != null) {
                this.task.setPriority(level.toString());
            }
            if (this.statusCombo.getSelectionIndex() == 0) {
                this.task.setCompleted(true);
            } else {
                this.task.setCompleted(false);
            }
        }
        String note = this.noteEditor.getTextWidget().getText();
        this.task.setNotes(note);
        this.task.setEstimatedTimeHours(this.estimated.getSelection());
        if (this.datePicker != null && this.datePicker.getDate() != null) {
            TasksUiPlugin.getTaskActivityManager().setScheduledFor(this.task, this.datePicker.getDate().getTime());
        } else {
            TasksUiPlugin.getTaskActivityManager().setScheduledFor(this.task, null);
        }
        if (this.dueDatePicker != null && this.dueDatePicker.getDate() != null) {
            TasksUiPlugin.getTaskActivityManager().setDueDate(this.task, this.dueDatePicker.getDate().getTime());
        } else {
            TasksUiPlugin.getTaskActivityManager().setDueDate(this.task, null);
        }
        this.markDirty(false);
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        TaskEditorInput taskEditorInput = (TaskEditorInput)this.getEditorInput();
        this.task = taskEditorInput.getTask();
        this.form = managedForm.getForm();
        this.toolkit = managedForm.getToolkit();
        if (this.task != null) {
            this.addHeaderControls();
        }
        this.editorComposite = this.form.getBody();
        GridLayout editorLayout = new GridLayout();
        editorLayout.verticalSpacing = 3;
        this.editorComposite.setLayout((Layout)editorLayout);
        if (this.task instanceof LocalTask) {
            this.createSummarySection(this.editorComposite);
        }
        this.createPlanningSection(this.editorComposite);
        this.createNotesSection(this.editorComposite);
        if (this.summaryEditor != null && this.summaryEditor.getTextWidget() != null && "New Task".equals(this.summaryEditor.getTextWidget().getText())) {
            this.summaryEditor.setSelectedRange(0, this.summaryEditor.getTextWidget().getText().length());
            this.summaryEditor.getTextWidget().setFocus();
        } else if (this.summaryEditor != null && this.summaryEditor.getTextWidget() != null) {
            this.summaryEditor.getTextWidget().setFocus();
        }
    }

    private void addHeaderControls() {
        if (this.parentEditor.getTopForm() != null && this.parentEditor.getTopForm().getToolBarManager().isEmpty()) {
            this.activateAction = new Action(){

                public void run() {
                    if (!TaskPlanningEditor.this.task.isActive()) {
                        this.setChecked(true);
                        new TaskActivateAction().run(TaskPlanningEditor.this.task);
                    } else {
                        this.setChecked(false);
                        new TaskDeactivateAction().run(TaskPlanningEditor.this.task);
                    }
                }
            };
            this.activateAction.setImageDescriptor(TasksUiImages.TASK_ACTIVE_CENTERED);
            this.activateAction.setToolTipText("Toggle Activation");
            this.activateAction.setChecked(this.task.isActive());
            this.parentEditor.getTopForm().getToolBarManager().add((IAction)this.activateAction);
            this.parentEditor.getTopForm().getToolBarManager().update(true);
        }
    }

    public void setFocus() {
        if (this.summaryEditor != null && this.summaryEditor.getTextWidget() != null && !this.summaryEditor.getTextWidget().isDisposed()) {
            this.summaryEditor.getTextWidget().setFocus();
        }
    }

    public Control getControl() {
        return this.form;
    }

    private Text addNameValueComp(Composite parent, String label, String value, int style) {
        Text text;
        Composite nameValueComp = this.toolkit.createComposite(parent);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 3;
        nameValueComp.setLayout((Layout)layout);
        this.toolkit.createLabel(nameValueComp, label, 0).setForeground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        if ((8 & style) == 8) {
            text = new Text(nameValueComp, style);
            this.toolkit.adapt((Control)text, true, true);
            text.setText(value);
        } else {
            text = this.toolkit.createText(nameValueComp, value, style);
        }
        return text;
    }

    private void createSummarySection(Composite parent) {
        Composite summaryComposite = this.toolkit.createComposite(parent);
        GridLayout summaryLayout = new GridLayout();
        summaryLayout.verticalSpacing = 2;
        summaryLayout.marginHeight = 2;
        summaryLayout.marginLeft = 5;
        summaryComposite.setLayout((Layout)summaryLayout);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)summaryComposite);
        TaskRepository repository = null;
        if (this.task != null && !(this.task instanceof LocalTask)) {
            AbstractTask repositoryTask = this.task;
            repository = TasksUiPlugin.getRepositoryManager().getRepository(repositoryTask.getConnectorKind(), repositoryTask.getRepositoryUrl());
        }
        this.summaryEditor = this.addTextEditor(repository, summaryComposite, this.task.getSummary(), true, 0x800004);
        GridDataFactory.fillDefaults().hint(500, -1).minSize(100, -1).grab(true, false).applyTo((Control)this.summaryEditor.getTextWidget());
        this.summaryEditor.getControl().setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        if (!(this.task instanceof LocalTask)) {
            this.summaryEditor.setEditable(false);
        } else {
            this.summaryEditor.setEditable(true);
            this.summaryEditor.addTextListener(new ITextListener(){

                public void textChanged(TextEvent event) {
                    if (!TaskPlanningEditor.this.task.getSummary().equals(TaskPlanningEditor.this.summaryEditor.getTextWidget().getText())) {
                        TaskPlanningEditor.this.markDirty(true);
                    }
                }
            });
        }
        this.toolkit.paintBordersFor(summaryComposite);
        Composite statusComposite = this.toolkit.createComposite(parent);
        GridLayout compLayout = new GridLayout(7, false);
        compLayout.verticalSpacing = 0;
        compLayout.horizontalSpacing = 5;
        compLayout.marginHeight = 3;
        statusComposite.setLayout((Layout)compLayout);
        statusComposite.setLayoutData((Object)new GridData(768));
        Composite nameValueComp = this.toolkit.createComposite(statusComposite);
        GridLayout nameValueLayout = new GridLayout(2, false);
        nameValueLayout.marginHeight = 3;
        nameValueComp.setLayout((Layout)nameValueLayout);
        this.toolkit.createLabel(nameValueComp, "Priority:").setForeground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.priorityCombo = new CCombo(nameValueComp, 0x800008);
        this.toolkit.adapt((Control)this.priorityCombo, true, true);
        this.priorityCombo.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        this.toolkit.paintBordersFor(nameValueComp);
        String[] stringArray = TaskListView.PRIORITY_LEVEL_DESCRIPTIONS;
        int n = TaskListView.PRIORITY_LEVEL_DESCRIPTIONS.length;
        int n2 = 0;
        while (n2 < n) {
            String priorityLevel = stringArray[n2];
            this.priorityCombo.add(priorityLevel);
            ++n2;
        }
        AbstractTask.PriorityLevel level = AbstractTask.PriorityLevel.fromString((String)this.task.getPriority());
        if (level != null) {
            int prioritySelectionIndex = this.priorityCombo.indexOf(level.getDescription());
            this.priorityCombo.select(prioritySelectionIndex);
        }
        if (!(this.task instanceof LocalTask)) {
            this.priorityCombo.setEnabled(false);
        } else {
            this.priorityCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TaskPlanningEditor.this.markDirty(true);
                }
            });
        }
        nameValueComp = this.toolkit.createComposite(statusComposite);
        nameValueComp.setLayout((Layout)new GridLayout(2, false));
        this.toolkit.createLabel(nameValueComp, "Status:").setForeground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.statusCombo = new CCombo(nameValueComp, 0x800008);
        this.toolkit.adapt((Control)this.statusCombo, true, true);
        this.statusCombo.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        this.toolkit.paintBordersFor(nameValueComp);
        this.statusCombo.add(LABEL_COMPLETE);
        this.statusCombo.add(LABEL_INCOMPLETE);
        if (this.task.isCompleted()) {
            this.statusCombo.select(0);
        } else {
            this.statusCombo.select(1);
        }
        if (!(this.task instanceof LocalTask)) {
            this.statusCombo.setEnabled(false);
        } else {
            this.statusCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (TaskPlanningEditor.this.statusCombo.getSelectionIndex() == 0) {
                        TaskPlanningEditor.this.task.setCompleted(true);
                    } else {
                        TaskPlanningEditor.this.task.setCompleted(false);
                    }
                    TaskPlanningEditor.this.markDirty(true);
                }
            });
        }
        String creationDateString = "";
        try {
            creationDateString = DateFormat.getDateInstance(1).format(this.task.getCreationDate());
        }
        catch (RuntimeException e) {
            StatusHandler.fail((Throwable)e, (String)"Could not format creation date", (boolean)true);
        }
        this.addNameValueComp(statusComposite, "Created:", creationDateString, 0x800008);
        String completionDateString = "";
        if (this.task.isCompleted()) {
            completionDateString = this.getTaskDateString(this.task);
        }
        this.endDate = this.addNameValueComp(statusComposite, "Completed:", completionDateString, 0x800008);
        Composite urlComposite = this.toolkit.createComposite(parent);
        GridLayout urlLayout = new GridLayout(4, false);
        urlLayout.verticalSpacing = 0;
        urlLayout.marginHeight = 2;
        urlLayout.marginLeft = 5;
        urlComposite.setLayout((Layout)urlLayout);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)urlComposite);
        Label label = this.toolkit.createLabel(urlComposite, "URL:");
        label.setForeground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.issueReportURL = this.toolkit.createText(urlComposite, this.task.getUrl(), 0x800000);
        this.issueReportURL.setLayoutData((Object)new GridData(768));
        if (!(this.task instanceof LocalTask)) {
            this.issueReportURL.setEditable(false);
        } else {
            this.issueReportURL.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    TaskPlanningEditor.this.markDirty(true);
                }
            });
        }
        this.getDescLink = this.toolkit.createImageHyperlink(urlComposite, 0);
        this.getDescLink.setImage(TasksUiImages.getImage(TasksUiImages.TASK_RETRIEVE));
        this.getDescLink.setToolTipText("Retrieve task description from URL");
        this.getDescLink.setLayoutData((Object)new GridData(128));
        this.setButtonStatus();
        this.issueReportURL.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                TaskPlanningEditor.this.setButtonStatus();
            }

            public void keyReleased(KeyEvent e) {
                TaskPlanningEditor.this.setButtonStatus();
            }
        });
        this.getDescLink.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent e) {
                TaskPlanningEditor.this.retrieveTaskDescription(TaskPlanningEditor.this.issueReportURL.getText());
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }
        });
        this.openUrlLink = this.toolkit.createImageHyperlink(urlComposite, 0);
        this.openUrlLink.setImage(TasksUiImages.getImage(TasksUiImages.BROWSER_SMALL));
        this.openUrlLink.setToolTipText("Open with Web Browser");
        this.openUrlLink.setLayoutData((Object)new GridData(128));
        this.openUrlLink.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent e) {
                TasksUiUtil.openUrl(TaskPlanningEditor.this.issueReportURL.getText(), false);
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }
        });
        this.toolkit.paintBordersFor(urlComposite);
        this.toolkit.paintBordersFor(statusComposite);
    }

    protected void retrieveTaskDescription(String url) {
        try {
            RetrieveTitleFromUrlJob job = new RetrieveTitleFromUrlJob(this.issueReportURL.getText()){

                protected void setTitle(String pageTitle) {
                    TaskPlanningEditor.this.summaryEditor.getTextWidget().setText(pageTitle);
                    TaskPlanningEditor.this.markDirty(true);
                }
            };
            job.schedule();
        }
        catch (RuntimeException e) {
            StatusHandler.fail((Throwable)e, (String)"could not open task web page", (boolean)false);
        }
    }

    protected void setButtonStatus() {
        String url = this.issueReportURL.getText();
        if (url.length() > 10 && (url.startsWith("http://") || url.startsWith("https://"))) {
            this.getDescLink.setEnabled(true);
        } else {
            this.getDescLink.setEnabled(false);
        }
    }

    private void createPlanningSection(Composite parent) {
        AbstractRepositoryConnectorUi connector;
        Section section = this.toolkit.createSection(parent, 258);
        section.setText(LABEL_PLAN);
        section.setLayout((Layout)new GridLayout());
        section.setLayoutData((Object)new GridData(768));
        section.setExpanded(true);
        section.addExpansionListener(new IExpansionListener(){

            public void expansionStateChanging(ExpansionEvent e) {
                TaskPlanningEditor.this.form.reflow(true);
            }

            public void expansionStateChanged(ExpansionEvent e) {
                TaskPlanningEditor.this.form.reflow(true);
            }
        });
        Composite sectionClient = this.toolkit.createComposite((Composite)section);
        section.setClient((Control)sectionClient);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.horizontalSpacing = 15;
        layout.makeColumnsEqualWidth = false;
        sectionClient.setLayout((Layout)layout);
        GridData clientDataLayout = new GridData(32);
        sectionClient.setLayoutData((Object)clientDataLayout);
        Composite nameValueComp = this.makeComposite(sectionClient, 3);
        Label label = this.toolkit.createLabel(nameValueComp, LABEL_SCHEDULE);
        label.setForeground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.datePicker = new DatePicker(nameValueComp, 0x800000, "<choose date>");
        Calendar calendar = Calendar.getInstance();
        if (this.task.getScheduledForDate() != null) {
            calendar.setTime(this.task.getScheduledForDate());
            this.datePicker.setDate(calendar);
        }
        this.datePicker.setBackground(Display.getDefault().getSystemColor(1));
        this.datePicker.addPickerSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                TaskPlanningEditor.this.markDirty(true);
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        this.datePicker.setData("FormWidgetFactory.drawBorder", "textBorder");
        this.toolkit.adapt((Control)this.datePicker, true, true);
        this.toolkit.paintBordersFor(nameValueComp);
        ImageHyperlink clearScheduledDate = this.toolkit.createImageHyperlink(nameValueComp, 0);
        clearScheduledDate.setImage(TasksUiImages.getImage(TasksUiImages.REMOVE));
        clearScheduledDate.setToolTipText(CLEAR);
        clearScheduledDate.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                TaskPlanningEditor.this.datePicker.setDate(null);
                TaskPlanningEditor.this.task.setReminded(false);
                TaskPlanningEditor.this.markDirty(true);
            }
        });
        nameValueComp = this.makeComposite(sectionClient, 3);
        label = this.toolkit.createLabel(nameValueComp, LABEL_DUE);
        label.setForeground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.dueDatePicker = new DatePicker(nameValueComp, 0x800000, "<choose date>");
        calendar = Calendar.getInstance();
        if (this.task.getDueDate() != null) {
            calendar.setTime(this.task.getDueDate());
            this.dueDatePicker.setDate(calendar);
        }
        this.dueDatePicker.setBackground(Display.getDefault().getSystemColor(1));
        this.dueDatePicker.addPickerSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                TaskPlanningEditor.this.markDirty(true);
            }
        });
        this.dueDatePicker.setData("FormWidgetFactory.drawBorder", "textBorder");
        this.toolkit.adapt((Control)this.dueDatePicker, true, true);
        this.toolkit.paintBordersFor(nameValueComp);
        ImageHyperlink clearDueDate = this.toolkit.createImageHyperlink(nameValueComp, 0);
        clearDueDate.setImage(TasksUiImages.getImage(TasksUiImages.REMOVE));
        clearDueDate.setToolTipText(CLEAR);
        clearDueDate.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                TaskPlanningEditor.this.dueDatePicker.setDate(null);
                TaskPlanningEditor.this.markDirty(true);
            }
        });
        if (this.task != null && !(this.task instanceof LocalTask) && (connector = TasksUiPlugin.getConnectorUi(this.task.getConnectorKind())) != null && connector.supportsDueDates(this.task)) {
            this.dueDatePicker.setEnabled(false);
            clearDueDate.setEnabled(false);
        }
        nameValueComp = this.makeComposite(sectionClient, 3);
        label = this.toolkit.createLabel(nameValueComp, "Estimated hours:");
        label.setForeground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.estimated = new Spinner(nameValueComp, 0x800000);
        this.toolkit.adapt((Control)this.estimated, true, true);
        this.estimated.setSelection(this.task.getEstimateTimeHours());
        this.estimated.setDigits(0);
        this.estimated.setMaximum(100);
        this.estimated.setMinimum(0);
        this.estimated.setIncrement(1);
        this.estimated.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TaskPlanningEditor.this.markDirty(true);
            }
        });
        this.estimated.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        this.toolkit.paintBordersFor(nameValueComp);
        GridData estimatedDataLayout = new GridData();
        estimatedDataLayout.widthHint = 30;
        this.estimated.setLayoutData((Object)estimatedDataLayout);
        ImageHyperlink clearEstimated = this.toolkit.createImageHyperlink(nameValueComp, 0);
        clearEstimated.setImage(TasksUiImages.getImage(TasksUiImages.REMOVE));
        clearEstimated.setToolTipText(CLEAR);
        clearEstimated.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                TaskPlanningEditor.this.estimated.setSelection(0);
                TaskPlanningEditor.this.markDirty(true);
            }
        });
        nameValueComp = this.makeComposite(sectionClient, 3);
        label = this.toolkit.createLabel(nameValueComp, "Active:");
        label.setForeground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        label.setToolTipText(DESCRIPTION_ESTIMATED);
        String elapsedTimeString = NO_TIME_ELAPSED;
        try {
            elapsedTimeString = DateUtil.getFormattedDuration((long)TasksUiPlugin.getTaskActivityManager().getElapsedTime(this.task), (boolean)true);
            if (elapsedTimeString.equals("")) {
                elapsedTimeString = NO_TIME_ELAPSED;
            }
        }
        catch (RuntimeException e) {
            StatusHandler.fail((Throwable)e, (String)"Could not format elapsed time", (boolean)true);
        }
        final Text elapsedTimeText = new Text(nameValueComp, 0x800008);
        elapsedTimeText.setText(elapsedTimeString);
        GridData td = new GridData(768);
        td.widthHint = 120;
        elapsedTimeText.setLayoutData((Object)td);
        elapsedTimeText.setEditable(false);
        Button timeRefresh = this.toolkit.createButton(nameValueComp, "Refresh", 0x1000008);
        timeRefresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String elapsedTimeString = TaskPlanningEditor.NO_TIME_ELAPSED;
                try {
                    elapsedTimeString = DateUtil.getFormattedDuration((long)TasksUiPlugin.getTaskActivityManager().getElapsedTime(TaskPlanningEditor.this.task), (boolean)true);
                    if (elapsedTimeString.equals("")) {
                        elapsedTimeString = TaskPlanningEditor.NO_TIME_ELAPSED;
                    }
                }
                catch (RuntimeException e1) {
                    StatusHandler.fail((Throwable)e1, (String)"Could not format elapsed time", (boolean)true);
                }
                elapsedTimeText.setText(elapsedTimeString);
            }
        });
        this.toolkit.paintBordersFor(sectionClient);
    }

    private Composite makeComposite(Composite parent, int col) {
        Composite nameValueComp = this.toolkit.createComposite(parent);
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 3;
        nameValueComp.setLayout((Layout)layout);
        return nameValueComp;
    }

    private void createNotesSection(Composite parent) {
        Section section = this.toolkit.createSection(parent, 256);
        section.setText(LABEL_NOTES);
        section.setExpanded(true);
        section.setLayout((Layout)new GridLayout());
        section.setLayoutData((Object)new GridData(1808));
        Composite container = this.toolkit.createComposite((Composite)section);
        section.setClient((Control)container);
        container.setLayout((Layout)new GridLayout());
        GridData notesData = new GridData(1808);
        notesData.grabExcessVerticalSpace = true;
        container.setLayoutData((Object)notesData);
        TaskRepository repository = null;
        if (this.task != null && !(this.task instanceof LocalTask)) {
            AbstractTask repositoryTask = this.task;
            repository = TasksUiPlugin.getRepositoryManager().getRepository(repositoryTask.getConnectorKind(), repositoryTask.getRepositoryUrl());
        }
        this.noteEditor = this.addTextEditor(repository, container, this.task.getNotes(), true, 8389186);
        this.noteEditor.getControl().setLayoutData((Object)new GridData(1808));
        GridDataFactory.fillDefaults().minSize(-1, 100).grab(true, true).applyTo(this.noteEditor.getControl());
        this.noteEditor.getControl().setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        this.noteEditor.setEditable(true);
        this.noteEditor.addTextListener(new ITextListener(){

            public void textChanged(TextEvent event) {
                if (!TaskPlanningEditor.this.task.getNotes().equals(TaskPlanningEditor.this.noteEditor.getTextWidget().getText())) {
                    TaskPlanningEditor.this.markDirty(true);
                }
            }
        });
        this.toolkit.paintBordersFor(container);
    }

    private String getTaskDateString(AbstractTask task) {
        if (task == null) {
            return "";
        }
        if (task.getCompletionDate() == null) {
            return "";
        }
        String completionDateString = "";
        try {
            completionDateString = DateFormat.getDateInstance(1).format(task.getCompletionDate());
        }
        catch (RuntimeException e) {
            StatusHandler.fail((Throwable)e, (String)"Could not format date", (boolean)true);
            return completionDateString;
        }
        return completionDateString;
    }

    void createResourcesSection(Composite parent) {
        Section section = this.toolkit.createSection(parent, 258);
        section.setText("Resources");
        section.setLayout((Layout)new GridLayout());
        section.setLayoutData((Object)new GridData(768));
        section.addExpansionListener(new IExpansionListener(){

            public void expansionStateChanging(ExpansionEvent e) {
                TaskPlanningEditor.this.form.reflow(true);
            }

            public void expansionStateChanged(ExpansionEvent e) {
                TaskPlanningEditor.this.form.reflow(true);
            }
        });
        Composite container = this.toolkit.createComposite((Composite)section);
        section.setClient((Control)container);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(768));
        this.toolkit.createLabel(container, "Task context file:");
        File contextFile = ContextCorePlugin.getContextManager().getFileForContext(this.task.getHandleIdentifier());
        if (contextFile != null) {
            this.pathText = this.toolkit.createText(container, contextFile.getAbsolutePath(), 0);
            this.pathText.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
            GridDataFactory.fillDefaults().hint(400, -1).applyTo((Control)this.pathText);
            this.pathText.setEditable(false);
            this.pathText.setEnabled(true);
        }
        this.toolkit.paintBordersFor(container);
    }

    public void setParentEditor(TaskEditor parentEditor) {
        this.parentEditor = parentEditor;
    }

    public void dispose() {
        TasksUiPlugin.getTaskListManager().getTaskList().removeChangeListener(this.TASK_LIST_LISTENER);
    }

    public String toString() {
        return "(info editor for task: " + this.task + ")";
    }

    public void setNotes(String notes) {
        this.noteEditor.getTextWidget().setText(notes);
    }

    public void setDescription(String desc) {
        this.summaryEditor.getTextWidget().setText(desc);
    }

    public String getDescription() {
        return this.summaryEditor.getTextWidget().getText();
    }

    public String getFormTitle() {
        return this.form.getText();
    }
}

