/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.notifications;

import java.util.Date;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.internal.tasks.ui.notifications.AbstractNotification;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskElementLabelProvider;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class TaskListNotification
extends AbstractNotification {
    protected final AbstractTask task;
    protected Date date;
    private String description = null;
    private final DecoratingLabelProvider labelProvider = new DecoratingLabelProvider((ILabelProvider)new TaskElementLabelProvider(true), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator());

    public TaskListNotification(AbstractTask task) {
        this.task = task;
    }

    public String getDescription() {
        return this.description;
    }

    public String getLabel() {
        return this.labelProvider.getText((Object)this.task);
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void open() {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            public void run() {
                TasksUiUtil.refreshAndOpenTaskListElement((AbstractTaskContainer)TaskListNotification.this.task);
            }
        });
    }

    public Image getNotificationImage() {
        return this.labelProvider.getImage((Object)this.task);
    }

    protected AbstractTask getTask() {
        return this.task;
    }

    public Image getNotificationKindImage() {
        return TasksUiImages.getImage(TasksUiImages.OVERLAY_INCOMMING);
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public int compareTo(AbstractNotification anotherNotification) throws ClassCastException {
        if (anotherNotification == null) {
            throw new ClassCastException("A ITaskListNotification object expected.");
        }
        Date anotherDate = anotherNotification.getDate();
        if (this.date != null && anotherDate != null) {
            return this.date.compareTo(anotherDate);
        }
        if (this.date == null) {
            return -1;
        }
        return 1;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.date == null ? 0 : this.date.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.task == null ? 0 : this.task.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TaskListNotification other = (TaskListNotification)obj;
        if (this.date == null ? other.date != null : !this.date.equals(other.date)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        return !(this.task == null ? other.task != null : !this.task.equals((Object)other.task));
    }

    public Object getAdapter(Class adapter) {
        if (adapter == AbstractTask.class) {
            return this.task;
        }
        return null;
    }
}

