/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.search;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.mylyn.internal.tasks.core.OrphanedTasksContainer;
import org.eclipse.mylyn.internal.tasks.ui.AddExistingTaskJob;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.internal.tasks.ui.search.CreateQueryFromSearchAction;
import org.eclipse.mylyn.internal.tasks.ui.search.OpenSearchResultAction;
import org.eclipse.mylyn.internal.tasks.ui.search.SearchResultContentProvider;
import org.eclipse.mylyn.internal.tasks.ui.search.SearchResultSortAction;
import org.eclipse.mylyn.internal.tasks.ui.search.SearchResultSorterDescription;
import org.eclipse.mylyn.internal.tasks.ui.search.SearchResultSorterId;
import org.eclipse.mylyn.internal.tasks.ui.search.SearchResultSorterPriority;
import org.eclipse.mylyn.internal.tasks.ui.search.SearchResultTreeContentProvider;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskElementLabelProvider;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.AbstractTaskCategory;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.progress.IProgressService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositorySearchResultView
extends AbstractTextSearchViewPage
implements IAdaptable {
    public static final int ORDER_PRIORITY = 1;
    public static final int ORDER_DESCRIPTION = 2;
    public static final int ORDER_SEVERITY = 3;
    public static final int ORDER_STATUS = 4;
    public static final int ORDER_ID = 5;
    public static final int ORDER_DEFAULT = 1;
    private static final String KEY_SORTING = "org.eclipse.mylyn.tasks.ui.search.resultpage.sorting";
    private SearchResultContentProvider taskContentProvider;
    private int currentSortOrder = 1;
    private SearchResultSortAction sortByPriorityAction = new SearchResultSortAction("Task Priority", this, 1);
    private SearchResultSortAction sortByDescriptionAction = new SearchResultSortAction("Task Summary", this, 2);
    private OpenSearchResultAction openInEditorAction = new OpenSearchResultAction("Open in Editor", this);
    private CreateQueryFromSearchAction addTaskListAction = new CreateQueryFromSearchAction("Create Query from Search...", this);
    private static final String[] SHOW_IN_TARGETS = new String[]{"org.eclipse.ui.views.ResourceNavigator"};
    private Action groupByAction = new Action(){

        public String getText() {
            return "Group By Owner";
        }

        public void run() {
            if (((SearchResultTreeContentProvider)RepositorySearchResultView.this.getViewer().getContentProvider()).getGroupByOwner()) {
                ((SearchResultTreeContentProvider)RepositorySearchResultView.this.getViewer().getContentProvider()).setGroupByOwner(false);
                this.setChecked(false);
            } else {
                ((SearchResultTreeContentProvider)RepositorySearchResultView.this.getViewer().getContentProvider()).setGroupByOwner(true);
                this.setChecked(true);
            }
        }
    };
    private static final IShowInTargetList SHOW_IN_TARGET_LIST = new IShowInTargetList(){

        public String[] getShowInTargetIds() {
            return SHOW_IN_TARGETS;
        }
    };

    public RepositorySearchResultView() {
        super(2);
    }

    protected void elementsChanged(Object[] objects) {
        if (this.taskContentProvider != null) {
            this.taskContentProvider.elementsChanged(objects);
        }
    }

    protected void clear() {
        if (this.taskContentProvider != null) {
            this.taskContentProvider.clear();
        }
    }

    public StructuredViewer getViewer() {
        return super.getViewer();
    }

    protected void configureTreeViewer(TreeViewer viewer) {
        DecoratingLabelProvider labelProvider = new DecoratingLabelProvider((ILabelProvider)new TaskElementLabelProvider(true), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator());
        viewer.setUseHashlookup(true);
        viewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        viewer.setContentProvider((IContentProvider)new SearchResultTreeContentProvider(this));
        this.setSortOrder(this.currentSortOrder);
        this.taskContentProvider = (SearchResultContentProvider)viewer.getContentProvider();
    }

    protected void configureTableViewer(TableViewer viewer) {
    }

    public void setSortOrder(int sortOrder) {
        StructuredViewer viewer = this.getViewer();
        switch (sortOrder) {
            case 5: {
                viewer.setSorter((ViewerSorter)new SearchResultSorterId());
                break;
            }
            case 2: {
                viewer.setSorter((ViewerSorter)new SearchResultSorterDescription());
                break;
            }
            case 1: {
                viewer.setSorter((ViewerSorter)new SearchResultSorterPriority());
                break;
            }
            default: {
                sortOrder = 1;
                viewer.setSorter((ViewerSorter)new SearchResultSorterPriority());
            }
        }
        this.currentSortOrder = sortOrder;
        this.getSettings().put(KEY_SORTING, this.currentSortOrder);
    }

    public Object getAdapter(Class adapter) {
        return this.getAdapterDelegate(adapter);
    }

    private Object getAdapterDelegate(Class<?> adapter) {
        if (IShowInTargetList.class.equals(adapter)) {
            return SHOW_IN_TARGET_LIST;
        }
        return null;
    }

    protected void showMatch(Match match, int currentOffset, int currentLength, boolean activate) throws PartInitException {
        AbstractTask repositoryHit = (AbstractTask)match.getElement();
        TasksUiUtil.openRepositoryTask(repositoryHit.getRepositoryUrl(), repositoryHit.getTaskId(), repositoryHit.getUrl());
    }

    protected void fillContextMenu(IMenuManager menuManager) {
        super.fillContextMenu(menuManager);
        MenuManager sortMenuManager = new MenuManager(SearchMessages.SortDropDownAction_label);
        sortMenuManager.add((IAction)this.sortByPriorityAction);
        sortMenuManager.add((IAction)this.sortByDescriptionAction);
        this.sortByPriorityAction.setChecked(this.currentSortOrder == this.sortByPriorityAction.getSortOrder());
        this.sortByDescriptionAction.setChecked(this.currentSortOrder == this.sortByDescriptionAction.getSortOrder());
        menuManager.appendToGroup("group.viewerSetup", (IContributionItem)sortMenuManager);
        menuManager.appendToGroup("group.viewerSetup", (IAction)this.groupByAction);
        menuManager.appendToGroup("group.open", (IAction)this.openInEditorAction);
        menuManager.appendToGroup("group.open", (IAction)this.addTaskListAction);
        MenuManager subMenuManager = new MenuManager("Add to Task List Category");
        ArrayList categories = new ArrayList(TasksUiPlugin.getTaskListManager().getTaskList().getCategories());
        Collections.sort(categories);
        for (final AbstractTaskCategory category : categories) {
            if (category instanceof OrphanedTasksContainer) continue;
            Action action = new Action(){

                public void run() {
                    RepositorySearchResultView.this.moveToCategory(category);
                }
            };
            String text = category.getSummary();
            action.setText(text);
            action.setImageDescriptor(TasksUiImages.CATEGORY);
            subMenuManager.add((IAction)action);
        }
        menuManager.appendToGroup("group.open", (IContributionItem)subMenuManager);
    }

    private void moveToCategory(AbstractTaskCategory category) {
        final IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
        StructuredSelection selection = (StructuredSelection)this.getViewer().getSelection();
        for (Object selectedObject : selection) {
            if (!(selectedObject instanceof AbstractTask)) continue;
            AbstractTask task = (AbstractTask)selectedObject;
            TaskRepository repository = TasksUiPlugin.getRepositoryManager().getRepository(task.getRepositoryUrl());
            final AddExistingTaskJob job = new AddExistingTaskJob(repository, task.getTaskId(), category);
            job.schedule();
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    progressService.showInDialog(RepositorySearchResultView.this.getSite().getShell(), (Job)job);
                }
            });
        }
    }
}

