/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.views;

import org.eclipse.mylyn.context.core.ContextCorePlugin;
import org.eclipse.mylyn.internal.tasks.core.OrphanedTasksContainer;
import org.eclipse.mylyn.internal.tasks.core.TaskCategory;
import org.eclipse.mylyn.internal.tasks.ui.AbstractTaskListFilter;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskElementLabelProvider;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryQuery;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TreeItem;

class CustomTaskListDecorationDrawer
implements Listener {
    private final TaskListView taskListView;
    private int activationImageOffset;
    private Image taskActive = TasksUiImages.getImage(TasksUiImages.TASK_ACTIVE);
    private Image taskInactive = TasksUiImages.getImage(TasksUiImages.TASK_INACTIVE);
    private Image taskInactiveContext = TasksUiImages.getImage(TasksUiImages.TASK_INACTIVE_CONTEXT);
    private final int platformSpecificSquish;
    private final Rectangle lastClippingArea = new Rectangle(0, 0, 0, 0);
    private final boolean tweakClipping;

    CustomTaskListDecorationDrawer(TaskListView taskListView, int activationImageOffset) {
        this.taskListView = taskListView;
        this.activationImageOffset = activationImageOffset;
        this.taskListView.synchronizationOverlaid = TasksUiPlugin.getDefault().getPluginPreferences().getBoolean("org.eclipse.mylyn.tasks.ui.overlays.incoming.tight");
        if (SWT.getPlatform().equals("gtk")) {
            this.platformSpecificSquish = 8;
            this.tweakClipping = true;
        } else if (SWT.getPlatform().equals("carbon")) {
            this.platformSpecificSquish = 3;
            this.tweakClipping = false;
        } else {
            this.platformSpecificSquish = 0;
            this.tweakClipping = false;
        }
    }

    public void handleEvent(Event event) {
        Object data = event.item.getData();
        Image activationImage = null;
        if (data instanceof AbstractTask) {
            AbstractTask task = (AbstractTask)data;
            activationImage = task.isActive() ? this.taskActive : (ContextCorePlugin.getContextManager().hasContext(task.getHandleIdentifier()) ? this.taskInactiveContext : this.taskInactive);
        }
        if (data instanceof AbstractTaskContainer) {
            switch (event.type) {
                case 40: {
                    if (activationImage != null) {
                        this.drawActivationImage(this.activationImageOffset, event, activationImage);
                    }
                    if (!this.taskListView.synchronizationOverlaid && data instanceof AbstractTaskContainer) {
                        this.drawSyncronizationImage((AbstractTaskContainer)data, event);
                    }
                    if (!this.tweakClipping) break;
                    this.lastClippingArea.x = event.x;
                    this.lastClippingArea.y = event.y;
                    this.lastClippingArea.width = event.width;
                    this.lastClippingArea.height = event.height;
                    break;
                }
                case 42: {
                    Rectangle clipping = null;
                    if (this.tweakClipping) {
                        clipping = event.gc.getClipping();
                        event.gc.setClipping(this.lastClippingArea);
                    }
                    if (activationImage != null) {
                        this.drawActivationImage(this.activationImageOffset, event, activationImage);
                    }
                    if (data instanceof AbstractTaskContainer) {
                        this.drawSyncronizationImage((AbstractTaskContainer)data, event);
                    }
                    if (!this.tweakClipping) break;
                    event.gc.setClipping(clipping);
                }
            }
        }
    }

    private void drawSyncronizationImage(AbstractTaskContainer element, Event event) {
        Image image = null;
        int offsetX = 6;
        int offsetY = event.height / 2 - 5;
        if (this.taskListView.synchronizationOverlaid) {
            offsetX = event.x + 18 - this.platformSpecificSquish;
            offsetY += 2;
        }
        if (element != null) {
            if (element instanceof AbstractTask) {
                image = TasksUiImages.getImage(TaskElementLabelProvider.getSynchronizationImageDescriptor(element, this.taskListView.synchronizationOverlaid));
            } else {
                AbstractRepositoryQuery query;
                int imageOffset = 0;
                if (!this.hideDecorationOnContainer(element, (TreeItem)event.item) && AbstractTaskListFilter.hasDescendantIncoming(element)) {
                    image = this.taskListView.synchronizationOverlaid ? TasksUiImages.getImage(TasksUiImages.OVERLAY_SYNCH_INCOMMING) : TasksUiImages.getImage(TasksUiImages.OVERLAY_INCOMMING);
                } else if (element instanceof AbstractRepositoryQuery && (query = (AbstractRepositoryQuery)element).getSynchronizationStatus() != null) {
                    image = TasksUiImages.getImage(TasksUiImages.OVERLAY_WARNING);
                    imageOffset = this.taskListView.synchronizationOverlaid ? 11 : 3;
                }
                int additionalSquish = 0;
                if (this.platformSpecificSquish > 0 && this.taskListView.synchronizationOverlaid) {
                    additionalSquish = this.platformSpecificSquish + 3;
                } else if (this.platformSpecificSquish > 0) {
                    additionalSquish = this.platformSpecificSquish / 2;
                }
                offsetX = this.taskListView.synchronizationOverlaid ? 42 - imageOffset - additionalSquish : 24 - imageOffset - additionalSquish;
            }
        }
        if (image != null) {
            event.gc.drawImage(image, offsetX, event.y + offsetY);
        }
    }

    private boolean hideDecorationOnContainer(AbstractTaskContainer element, TreeItem treeItem) {
        if (element instanceof OrphanedTasksContainer) {
            return true;
        }
        if (!this.taskListView.isFocusedMode()) {
            return false;
        }
        if (element instanceof AbstractRepositoryQuery || element instanceof TaskCategory) {
            return treeItem.getExpanded();
        }
        return false;
    }

    private void drawActivationImage(int activationImageOffset, Event event, Image image) {
        Rectangle rect = image.getBounds();
        int offset = Math.max(0, (event.height - rect.height) / 2);
        event.gc.drawImage(image, activationImageOffset, event.y + offset);
    }
}

