/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.views;

import java.util.Arrays;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.mylyn.internal.tasks.ui.actions.TaskActivateAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.TaskDeactivateAction;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryQuery;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.AbstractTaskCategory;
import org.eclipse.mylyn.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.TreeItem;

class TaskListCellModifier
implements ICellModifier {
    private final TaskListView taskListView;
    private boolean disableActivateForParentTasks = false;

    TaskListCellModifier(TaskListView taskListView) {
        this.taskListView = taskListView;
        if (SWT.getPlatform().equals("gtk")) {
            this.disableActivateForParentTasks = true;
        }
    }

    public boolean canModify(Object element, String property) {
        return this.taskListView.isInRenameAction;
    }

    public Object getValue(Object element, String property) {
        try {
            int columnIndex = Arrays.asList(this.taskListView.columnNames).indexOf(property);
            if (element instanceof AbstractTaskContainer) {
                AbstractTaskContainer taskListElement = (AbstractTaskContainer)element;
                switch (columnIndex) {
                    case 0: {
                        return taskListElement.getSummary();
                    }
                    case 1: {
                        return "";
                    }
                    case 2: {
                        return "";
                    }
                }
            }
        }
        catch (Exception e) {
            StatusHandler.log((Throwable)e, (String)e.getMessage());
        }
        return "";
    }

    public void modify(Object element, String property, Object value) {
        block14: {
            int columnIndex = -1;
            try {
                columnIndex = Arrays.asList(this.taskListView.columnNames).indexOf(property);
                if (((TreeItem)element).getData() instanceof AbstractTask) {
                    AbstractTaskContainer taskListElement = (AbstractTaskContainer)((TreeItem)element).getData();
                    AbstractTask task = (AbstractTask)taskListElement;
                    switch (columnIndex) {
                        case 0: {
                            if (task != null) {
                                TasksUiPlugin.getTaskListManager().getTaskList().renameTask(task, ((String)value).trim());
                                break;
                            }
                            break block14;
                        }
                        case 1: {
                            break;
                        }
                        case 2: {
                            this.toggleTaskActivation((TreeItem)element);
                        }
                    }
                    break block14;
                }
                if (((TreeItem)element).getData() instanceof AbstractTaskCategory || ((TreeItem)element).getData() instanceof AbstractRepositoryQuery) {
                    AbstractTaskContainer container = (AbstractTaskContainer)((TreeItem)element).getData();
                    switch (columnIndex) {
                        case 0: {
                            TasksUiPlugin.getTaskListManager().getTaskList().renameContainer(container, ((String)value).trim());
                        }
                        case 1: {
                            break;
                        }
                        default: {
                            break;
                        }
                    }
                }
            }
            catch (Exception e) {
                StatusHandler.fail((Throwable)e, (String)e.getMessage(), (boolean)true);
            }
        }
        this.taskListView.refresh();
    }

    public void toggleTaskActivation(TreeItem element) {
        AbstractTaskContainer taskListElement = (AbstractTaskContainer)element.getData();
        AbstractTask task = null;
        if (taskListElement instanceof AbstractTask) {
            task = (AbstractTask)taskListElement;
        }
        if (task != null) {
            TreeItem parent;
            if (this.disableActivateForParentTasks && (parent = element.getParentItem()) != null && (parent.getData() instanceof AbstractRepositoryQuery || parent.getData() instanceof AbstractTaskCategory) && element.getItemCount() > 0) {
                return;
            }
            if (task.isActive()) {
                new TaskDeactivateAction().run(task);
            } else {
                new TaskActivateAction().run(task);
            }
        }
    }
}

