/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.views;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.mylyn.internal.tasks.core.OrphanedTasksContainer;
import org.eclipse.mylyn.internal.tasks.core.ScheduledTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.UnfiledCategory;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskKeyComparator;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryQuery;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.AbstractTaskContainer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class TaskListTableSorter
extends ViewerSorter {
    private static final int DEFAULT_SORT_DIRECTION = 1;
    private int sortDirection = 1;
    private SortByIndex sortByIndex = SortByIndex.PRIORITY;
    private final TaskListView view;
    private TaskKeyComparator taskKeyComparator = new TaskKeyComparator();

    public TaskListTableSorter(TaskListView view) {
        this.view = view;
    }

    public TaskListTableSorter(TaskListView view, SortByIndex index) {
        this.view = view;
        this.sortByIndex = index;
    }

    public void setColumn(String column) {
        if (this.view.isFocusedMode()) {
            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Mylyn Information", (String)"Manual sorting is disabled in focused mode, sort order will not take effect until focused mode is disabled.");
        }
    }

    public int compare(Viewer compareViewer, Object o1, Object o2) {
        if (o1 instanceof ScheduledTaskContainer && o2 instanceof ScheduledTaskContainer) {
            ScheduledTaskContainer dateRangeTaskContainer1 = (ScheduledTaskContainer)o1;
            ScheduledTaskContainer dateRangeTaskContainer2 = (ScheduledTaskContainer)o2;
            return -1 * dateRangeTaskContainer2.getStart().compareTo(dateRangeTaskContainer1.getStart());
        }
        if (o1 instanceof AbstractTaskContainer && o2 instanceof ScheduledTaskContainer) {
            return -1;
        }
        if (o1 instanceof ScheduledTaskContainer && o2 instanceof AbstractTaskContainer) {
            return 1;
        }
        if (o1 instanceof AbstractTaskContainer && o2 instanceof UnfiledCategory) {
            return 1;
        }
        if (o2 instanceof AbstractTaskContainer && o1 instanceof UnfiledCategory) {
            return -1;
        }
        if (o1 instanceof AbstractTaskContainer && o2 instanceof OrphanedTasksContainer) {
            return -1;
        }
        if (o2 instanceof AbstractTaskContainer && o1 instanceof OrphanedTasksContainer) {
            return 1;
        }
        if (!(o1 instanceof AbstractTask) && o2 instanceof AbstractTask) {
            return 1;
        }
        if (o1 instanceof AbstractTask && !(o2 instanceof AbstractTaskContainer)) {
            return -1;
        }
        if (!(o1 instanceof AbstractTask)) {
            if (o2 instanceof AbstractTaskContainer || o2 instanceof AbstractRepositoryQuery) {
                return this.sortDirection * ((AbstractTaskContainer)o1).getSummary().compareToIgnoreCase(((AbstractTaskContainer)o2).getSummary());
            }
            return -1;
        }
        if (o1 instanceof AbstractTaskContainer) {
            if (!(o2 instanceof AbstractTask)) {
                return -1;
            }
            if (o2 instanceof AbstractTaskContainer) {
                AbstractTaskContainer element1 = (AbstractTaskContainer)o1;
                AbstractTaskContainer element2 = (AbstractTaskContainer)o2;
                return this.compareElements(element1, element2);
            }
        } else {
            return 0;
        }
        return 0;
    }

    private int compareElements(AbstractTaskContainer element1, AbstractTaskContainer element2) {
        if (SortByIndex.PRIORITY.equals((Object)this.sortByIndex)) {
            int result = this.sortDirection * element1.getPriority().compareTo(element2.getPriority());
            if (result != 0) {
                return result;
            }
            return this.sortBySummary(element1, element2);
        }
        if (SortByIndex.DATE_CREATED.equals((Object)this.sortByIndex)) {
            AbstractTask t1 = null;
            AbstractTask t2 = null;
            if (element1 instanceof AbstractTask) {
                t1 = (AbstractTask)element1;
            }
            if (element2 instanceof AbstractTask) {
                t2 = (AbstractTask)element2;
            }
            if (t1 != null && t2 != null && t1.getCreationDate() != null) {
                return t1.getCreationDate().compareTo(t2.getCreationDate());
            }
        } else {
            return this.sortBySummary(element1, element2);
        }
        return 0;
    }

    private int sortBySummary(AbstractTaskContainer element1, AbstractTaskContainer element2) {
        return this.sortDirection * this.taskKeyComparator.compare(TaskListTableSorter.getSortableFromElement(element1), TaskListTableSorter.getSortableFromElement(element2));
    }

    public static String getSortableSummaryFromElement(AbstractTaskContainer element) {
        AbstractTask task1;
        String summary = element.getSummary();
        if (element instanceof AbstractTask && (task1 = (AbstractTask)element).getTaskKey() != null) {
            summary = String.valueOf(task1.getTaskKey()) + ": " + summary;
        }
        return summary;
    }

    public static String[] getSortableFromElement(AbstractTaskContainer element) {
        AbstractTask task1;
        String[] stringArray = new String[3];
        stringArray[0] = "";
        stringArray[2] = element.getSummary();
        String[] a = stringArray;
        if (element instanceof AbstractTask && (task1 = (AbstractTask)element).getTaskKey() != null) {
            a[1] = task1.getTaskKey();
        }
        return a;
    }

    public SortByIndex getSortByIndex() {
        return this.sortByIndex;
    }

    public void setSortByIndex(SortByIndex sortByIndex) {
        SortByIndex oldValue = this.sortByIndex;
        this.sortByIndex = sortByIndex;
        if (!oldValue.equals((Object)sortByIndex)) {
            this.view.getViewer().refresh();
        }
    }

    public int getSortDirection() {
        return this.sortDirection;
    }

    public void setSortDirection(int sortDirection) {
        int oldValue = this.sortDirection;
        this.sortDirection = sortDirection;
        if (oldValue != this.sortDirection) {
            this.view.getViewer().refresh();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SortByIndex {
        PRIORITY,
        SUMMARY,
        DATE_CREATED;

    }
}

