/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.views;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.window.ToolTip;
import org.eclipse.mylyn.internal.tasks.core.OrphanedTasksContainer;
import org.eclipse.mylyn.internal.tasks.core.ScheduledTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.TaskCategory;
import org.eclipse.mylyn.internal.tasks.core.UnfiledCategory;
import org.eclipse.mylyn.internal.tasks.ui.AbstractTaskListFilter;
import org.eclipse.mylyn.internal.tasks.ui.TaskListHyperlink;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.internal.tasks.ui.notifications.AbstractNotification;
import org.eclipse.mylyn.internal.tasks.ui.notifications.TaskListNotification;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskElementLabelProvider;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListContentProvider;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylyn.internal.tasks.ui.views.WorkweekProgressBar;
import org.eclipse.mylyn.monitor.core.DateUtil;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryQuery;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.tasks.core.RepositoryStatus;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class TaskListToolTip
extends ToolTip {
    private static final int X_SHIFT = "gtk".equals(SWT.getPlatform()) || "carbon".equals(SWT.getPlatform()) ? -26 : -23;
    private static final int Y_SHIFT = 1;
    private AbstractTaskContainer currentTipElement;
    private List<TaskListToolTipListener> listeners = new ArrayList<TaskListToolTipListener>();
    private boolean visible;
    private boolean triggeredByMouse;
    private Control control;

    public TaskListToolTip(Control control) {
        super(control);
        this.control = control;
        this.setShift(new Point(1, 1));
    }

    public void dispose() {
        this.hide();
    }

    protected void afterHideToolTip(Event event) {
        this.triggeredByMouse = true;
        this.visible = false;
        TaskListToolTipListener[] taskListToolTipListenerArray = this.listeners.toArray(new TaskListToolTipListener[0]);
        int n = taskListToolTipListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            TaskListToolTipListener listener = taskListToolTipListenerArray[n2];
            listener.toolTipHidden(event);
            ++n2;
        }
    }

    public void addTaskListToolTipListener(TaskListToolTipListener listener) {
        this.listeners.add(listener);
    }

    public void removeTaskListToolTipListener(TaskListToolTipListener listener) {
        this.listeners.remove(listener);
    }

    private AbstractTaskContainer getTaskListElement(Object hoverObject) {
        Object data;
        if (hoverObject instanceof TaskListHyperlink) {
            TaskListHyperlink hyperlink = (TaskListHyperlink)((Object)hoverObject);
            return hyperlink.getTask();
        }
        if (hoverObject instanceof Widget && (data = ((Widget)hoverObject).getData()) != null) {
            if (data instanceof AbstractTaskContainer) {
                return (AbstractTaskContainer)data;
            }
            if (data instanceof IAdaptable) {
                return (AbstractTaskContainer)((IAdaptable)data).getAdapter(AbstractTaskContainer.class);
            }
        }
        return null;
    }

    private String getTitleText(AbstractTaskContainer element) {
        if (element instanceof ScheduledTaskContainer) {
            StringBuilder sb = new StringBuilder();
            sb.append(element.getSummary());
            Calendar start = ((ScheduledTaskContainer)element).getStart();
            sb.append("  [");
            sb.append(DateFormat.getDateInstance(1).format(start.getTime()));
            sb.append("]");
            return sb.toString();
        }
        if (element instanceof AbstractRepositoryQuery) {
            AbstractRepositoryQuery query = (AbstractRepositoryQuery)element;
            StringBuilder sb = new StringBuilder();
            sb.append(element.getSummary());
            sb.append("  [");
            sb.append(this.getRepositoryLabel(query.getRepositoryKind(), query.getRepositoryUrl()));
            sb.append("]");
            return sb.toString();
        }
        return new TaskElementLabelProvider(false).getText(element);
    }

    private String getDetailsText(AbstractTaskContainer element, TaskListView taskListView) {
        if (element instanceof ScheduledTaskContainer) {
            ScheduledTaskContainer container = (ScheduledTaskContainer)element;
            int estimateTotal = 0;
            long elapsedTotal = 0L;
            if (taskListView != null) {
                Object[] children;
                Object[] objectArray = children = ((TaskListContentProvider)taskListView.getViewer().getContentProvider()).getChildren(element);
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    if (object instanceof AbstractTask) {
                        estimateTotal += ((AbstractTask)object).getEstimateTimeHours();
                        elapsedTotal += TasksUiPlugin.getTaskActivityManager().getElapsedTime((AbstractTask)object, container.getStart(), container.getEnd());
                    }
                    ++n2;
                }
            }
            StringBuilder sb = new StringBuilder();
            sb.append("Estimate: ");
            sb.append(estimateTotal);
            sb.append(" hours");
            sb.append("\n");
            sb.append("Elapsed: ");
            sb.append(DateUtil.getFormattedDurationShort((long)elapsedTotal));
            sb.append("\n");
            return sb.toString();
        }
        if (element instanceof AbstractTask) {
            AbstractTask task = (AbstractTask)element;
            StringBuilder sb = new StringBuilder();
            sb.append(TasksUiPlugin.getConnectorUi(task.getConnectorKind()).getTaskKindLabel(task));
            String key = task.getTaskKey();
            if (key != null) {
                sb.append(" ");
                sb.append(key);
            }
            sb.append(", ");
            sb.append(task.getPriority());
            sb.append("  [");
            sb.append(this.getRepositoryLabel(task.getConnectorKind(), task.getRepositoryUrl()));
            sb.append("]");
            sb.append("\n");
            return sb.toString();
        }
        return null;
    }

    private String getRepositoryLabel(String repositoryKind, String repositoryUrl) {
        TaskRepository repository = TasksUiPlugin.getRepositoryManager().getRepository(repositoryKind, repositoryUrl);
        if (repository != null) {
            String label = repository.getRepositoryLabel();
            if (label.indexOf("//") != -1) {
                return label.substring(repository.getUrl().indexOf("//") + 2);
            }
            return String.valueOf(label);
        }
        return "";
    }

    private String getActivityText(AbstractTaskContainer element) {
        if (element instanceof AbstractTask) {
            AbstractTask task = (AbstractTask)element;
            StringBuilder sb = new StringBuilder();
            Date date = task.getScheduledForDate();
            if (date != null) {
                sb.append("Scheduled for: ");
                sb.append(new SimpleDateFormat("E").format(date)).append(", ");
                sb.append(DateFormat.getDateInstance(1).format(date));
                sb.append(" (").append(DateFormat.getTimeInstance(3).format(date)).append(")\n");
            }
            long elapsed = TasksUiPlugin.getTaskActivityManager().getElapsedTime(task);
            String elapsedTimeString = DateUtil.getFormattedDurationShort((long)elapsed);
            sb.append("Elapsed: ");
            sb.append(elapsedTimeString);
            sb.append("\n");
            return sb.toString();
        }
        return null;
    }

    private String getIncommingText(AbstractTaskContainer element) {
        TaskListNotification notification;
        AbstractRepositoryConnector connector;
        AbstractTask task;
        if (element instanceof AbstractTask && (task = (AbstractTask)element).getSynchronizationState() == AbstractTask.RepositoryTaskSyncState.INCOMING && (connector = TasksUiPlugin.getRepositoryManager().getRepositoryConnector(task)) != null && (notification = TasksUiPlugin.getDefault().getIncommingNotification(connector, task)) != null) {
            String descriptionText;
            String res = null;
            if (((AbstractNotification)notification).getDescription() != null && (descriptionText = ((AbstractNotification)notification).getDescription()) != null && descriptionText.length() > 0) {
                res = descriptionText;
            }
            return res;
        }
        return null;
    }

    private String getStatusText(AbstractTaskContainer element) {
        IStatus status = null;
        if (element instanceof AbstractTask) {
            AbstractTask task = (AbstractTask)element;
            status = task.getSynchronizationStatus();
        } else if (element instanceof AbstractRepositoryQuery) {
            AbstractRepositoryQuery query = (AbstractRepositoryQuery)element;
            status = query.getSynchronizationStatus();
        }
        if (status != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(status.getMessage());
            if (status instanceof RepositoryStatus && ((RepositoryStatus)status).isHtmlMessage()) {
                sb.append(" Please synchronize manually for full error message.");
            }
            return sb.toString();
        }
        return null;
    }

    public Point getLocation(Point tipSize, Event event) {
        Rectangle bounds;
        Widget widget = this.getTipWidget(event);
        if (widget != null && (bounds = this.getBounds(widget)) != null) {
            return this.control.toDisplay(bounds.x + X_SHIFT, bounds.y + bounds.height + 1);
        }
        return super.getLocation(tipSize, event);
    }

    private ProgressData getProgressData(AbstractTaskContainer element, TaskListView taskListView) {
        if (element instanceof AbstractTask) {
            return null;
        }
        Object[] children = new Object[]{};
        children = element instanceof ScheduledTaskContainer && taskListView != null ? ((TaskListContentProvider)taskListView.getViewer().getContentProvider()).getChildren(element) : element.getChildren().toArray();
        int total = children.length;
        int completed = 0;
        for (AbstractTask task : element.getChildren()) {
            if (!task.isCompleted()) continue;
            ++completed;
        }
        String text = "Total: " + total + " (Complete: " + completed + ", Incomplete: " + (total - completed) + ")";
        return new ProgressData(completed, total, text);
    }

    private Image getImage(AbstractTaskContainer element) {
        if (element instanceof AbstractRepositoryQuery) {
            AbstractRepositoryQuery query = (AbstractRepositoryQuery)element;
            AbstractRepositoryConnector connector = TasksUiPlugin.getRepositoryManager().getRepositoryConnector(query.getRepositoryKind());
            if (connector != null) {
                return TasksUiPlugin.getDefault().getBrandingIcon(connector.getConnectorKind());
            }
        } else if (element instanceof AbstractTask) {
            AbstractTask repositoryTask = (AbstractTask)element;
            AbstractRepositoryConnector connector = TasksUiPlugin.getRepositoryManager().getRepositoryConnector(repositoryTask.getConnectorKind());
            if (connector != null) {
                return TasksUiPlugin.getDefault().getBrandingIcon(connector.getConnectorKind());
            }
        } else if (element instanceof ScheduledTaskContainer) {
            return TasksUiImages.getImage(TasksUiImages.CALENDAR);
        }
        return null;
    }

    protected Widget getTipWidget(Event event) {
        Point widgetPosition = new Point(event.x, event.y);
        Widget widget = event.widget;
        if (widget instanceof ToolBar) {
            ToolBar w = (ToolBar)widget;
            return w.getItem(widgetPosition);
        }
        if (widget instanceof Table) {
            Table w = (Table)widget;
            return w.getItem(widgetPosition);
        }
        if (widget instanceof Tree) {
            Tree w = (Tree)widget;
            return w.getItem(widgetPosition);
        }
        return widget;
    }

    private Rectangle getBounds(Widget widget) {
        if (widget instanceof ToolItem) {
            ToolItem w = (ToolItem)widget;
            return w.getBounds();
        }
        if (widget instanceof TableItem) {
            TableItem w = (TableItem)widget;
            return w.getBounds();
        }
        if (widget instanceof TreeItem) {
            TreeItem w = (TreeItem)widget;
            return w.getBounds();
        }
        return null;
    }

    protected boolean shouldCreateToolTip(Event event) {
        Widget tipWidget;
        this.currentTipElement = null;
        if (super.shouldCreateToolTip(event) && (tipWidget = this.getTipWidget(event)) != null) {
            Rectangle bounds = this.getBounds(tipWidget);
            if (tipWidget instanceof TaskListHyperlink) {
                this.currentTipElement = this.getTaskListElement(tipWidget);
            } else if (bounds != null && this.control.getBounds().contains(bounds.x, bounds.y)) {
                this.currentTipElement = this.getTaskListElement(tipWidget);
            }
        }
        if (this.currentTipElement == null) {
            this.hide();
            return false;
        }
        return true;
    }

    protected Composite createToolTipContentArea(Event event, Composite parent) {
        String helpText;
        String statusText;
        ProgressData progress;
        String incommingText;
        String activityText;
        String synchText;
        assert (this.currentTipElement != null);
        TaskListView taskListView = TaskListView.getFromActivePerspective();
        Composite composite = this.createToolTipContentAreaComposite(parent);
        this.addIconAndLabel(composite, this.getImage(this.currentTipElement), this.getTitleText(this.currentTipElement));
        String detailsText = this.getDetailsText(this.currentTipElement, taskListView);
        if (detailsText != null) {
            this.addIconAndLabel(composite, null, detailsText);
        }
        if ((synchText = this.getSynchText(this.currentTipElement)) != null) {
            this.addIconAndLabel(composite, TasksUiImages.getImage(TasksUiImages.REPOSITORY_SYNCHRONIZE), synchText);
        }
        if ((activityText = this.getActivityText(this.currentTipElement)) != null) {
            this.addIconAndLabel(composite, TasksUiImages.getImage(TasksUiImages.CALENDAR), activityText);
        }
        if ((incommingText = this.getIncommingText(this.currentTipElement)) != null) {
            this.addIconAndLabel(composite, TasksUiImages.getImage(TasksUiImages.OVERLAY_INCOMMING), incommingText);
        }
        if ((progress = this.getProgressData(this.currentTipElement, taskListView)) != null) {
            this.addIconAndLabel(composite, null, progress.text);
            Label label = new Label(composite, 0);
            GridData labelGridData = new GridData(4, 128, true, false);
            labelGridData.heightHint = 0;
            label.setLayoutData((Object)labelGridData);
            Composite progressComposite = new Composite(composite, 0);
            GridLayout progressLayout = new GridLayout(1, false);
            progressLayout.marginWidth = 0;
            progressLayout.marginHeight = 0;
            progressComposite.setLayout((Layout)progressLayout);
            progressComposite.setLayoutData((Object)new GridData(4, 128, true, false));
            WorkweekProgressBar taskProgressBar = new WorkweekProgressBar(progressComposite);
            taskProgressBar.setLayoutData(new GridData(4, 128, true, false));
            taskProgressBar.reset(progress.completed, progress.total);
        }
        if ((statusText = this.getStatusText(this.currentTipElement)) != null) {
            this.addIconAndLabel(composite, TasksUiImages.getImage(TasksUiImages.WARNING), statusText);
        }
        if ((helpText = this.getHelpText(this.currentTipElement)) != null) {
            this.addIconAndLabel(composite, TasksUiImages.getImage(TasksUiImages.QUESTION), helpText);
        }
        this.visible = true;
        return composite;
    }

    private String getHelpText(AbstractTaskContainer element) {
        TaskListView taskListView;
        if ((element instanceof TaskCategory || element instanceof AbstractRepositoryQuery) && AbstractTaskListFilter.hasDescendantIncoming(element) && (taskListView = TaskListView.getFromActivePerspective()) != null && !taskListView.isFocusedMode() && TasksUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.tasks.ui.filters.complete")) {
            Object[] children = ((TaskListContentProvider)taskListView.getViewer().getContentProvider()).getChildren(element);
            boolean hasIncoming = false;
            Object[] objectArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (object instanceof AbstractTask && ((AbstractTask)object).getSynchronizationState().equals((Object)AbstractTask.RepositoryTaskSyncState.INCOMING)) {
                    hasIncoming = true;
                    break;
                }
                ++n2;
            }
            if (!hasIncoming) {
                return "Some incoming elements may be filtered,\nfocus the view to see all incomings";
            }
        }
        if (element instanceof UnfiledCategory) {
            return "Automatic container for all local tasks\nwith no category set";
        }
        if (element instanceof OrphanedTasksContainer) {
            return "Automatic container for repository tasks\nnot matched by any query";
        }
        return null;
    }

    protected Composite createToolTipContentAreaComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 5;
        gridLayout.marginHeight = 2;
        composite.setLayout((Layout)gridLayout);
        composite.setBackground(composite.getDisplay().getSystemColor(29));
        return composite;
    }

    private String getSynchText(AbstractTaskContainer element) {
        String syncStamp;
        if (element instanceof AbstractRepositoryQuery && (syncStamp = ((AbstractRepositoryQuery)element).getLastSynchronizedTimeStamp()) != null) {
            return "Synchronized: " + syncStamp;
        }
        return null;
    }

    private String removeTrailingNewline(String text) {
        if (text.endsWith("\n")) {
            return text.substring(0, text.length() - 1);
        }
        return text;
    }

    protected void addIconAndLabel(Composite parent, Image image, String text) {
        Label imageLabel = new Label(parent, 0);
        imageLabel.setForeground(parent.getDisplay().getSystemColor(28));
        imageLabel.setBackground(parent.getDisplay().getSystemColor(29));
        imageLabel.setLayoutData((Object)new GridData(34));
        imageLabel.setImage(image);
        Label textLabel = new Label(parent, 0);
        textLabel.setForeground(parent.getDisplay().getSystemColor(28));
        textLabel.setBackground(parent.getDisplay().getSystemColor(29));
        textLabel.setLayoutData((Object)new GridData(772));
        textLabel.setText(this.removeTrailingNewline(text));
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isTriggeredByMouse() {
        return this.triggeredByMouse;
    }

    public void show(Point location) {
        super.show(location);
        this.triggeredByMouse = false;
    }

    private static class ProgressData {
        int completed;
        int total;
        String text;

        public ProgressData(int completed, int total, String text) {
            this.completed = completed;
            this.total = total;
            this.text = text;
        }
    }

    public static interface TaskListToolTipListener {
        public void toolTipHidden(Event var1);
    }
}

