/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.views;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.mylyn.internal.tasks.ui.actions.AddRepositoryAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.DeleteTaskRepositoryAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.EditRepositoryPropertiesAction;
import org.eclipse.mylyn.internal.tasks.ui.views.DisconnectRepositoryAction;
import org.eclipse.mylyn.internal.tasks.ui.views.ResetRepositoryConfigurationAction;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskRepositoriesSorter;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskRepositoryLabelProvider;
import org.eclipse.mylyn.tasks.core.ITaskRepositoryListener;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.ui.part.ViewPart;

public class TaskRepositoriesView
extends ViewPart {
    public static final String ID = "org.eclipse.mylyn.tasks.ui.views.repositories";
    private TableViewer viewer;
    private Action addRepositoryAction = new AddRepositoryAction();
    private BaseSelectionListenerAction deleteRepositoryAction;
    private BaseSelectionListenerAction repositoryPropertiesAction;
    private BaseSelectionListenerAction resetConfigurationAction;
    private DisconnectRepositoryAction offlineAction;
    private final ITaskRepositoryListener REPOSITORY_LISTENER = new ITaskRepositoryListener(){

        public void repositoriesRead() {
            this.asyncExec(new Runnable(){

                public void run() {
                    TaskRepositoriesView.this.refresh();
                }
            });
        }

        private void asyncExec(Runnable runnable) {
            if (Display.getCurrent() != null) {
                runnable.run();
            } else {
                Display.getDefault().asyncExec(runnable);
            }
        }

        public void repositoryAdded(TaskRepository repository) {
            this.asyncExec(new Runnable(){

                public void run() {
                    TaskRepositoriesView.this.refresh();
                }
            });
        }

        public void repositoryRemoved(TaskRepository repository) {
            this.asyncExec(new Runnable(){

                public void run() {
                    TaskRepositoriesView.this.refresh();
                }
            });
        }

        public void repositorySettingsChanged(TaskRepository repository) {
            this.asyncExec(new Runnable(){

                public void run() {
                    TaskRepositoriesView.this.refresh();
                }
            });
        }
    };

    public TaskRepositoriesView() {
        TasksUiPlugin.getRepositoryManager().addListener(this.REPOSITORY_LISTENER);
    }

    public static TaskRepositoriesView getFromActivePerspective() {
        if (PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null) {
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            if (activePage == null) {
                return null;
            }
            IViewPart view = activePage.findView(ID);
            if (view instanceof TaskRepositoriesView) {
                return (TaskRepositoriesView)view;
            }
        }
        return null;
    }

    public static TaskRepositoriesView openInActivePerspective() {
        try {
            return (TaskRepositoriesView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(ID);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void createPartControl(Composite parent) {
        this.viewer = new TableViewer(parent, 66306);
        this.viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new TaskRepositoryLabelProvider(), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator()));
        this.viewer.setSorter((ViewerSorter)new TaskRepositoriesSorter());
        this.viewer.setInput((Object)this.getViewSite());
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (TaskRepositoriesView.this.repositoryPropertiesAction.isEnabled()) {
                    TaskRepositoriesView.this.repositoryPropertiesAction.run();
                }
            }
        });
        TasksUiPlugin.getRepositoryManager().addListener((ITaskRepositoryListener)new TaskRepositoryListener());
        this.makeActions();
        this.hookContextMenu();
        this.contributeToActionBars();
        this.getSite().setSelectionProvider((ISelectionProvider)this.getViewer());
    }

    private void makeActions() {
        this.deleteRepositoryAction = new DeleteTaskRepositoryAction();
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this.deleteRepositoryAction);
        this.repositoryPropertiesAction = new EditRepositoryPropertiesAction();
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this.repositoryPropertiesAction);
        this.resetConfigurationAction = new ResetRepositoryConfigurationAction();
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this.resetConfigurationAction);
        this.offlineAction = new DisconnectRepositoryAction();
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this.offlineAction);
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                TaskRepositoriesView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.addRepositoryAction);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.addRepositoryAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.deleteRepositoryAction);
        manager.add((IAction)this.resetConfigurationAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.offlineAction);
        manager.add((IContributionItem)new Separator("repository"));
        manager.add((IContributionItem)new Separator("additions"));
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.repositoryPropertiesAction);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.addRepositoryAction);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void refresh() {
        if (this.viewer != null && !this.viewer.getControl().isDisposed()) {
            this.viewer.refresh();
        }
    }

    public TableViewer getViewer() {
        return this.viewer;
    }

    public class TaskRepositoryListener
    implements ITaskRepositoryListener {
        public void repositoriesRead() {
        }

        public void repositoryAdded(TaskRepository repository) {
        }

        public void repositoryRemoved(TaskRepository repository) {
        }

        public void repositorySettingsChanged(TaskRepository repository) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (!TaskRepositoriesView.this.getViewer().getControl().isDisposed()) {
                        TaskRepositoriesView.this.getViewer().refresh(true);
                    }
                }
            });
        }
    }

    static class ViewContentProvider
    implements IStructuredContentProvider {
        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            return TasksUiPlugin.getRepositoryManager().getAllRepositories().toArray();
        }
    }
}

