/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.wizards;

import java.util.Collection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.internal.tasks.ui.wizards.SelectRepositoryClientPage;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.AbstractRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.ui.wizards.AbstractRepositorySettingsPage;
import org.eclipse.ui.INewWizard;

public abstract class AbstractRepositoryClientWizard
extends Wizard
implements INewWizard {
    private String repositoryType;
    protected TaskRepository repository;
    private SelectRepositoryClientPage selectRepositoryClientPage = new SelectRepositoryClientPage(this);
    protected AbstractRepositorySettingsPage abstractRepositorySettingsPage;
    protected AbstractRepositoryConnector repositoryConnector;

    protected AbstractRepositoryClientWizard() {
        this(null);
    }

    protected AbstractRepositoryClientWizard(String repositoryType) {
        this.repositoryType = repositoryType;
        this.setDefaultPageImageDescriptor(TasksUiImages.BANNER_REPOSITORY);
    }

    public void setRepositoryConnector(AbstractRepositoryConnector repositoryConnector) {
        this.repositoryConnector = repositoryConnector;
    }

    public AbstractRepositoryConnector getRepositoryConnector() {
        return this.repositoryConnector;
    }

    public TaskRepository getRepository() {
        return this.repository;
    }

    public void addPages() {
        Collection connectors = TasksUiPlugin.getRepositoryManager().getRepositoryConnectors();
        if (this.repositoryType != null || connectors.size() == 1) {
            AbstractRepositoryConnector connector = null;
            connector = this.repositoryType != null ? TasksUiPlugin.getRepositoryManager().getRepositoryConnector(this.repositoryType) : connectors.toArray(new AbstractRepositoryConnector[1])[0];
            this.setRepositoryConnector(connector);
            AbstractRepositoryConnectorUi connectorUi = TasksUiPlugin.getConnectorUi(connector.getConnectorKind());
            AbstractRepositorySettingsPage nextPage = connectorUi.getSettingsPage();
            this.setRepositorySettingsPage(nextPage);
            nextPage.setWizard((IWizard)this);
            this.addPage((IWizardPage)nextPage);
        } else {
            this.addPage((IWizardPage)this.selectRepositoryClientPage);
        }
    }

    public boolean canFinish() {
        return this.selectRepositoryClientPage.isPageComplete();
    }

    public void setRepositorySettingsPage(AbstractRepositorySettingsPage abstractRepositorySettingsPage) {
        this.abstractRepositorySettingsPage = abstractRepositorySettingsPage;
    }
}

