/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.wizards;

import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.mylyn.internal.tasks.ui.AddExistingTaskJob;
import org.eclipse.mylyn.internal.tasks.ui.wizards.ExistingTaskWizardPage;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class CommonAddExistingTaskWizard
extends Wizard {
    private TaskRepository repository;
    private ExistingTaskWizardPage page;

    public CommonAddExistingTaskWizard(TaskRepository repository) {
        this.repository = repository;
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle("Add Existing Repository Task");
        this.init();
    }

    public final boolean performFinish() {
        final IProgressService svc = PlatformUI.getWorkbench().getProgressService();
        final AddExistingTaskJob job = new AddExistingTaskJob(this.repository, this.getTaskId());
        job.schedule();
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                svc.showInDialog(CommonAddExistingTaskWizard.this.getShell(), (Job)job);
            }
        });
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    private void init() {
        super.setForcePreviousAndNextButtons(true);
    }

    public void addPages() {
        super.addPages();
        this.page = new ExistingTaskWizardPage();
        this.addPage((IWizardPage)this.page);
    }

    protected String getTaskId() {
        return this.page.getTaskId();
    }
}

