/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.wizards;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskElementLabelProvider;
import org.eclipse.mylyn.tasks.core.AbstractAttributeFactory;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.RepositoryAttachment;
import org.eclipse.mylyn.tasks.core.RepositoryTaskData;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class ContextRetrieveWizardPage
extends WizardPage {
    private static final String DESCRIPTION = "Select a context to retrieve from table below.";
    private static final String COLUMN_COMMENT = "Description";
    private static final String COLUMN_AUTHOR = "Author";
    private static final String COLUMN_DATE = "Date";
    private TaskRepository repository;
    private AbstractTask task;
    private TaskElementLabelProvider labelProvider = new TaskElementLabelProvider(false);
    private RepositoryAttachment selectedContextAttachment = null;

    protected ContextRetrieveWizardPage(TaskRepository repository, AbstractTask task) {
        super("Attach context");
        this.repository = repository;
        this.task = task;
        this.setDescription(DESCRIPTION);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        Text summary = new Text(composite, 0);
        summary.setText("Task: " + this.labelProvider.getText(this.task));
        summary.setEditable(false);
        final Table contextTable = new Table(composite, 67584);
        contextTable.setHeaderVisible(true);
        contextTable.setLinesVisible(true);
        contextTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (contextTable.getSelectionIndex() > -1) {
                    ContextRetrieveWizardPage.this.selectedContextAttachment = (RepositoryAttachment)contextTable.getItem(contextTable.getSelectionIndex()).getData();
                    ContextRetrieveWizardPage.this.getWizard().getContainer().updateButtons();
                }
            }
        });
        contextTable.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                ContextRetrieveWizardPage.this.selectedContextAttachment = (RepositoryAttachment)contextTable.getItem(contextTable.getSelectionIndex()).getData();
                ContextRetrieveWizardPage.this.getWizard().getContainer().updateButtons();
                ContextRetrieveWizardPage.this.getWizard().performFinish();
                ContextRetrieveWizardPage.this.getWizard().getContainer().getShell().close();
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        AbstractRepositoryConnector connector = TasksUiPlugin.getRepositoryManager().getRepositoryConnector(this.repository.getConnectorKind());
        ArrayList contextAttachments = new ArrayList();
        if (connector.getAttachmentHandler() != null) {
            contextAttachments = new ArrayList(connector.getAttachmentHandler().getContextAttachments(this.repository, this.task));
        }
        Collections.sort(contextAttachments, new Comparator<RepositoryAttachment>(){

            @Override
            public int compare(RepositoryAttachment attachment1, RepositoryAttachment attachment2) {
                RepositoryTaskData data = TasksUiPlugin.getTaskDataManager().getNewTaskData(ContextRetrieveWizardPage.this.task.getRepositoryUrl(), ContextRetrieveWizardPage.this.task.getTaskId());
                AbstractAttributeFactory factory = null;
                Date created1 = null;
                Date created2 = null;
                if (data != null) {
                    factory = data.getAttributeFactory();
                }
                if (factory != null) {
                    created1 = factory.getDateForAttributeType("task.common.attachment.date", attachment1.getDateCreated());
                    created2 = factory.getDateForAttributeType("task.common.attachment.date", attachment2.getDateCreated());
                }
                if (created1 != null && created2 != null) {
                    return -1 * created1.compareTo(created2);
                }
                if (created1 == null && created2 != null) {
                    return 1;
                }
                if (created1 != null && created2 == null) {
                    return -1;
                }
                return 0;
            }
        });
        TableColumn[] columns = new TableColumn[3];
        columns[0] = new TableColumn(contextTable, 16384);
        columns[0].setText(COLUMN_DATE);
        columns[1] = new TableColumn(contextTable, 16384);
        columns[1].setText(COLUMN_AUTHOR);
        columns[2] = new TableColumn(contextTable, 0x1000000);
        columns[2].setText(COLUMN_COMMENT);
        for (RepositoryAttachment attachment : contextAttachments) {
            TableItem item = new TableItem(contextTable, 0);
            item.setText(0, attachment.getDateCreated());
            item.setText(1, attachment.getCreator());
            item.setText(2, attachment.getDescription());
            item.setData((Object)attachment);
        }
        int i = 0;
        int n = columns.length;
        while (i < n) {
            columns[i].pack();
            ++i;
        }
        contextTable.setLayoutData((Object)new GridData(1808));
        this.setControl((Control)composite);
        if (contextAttachments.size() > 0) {
            contextTable.setSelection(0);
            this.selectedContextAttachment = (RepositoryAttachment)contextAttachments.get(0);
            this.getWizard().getContainer().updateButtons();
        }
        contextTable.setFocus();
    }

    public RepositoryAttachment getSelectedContext() {
        return this.selectedContextAttachment;
    }

    public boolean isPageComplete() {
        if (this.selectedContextAttachment == null) {
            return false;
        }
        return super.isPageComplete();
    }
}

