/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.wizards;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mylyn.internal.tasks.core.LocalAttachment;
import org.eclipse.mylyn.internal.tasks.ui.TaskListColorsAndFonts;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.internal.tasks.ui.wizards.NewAttachmentPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ScreenshotAttachmentPage
extends WizardPage {
    private ScreenshotAttachmentPage page;
    private LocalAttachment attachment;
    private Button captureButton;
    private Button fitButton;
    private Image screenshotImage;
    private Canvas canvas;
    private ScrolledComposite scrolledComposite;
    private Rectangle currentSelection;
    private Rectangle originalSelection;
    private Point startPoint;
    private Set<SelectionSide> resizableSides = EnumSet.noneOf(SelectionSide.class);
    private double scaleFactor = 1.0;
    private Map<Integer, Cursor> cursors = new HashMap<Integer, Cursor>();
    private Action currentAction = Action.IDLE;
    private static final int SQUARE_SIZE = 3;
    private List<GrabPoint> grabPoints = new ArrayList<GrabPoint>(8);

    protected ScreenshotAttachmentPage(LocalAttachment attachment) {
        super("ScreenShotAttachment");
        this.setTitle("Capture Screenshot");
        this.setDescription("After capturing, drag the mouse to crop. This window will not be captured. Note that you can continue to interact with the workbench in order to set up the screenshot.");
        this.attachment = attachment;
        this.page = this;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        this.setControl((Control)composite);
        this.allocateCursors();
        Composite buttonsComposite = new Composite(composite, 0);
        buttonsComposite.setLayout((Layout)new GridLayout(3, false));
        this.captureButton = new Button(buttonsComposite, 8);
        this.captureButton.setText("Capture Desktop");
        this.captureButton.setImage(TasksUiImages.getImage(TasksUiImages.IMAGE_CAPTURE));
        this.captureButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScreenshotAttachmentPage.this.captureScreenshotContent();
                ScreenshotAttachmentPage.this.page.setErrorMessage(null);
                ScreenshotAttachmentPage.this.fitButton.setEnabled(true);
            }
        });
        this.fitButton = new Button(buttonsComposite, 2);
        this.fitButton.setText("Fit Image");
        this.fitButton.setImage(TasksUiImages.getImage(TasksUiImages.IMAGE_FIT));
        this.fitButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScreenshotAttachmentPage.this.refreshCanvasSize();
            }
        });
        this.fitButton.setSelection(true);
        this.fitButton.setEnabled(false);
        this.scrolledComposite = new ScrolledComposite(composite, 2816);
        this.scrolledComposite.setLayoutData((Object)GridDataFactory.fillDefaults().align(4, 4).grab(true, true).create());
        this.canvas = new Canvas((Composite)this.scrolledComposite, 0x20000000);
        this.scrolledComposite.setContent((Control)this.canvas);
        this.canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (ScreenshotAttachmentPage.this.screenshotImage != null) {
                    Rectangle imageBounds = ScreenshotAttachmentPage.this.screenshotImage.getBounds();
                    Rectangle canvasBounds = ScreenshotAttachmentPage.this.canvas.getClientArea();
                    if (ScreenshotAttachmentPage.this.fitButton.getSelection()) {
                        e.gc.drawImage(ScreenshotAttachmentPage.this.screenshotImage, 0, 0, imageBounds.width, imageBounds.height, 0, 0, canvasBounds.width, canvasBounds.height);
                    } else {
                        e.gc.drawImage(ScreenshotAttachmentPage.this.screenshotImage, 0, 0);
                    }
                    if (ScreenshotAttachmentPage.this.currentAction == Action.IDLE) {
                        if (ScreenshotAttachmentPage.this.currentSelection != null) {
                            ScreenshotAttachmentPage.this.drawSelection(e.gc);
                        }
                    } else if ((ScreenshotAttachmentPage.this.currentAction == Action.SELECTING || ScreenshotAttachmentPage.this.currentAction == Action.RESIZING_SELECTION || ScreenshotAttachmentPage.this.currentAction == Action.MOVING_SELECTION) && ScreenshotAttachmentPage.this.currentSelection != null) {
                        ScreenshotAttachmentPage.this.drawSelectionPreview(e.gc);
                    }
                } else {
                    ScreenshotAttachmentPage.this.fitButton.setEnabled(false);
                }
            }
        });
        this.scrolledComposite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                if (ScreenshotAttachmentPage.this.fitButton.getSelection()) {
                    ScreenshotAttachmentPage.this.refreshCanvasSize();
                }
            }
        });
        this.registerMouseListeners();
    }

    public void dispose() {
        this.canvas.setCursor(null);
        for (Cursor cursor : this.cursors.values()) {
            cursor.dispose();
        }
        super.dispose();
    }

    private void allocateCursors() {
        Display display = Display.getCurrent();
        this.cursors.put(0, new Cursor((Device)display, 0));
        this.cursors.put(5, new Cursor((Device)display, 5));
        this.cursors.put(8, new Cursor((Device)display, 8));
        this.cursors.put(6, new Cursor((Device)display, 6));
        this.cursors.put(7, new Cursor((Device)display, 7));
        this.cursors.put(9, new Cursor((Device)display, 9));
        this.cursors.put(2, new Cursor((Device)display, 2));
    }

    private Rectangle getScaledSelection() {
        if (this.currentSelection == null) {
            return null;
        }
        int x = (int)Math.round((double)this.currentSelection.x * this.scaleFactor);
        int y = (int)Math.round((double)this.currentSelection.y * this.scaleFactor);
        int right = (int)Math.round((double)(this.currentSelection.x + this.currentSelection.width) * this.scaleFactor);
        int bottom = (int)Math.round((double)(this.currentSelection.y + this.currentSelection.height) * this.scaleFactor);
        int width = Math.min(right, (int)Math.round((double)(this.screenshotImage.getBounds().width - 1) * this.scaleFactor)) - x;
        int height = Math.min(bottom, (int)Math.round((double)(this.screenshotImage.getBounds().height - 1) * this.scaleFactor)) - y;
        return new Rectangle(x, y, width, height);
    }

    public boolean isPageComplete() {
        return this.screenshotImage != null;
    }

    public IWizardPage getNextPage() {
        NewAttachmentPage page = (NewAttachmentPage)this.getWizard().getPage("AttachmentDetails");
        this.attachment.setContentType("image/jpeg");
        page.setFilePath("<Screenshot>");
        page.setContentType();
        this.getCropScreenshot();
        return page;
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    private void captureScreenshotContent() {
        final Display display = Display.getDefault();
        final Shell wizardShell = this.getWizard().getContainer().getShell();
        wizardShell.setVisible(false);
        try {
            Thread.sleep(400L);
        }
        catch (InterruptedException interruptedException) {}
        display.asyncExec(new Runnable(){

            public void run() {
                Rectangle displayBounds = display.getBounds();
                ScreenshotAttachmentPage.this.screenshotImage = new Image((Device)display, displayBounds);
                GC gc = new GC((Drawable)display);
                gc.copyArea(ScreenshotAttachmentPage.this.screenshotImage, 0, 0);
                gc.dispose();
                ScreenshotAttachmentPage.this.clearSelection();
                ScreenshotAttachmentPage.this.refreshCanvasSize();
                wizardShell.setVisible(true);
                if (ScreenshotAttachmentPage.this.screenshotImage != null) {
                    ScreenshotAttachmentPage.this.setPageComplete(true);
                }
            }
        });
    }

    private void refreshCurrentSelection(int x, int y) {
        int startX = Math.min(this.startPoint.x, x);
        int startY = Math.min(this.startPoint.y, y);
        int width = Math.abs(this.startPoint.x - x);
        int height = Math.abs(this.startPoint.y - y);
        this.currentSelection = new Rectangle(startX, startY, width, height);
        Rectangle imageBounds = this.screenshotImage.getBounds();
        --imageBounds.width;
        --imageBounds.height;
        this.currentSelection.intersect(imageBounds);
    }

    private void setUpGrabPoints() {
        if (this.currentSelection == null) {
            return;
        }
        this.canvas.setCursor(null);
        this.grabPoints.clear();
        Rectangle scaledSelection = this.getScaledSelection();
        this.grabPoints.add(GrabPoint.createGrabPoint(scaledSelection.x, scaledSelection.y, 8, (Set<SelectionSide>)EnumSet.of(SelectionSide.LEFT, SelectionSide.TOP)));
        this.grabPoints.add(GrabPoint.createGrabPoint(scaledSelection.x + scaledSelection.width / 2, scaledSelection.y, 7, (Set<SelectionSide>)EnumSet.of(SelectionSide.TOP)));
        this.grabPoints.add(GrabPoint.createGrabPoint(scaledSelection.x + scaledSelection.width, scaledSelection.y, 6, (Set<SelectionSide>)EnumSet.of(SelectionSide.TOP, SelectionSide.RIGHT)));
        this.grabPoints.add(GrabPoint.createGrabPoint(scaledSelection.x, scaledSelection.y + scaledSelection.height / 2, 9, (Set<SelectionSide>)EnumSet.of(SelectionSide.LEFT)));
        this.grabPoints.add(GrabPoint.createGrabPoint(scaledSelection.x + scaledSelection.width, scaledSelection.y + scaledSelection.height / 2, 9, (Set<SelectionSide>)EnumSet.of(SelectionSide.RIGHT)));
        this.grabPoints.add(GrabPoint.createGrabPoint(scaledSelection.x, scaledSelection.y + scaledSelection.height, 6, (Set<SelectionSide>)EnumSet.of(SelectionSide.LEFT, SelectionSide.BOTTOM)));
        this.grabPoints.add(GrabPoint.createGrabPoint(scaledSelection.x + scaledSelection.width / 2, scaledSelection.y + scaledSelection.height, 7, (Set<SelectionSide>)EnumSet.of(SelectionSide.BOTTOM)));
        this.grabPoints.add(GrabPoint.createGrabPoint(scaledSelection.x + scaledSelection.width, scaledSelection.y + scaledSelection.height, 8, (Set<SelectionSide>)EnumSet.of(SelectionSide.BOTTOM, SelectionSide.RIGHT)));
    }

    private void refreshSelectionResize(int x, int y) {
        this.currentSelection = new Rectangle(this.originalSelection.x, this.originalSelection.y, this.originalSelection.width, this.originalSelection.height);
        int deltaX = x - this.startPoint.x;
        int deltaY = y - this.startPoint.y;
        Rectangle imageBounds = this.screenshotImage.getBounds();
        if (this.resizableSides.contains((Object)SelectionSide.LEFT) && this.originalSelection.x + (deltaX = Math.min(deltaX, this.originalSelection.width)) < 0) {
            deltaX = -this.originalSelection.x;
        }
        if (this.resizableSides.contains((Object)SelectionSide.RIGHT) && this.originalSelection.x + this.originalSelection.width + (deltaX = Math.max(deltaX, -this.originalSelection.width)) - 1 > imageBounds.width) {
            deltaX = imageBounds.width - (this.originalSelection.x + this.originalSelection.width);
        }
        if (this.resizableSides.contains((Object)SelectionSide.TOP) && this.originalSelection.y + (deltaY = Math.min(deltaY, this.originalSelection.height)) < 0) {
            deltaY = -this.originalSelection.y;
        }
        if (this.resizableSides.contains((Object)SelectionSide.BOTTOM) && this.originalSelection.y + this.originalSelection.height + (deltaY = Math.max(deltaY, -this.originalSelection.height)) - 1 > imageBounds.height) {
            deltaY = imageBounds.height - (this.originalSelection.y + this.originalSelection.height);
        }
        if (this.resizableSides.contains((Object)SelectionSide.LEFT)) {
            this.currentSelection.x += deltaX;
            this.currentSelection.width -= deltaX;
        }
        if (this.resizableSides.contains((Object)SelectionSide.RIGHT)) {
            this.currentSelection.width += deltaX;
        }
        if (this.resizableSides.contains((Object)SelectionSide.TOP)) {
            this.currentSelection.y += deltaY;
            this.currentSelection.height -= deltaY;
        }
        if (this.resizableSides.contains((Object)SelectionSide.BOTTOM)) {
            this.currentSelection.height += deltaY;
        }
    }

    private void refreshSelectionPosition(int x, int y) {
        int newX = this.originalSelection.x + (x - this.startPoint.x);
        int newY = this.originalSelection.y + (y - this.startPoint.y);
        if (newX < 0) {
            newX = 0;
        }
        if (newY < 0) {
            newY = 0;
        }
        Rectangle imageBounds = this.screenshotImage.getBounds();
        if (newX + this.originalSelection.width - 1 > imageBounds.width) {
            newX = imageBounds.width - this.originalSelection.width;
        }
        if (newY + this.originalSelection.height - 1 > imageBounds.height) {
            newY = imageBounds.height - this.originalSelection.height;
        }
        this.currentSelection = new Rectangle(newX, newY, this.originalSelection.width, this.originalSelection.height);
    }

    private void registerMouseListeners() {
        this.canvas.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                if (ScreenshotAttachmentPage.this.currentAction == Action.SELECTING) {
                    ScreenshotAttachmentPage.this.refreshCurrentSelection((int)Math.round((double)e.x / ScreenshotAttachmentPage.this.scaleFactor), (int)Math.round((double)e.y / ScreenshotAttachmentPage.this.scaleFactor));
                    ScreenshotAttachmentPage.this.canvas.redraw();
                } else if (ScreenshotAttachmentPage.this.currentAction == Action.RESIZING_SELECTION) {
                    ScreenshotAttachmentPage.this.refreshSelectionResize((int)Math.round((double)e.x / ScreenshotAttachmentPage.this.scaleFactor), (int)Math.round((double)e.y / ScreenshotAttachmentPage.this.scaleFactor));
                    ScreenshotAttachmentPage.this.canvas.redraw();
                } else if (ScreenshotAttachmentPage.this.currentAction == Action.MOVING_SELECTION) {
                    ScreenshotAttachmentPage.this.refreshSelectionPosition((int)Math.round((double)e.x / ScreenshotAttachmentPage.this.scaleFactor), (int)Math.round((double)e.y / ScreenshotAttachmentPage.this.scaleFactor));
                    ScreenshotAttachmentPage.this.canvas.redraw();
                } else if (ScreenshotAttachmentPage.this.currentAction == Action.IDLE && ScreenshotAttachmentPage.this.currentSelection != null) {
                    boolean cursorSet = false;
                    for (GrabPoint point : ScreenshotAttachmentPage.this.grabPoints) {
                        if (!point.grabArea.contains(e.x, e.y)) continue;
                        ScreenshotAttachmentPage.this.canvas.setCursor((Cursor)ScreenshotAttachmentPage.this.cursors.get(point.cursorType));
                        cursorSet = true;
                        break;
                    }
                    if (!cursorSet && ScreenshotAttachmentPage.this.getScaledSelection().contains(e.x, e.y)) {
                        ScreenshotAttachmentPage.this.canvas.setCursor((Cursor)ScreenshotAttachmentPage.this.cursors.get(5));
                        cursorSet = true;
                    }
                    if (!cursorSet && ScreenshotAttachmentPage.this.canvas.getCursor() != null) {
                        ScreenshotAttachmentPage.this.canvas.setCursor(null);
                    }
                }
            }
        });
        this.canvas.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (ScreenshotAttachmentPage.this.currentAction == Action.SELECTING || ScreenshotAttachmentPage.this.currentAction == Action.RESIZING_SELECTION || ScreenshotAttachmentPage.this.currentAction == Action.MOVING_SELECTION) {
                    ScreenshotAttachmentPage.this.canvas.setCursor((Cursor)ScreenshotAttachmentPage.this.cursors.get(0));
                    int scaledX = (int)Math.round((double)e.x / ScreenshotAttachmentPage.this.scaleFactor);
                    int scaledY = (int)Math.round((double)e.y / ScreenshotAttachmentPage.this.scaleFactor);
                    if (ScreenshotAttachmentPage.this.currentAction == Action.SELECTING) {
                        ScreenshotAttachmentPage.this.refreshCurrentSelection(scaledX, scaledY);
                    } else if (ScreenshotAttachmentPage.this.currentAction == Action.RESIZING_SELECTION) {
                        ScreenshotAttachmentPage.this.refreshSelectionResize(scaledX, scaledY);
                    } else if (ScreenshotAttachmentPage.this.currentAction == Action.MOVING_SELECTION) {
                        ScreenshotAttachmentPage.this.refreshSelectionPosition(scaledX, scaledY);
                    }
                    if (((ScreenshotAttachmentPage)ScreenshotAttachmentPage.this).currentSelection.width == 0 && ((ScreenshotAttachmentPage)ScreenshotAttachmentPage.this).currentSelection.height == 0) {
                        ScreenshotAttachmentPage.this.currentSelection = null;
                    }
                    ScreenshotAttachmentPage.this.setUpGrabPoints();
                    ScreenshotAttachmentPage.this.startPoint = null;
                    ScreenshotAttachmentPage.this.currentAction = Action.IDLE;
                    ScreenshotAttachmentPage.this.canvas.redraw();
                }
            }

            public void mouseDown(MouseEvent e) {
                if (ScreenshotAttachmentPage.this.currentAction != Action.IDLE) {
                    return;
                }
                if (ScreenshotAttachmentPage.this.currentSelection != null) {
                    for (GrabPoint point : ScreenshotAttachmentPage.this.grabPoints) {
                        if (!point.grabArea.contains(e.x, e.y)) continue;
                        ScreenshotAttachmentPage.this.originalSelection = ScreenshotAttachmentPage.this.currentSelection;
                        ScreenshotAttachmentPage.this.currentAction = Action.RESIZING_SELECTION;
                        ScreenshotAttachmentPage.this.resizableSides = point.resizableSides;
                        ScreenshotAttachmentPage.this.startPoint = new Point((int)((double)e.x / ScreenshotAttachmentPage.this.scaleFactor), (int)((double)e.y / ScreenshotAttachmentPage.this.scaleFactor));
                        ScreenshotAttachmentPage.this.canvas.redraw();
                        return;
                    }
                }
                if (ScreenshotAttachmentPage.this.currentSelection != null && ScreenshotAttachmentPage.this.currentSelection.contains((int)((double)e.x / ScreenshotAttachmentPage.this.scaleFactor), (int)((double)e.y / ScreenshotAttachmentPage.this.scaleFactor))) {
                    ScreenshotAttachmentPage.this.originalSelection = ScreenshotAttachmentPage.this.currentSelection;
                    ScreenshotAttachmentPage.this.currentAction = Action.MOVING_SELECTION;
                    ScreenshotAttachmentPage.this.startPoint = new Point((int)((double)e.x / ScreenshotAttachmentPage.this.scaleFactor), (int)((double)e.y / ScreenshotAttachmentPage.this.scaleFactor));
                    ScreenshotAttachmentPage.this.canvas.redraw();
                    return;
                }
                ScreenshotAttachmentPage.this.canvas.setCursor((Cursor)ScreenshotAttachmentPage.this.cursors.get(2));
                ScreenshotAttachmentPage.this.currentAction = Action.SELECTING;
                ScreenshotAttachmentPage.this.currentSelection = null;
                ScreenshotAttachmentPage.this.startPoint = new Point((int)((double)e.x / ScreenshotAttachmentPage.this.scaleFactor), (int)((double)e.y / ScreenshotAttachmentPage.this.scaleFactor));
                ScreenshotAttachmentPage.this.canvas.redraw();
            }
        });
    }

    private void clearSelection() {
        this.currentSelection = null;
        this.startPoint = null;
    }

    private void refreshCanvasSize() {
        if (this.fitButton.getSelection()) {
            this.scrolledComposite.getHorizontalBar().setVisible(false);
            this.scrolledComposite.getVerticalBar().setVisible(false);
            Rectangle bounds = this.scrolledComposite.getClientArea();
            if (this.screenshotImage != null) {
                Rectangle imageBounds = this.screenshotImage.getBounds();
                if (imageBounds.width > bounds.width || imageBounds.height > bounds.height) {
                    double xRatio = (double)bounds.width / (double)imageBounds.width;
                    double yRatio = (double)bounds.height / (double)imageBounds.height;
                    this.scaleFactor = Math.min(xRatio, yRatio);
                    bounds.width = (int)Math.round((double)imageBounds.width * this.scaleFactor);
                    bounds.height = (int)Math.round((double)imageBounds.height * this.scaleFactor);
                }
            }
            this.canvas.setBounds(bounds);
        } else {
            this.scaleFactor = 1.0;
            Rectangle bounds = this.scrolledComposite.getClientArea();
            if (this.screenshotImage != null) {
                Rectangle imageBounds = this.screenshotImage.getBounds();
                bounds.width = imageBounds.width;
                bounds.height = imageBounds.height;
            }
            this.canvas.setBounds(bounds);
        }
        this.setUpGrabPoints();
        this.canvas.redraw();
    }

    private void drawSelectionPreview(GC gc) {
        gc.setLineDash(new int[]{4});
        gc.setXORMode(true);
        gc.setForeground(Display.getDefault().getSystemColor(1));
        gc.drawRectangle(this.getScaledSelection());
        gc.setForeground(Display.getDefault().getSystemColor(2));
        gc.drawRectangle(this.getScaledSelection());
        gc.setXORMode(false);
        gc.setLineStyle(1);
    }

    private void drawSelection(GC gc) {
        Rectangle scaledSelection = this.getScaledSelection();
        gc.setBackground(TaskListColorsAndFonts.GRAY);
        gc.setAdvanced(true);
        gc.setAlpha(120);
        Region invertedSelection = new Region();
        invertedSelection.add(this.canvas.getClientArea());
        invertedSelection.subtract(scaledSelection);
        gc.setClipping(invertedSelection);
        gc.fillRectangle(this.canvas.getClientArea());
        gc.setClipping(null);
        invertedSelection.dispose();
        gc.setAdvanced(false);
        gc.setLineStyle(1);
        gc.setForeground(Display.getCurrent().getSystemColor(16));
        gc.drawRectangle(scaledSelection);
        gc.setBackground(Display.getCurrent().getSystemColor(1));
        gc.setForeground(Display.getCurrent().getSystemColor(2));
        for (GrabPoint point : this.grabPoints) {
            gc.fillRectangle(point.grabArea);
            gc.drawRectangle(point.grabArea);
        }
    }

    private Image getCropScreenshot() {
        if (this.currentSelection == null) {
            return this.screenshotImage;
        }
        Image image = new Image((Device)Display.getDefault(), this.currentSelection);
        GC gc = new GC((Drawable)image);
        gc.drawImage(this.screenshotImage, this.currentSelection.x, this.currentSelection.y, this.currentSelection.width, this.currentSelection.height, 0, 0, this.currentSelection.width, this.currentSelection.height);
        gc.dispose();
        return image;
    }

    public Image getScreenshotImage() {
        return this.getCropScreenshot();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Action {
        IDLE,
        SELECTING,
        RESIZING_SELECTION,
        MOVING_SELECTION;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GrabPoint {
        public Rectangle grabArea;
        public int cursorType;
        public Set<SelectionSide> resizableSides;

        private GrabPoint() {
        }

        public static GrabPoint createGrabPoint(int x, int y, int cursorType, Set<SelectionSide> resizableSides) {
            GrabPoint point = new GrabPoint();
            point.grabArea = new Rectangle(x - 3, y - 3, 7, 7);
            point.cursorType = cursorType;
            point.resizableSides = resizableSides;
            return point;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SelectionSide {
        LEFT,
        RIGHT,
        TOP,
        BOTTOM;

    }
}

