/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.wizards;

import java.util.ArrayList;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskRepositoriesSorter;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskRepositoryLabelProvider;
import org.eclipse.mylyn.internal.tasks.ui.wizards.AbstractRepositoryClientWizard;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.ui.AbstractRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.ui.wizards.AbstractRepositorySettingsPage;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class SelectRepositoryClientPage
extends WizardPage {
    private static final String DESCRIPTION = "You can connect to an existing account using one of the installed connectors.";
    private static final String TITLE = "Select a task repository type";
    private TableViewer viewer;
    private AbstractRepositoryClientWizard wizard;

    public SelectRepositoryClientPage(AbstractRepositoryClientWizard wizard) {
        super(TITLE);
        this.setTitle(TITLE);
        this.setDescription(DESCRIPTION);
        this.wizard = wizard;
        super.setWizard((IWizard)wizard);
    }

    public boolean canFlipToNextPage() {
        return this.wizard.getRepositoryConnector() != null;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        FillLayout layout = new FillLayout();
        container.setLayout((Layout)layout);
        this.viewer = new TableViewer(container, 2820);
        this.viewer.setContentProvider((IContentProvider)new RepositoryContentProvider());
        this.viewer.setSorter((ViewerSorter)new TaskRepositoriesSorter());
        this.viewer.setLabelProvider((IBaseLabelProvider)new TaskRepositoryLabelProvider());
        this.viewer.setInput((Object)TasksUiPlugin.getRepositoryManager().getRepositoryConnectors());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection.getFirstElement() instanceof AbstractRepositoryConnector) {
                    SelectRepositoryClientPage.this.wizard.setRepositoryConnector((AbstractRepositoryConnector)selection.getFirstElement());
                    SelectRepositoryClientPage.this.setPageComplete(true);
                    SelectRepositoryClientPage.this.wizard.getContainer().updateButtons();
                }
            }
        });
        this.viewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                SelectRepositoryClientPage.this.getContainer().showPage(SelectRepositoryClientPage.this.getNextPage());
            }
        });
        this.setControl((Control)container);
    }

    public IWizardPage getNextPage() {
        if (this.isPageComplete()) {
            AbstractRepositoryConnectorUi connectorUi = TasksUiPlugin.getConnectorUi(this.wizard.getRepositoryConnector().getConnectorKind());
            AbstractRepositorySettingsPage nextPage = connectorUi.getSettingsPage();
            this.wizard.setRepositorySettingsPage(nextPage);
            nextPage.setWizard((IWizard)this.wizard);
            return nextPage;
        }
        return super.getNextPage();
    }

    static class RepositoryContentProvider
    implements IStructuredContentProvider {
        RepositoryContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            ArrayList<AbstractRepositoryConnector> userManagedRepositories = new ArrayList<AbstractRepositoryConnector>();
            for (AbstractRepositoryConnector connector : TasksUiPlugin.getRepositoryManager().getRepositoryConnectors()) {
                if (!connector.isUserManaged()) continue;
                userManagedRepositories.add(connector);
            }
            return userManagedRepositories.toArray();
        }
    }
}

