/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.wizards;

import java.io.File;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class TaskDataImportWizardPage
extends WizardPage {
    private static final String LABEL_IMPORT_ZIP = "From zip file";
    private static final String LABEL_IMPORT_BACKUP = "From auto backup";
    private static final String PAGE_TITLE = "Import Mylyn Task Data";
    private static final String DESCRIPTION = "WARNING: importing overwrites current task list and repositories, use with caution.";
    public static final String PAGE_NAME = "Import Mylyn Task Data";
    private Button taskListCheckBox = null;
    private Button taskActivationHistoryCheckBox = null;
    private Button taskContextsCheckBox = null;
    private Button browseButtonZip = null;
    private Text sourceZipText = null;
    private Button overwriteCheckBox = null;
    private Button importViaBackupButton;
    private Button importViaZipButton;
    private Table backupFilesTable;
    private static final String SETTINGS_SAVED = "Import Settings saved";
    private static final String TASKLIST_SETTING = "Import TaskList setting";
    private static final String ACTIVATION_HISTORY_SETTING = "Import Activation history setting";
    private static final String CONTEXTS_SETTING = "Import Contexts setting";
    private static final String SOURCE_ZIP_SETTING = "Import Source zip file setting";
    private static final String OVERWRITE_SETTING = "Import Overwrite setting";
    private static final String IMPORT_ZIPMETHOD_SETTING = "Import method zip";
    private static final String IMPORT_BACKUPMETHOD_SETTING = "Import method backup";

    public TaskDataImportWizardPage() {
        super("org.eclipse.mylyn.tasklist.importPage", "Import Mylyn Task Data", TasksUiPlugin.imageDescriptorFromPlugin((String)"org.eclipse.mylyn.tasks.ui", (String)"icons/wizban/banner-import.gif"));
        this.setPageComplete(false);
        this.setDescription(DESCRIPTION);
        this.setImageDescriptor(TasksUiImages.BANNER_IMPORT);
    }

    public String getName() {
        return "Import Mylyn Task Data";
    }

    public void createControl(Composite parent) {
        try {
            Composite container = new Composite(parent, 0);
            GridLayout layout = new GridLayout(3, false);
            layout.verticalSpacing = 15;
            container.setLayout((Layout)layout);
            this.createContentSelectionControl(container);
            this.createImportFromZipControl(container);
            this.createImportBackupControl(container);
            this.addRadioListeners();
            this.initSettings();
            this.setControl((Control)container);
            this.setPageComplete(this.validate());
        }
        catch (RuntimeException e) {
            StatusHandler.fail((Throwable)e, (String)"Could not create import wizard page", (boolean)true);
        }
    }

    private void addRadioListeners() {
        SelectionListener radioListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TaskDataImportWizardPage.this.browseButtonZip.setEnabled(TaskDataImportWizardPage.this.importViaZipButton.getSelection());
                TaskDataImportWizardPage.this.backupFilesTable.setEnabled(TaskDataImportWizardPage.this.importViaBackupButton.getSelection());
                TaskDataImportWizardPage.this.sourceZipText.setEnabled(TaskDataImportWizardPage.this.importViaZipButton.getSelection());
                TaskDataImportWizardPage.this.controlChanged();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        this.importViaZipButton.addSelectionListener(radioListener);
        this.importViaBackupButton.addSelectionListener(radioListener);
    }

    private void createContentSelectionControl(Composite parent) {
        Group group = new Group(parent, 16);
        GridLayout gl = new GridLayout(2, true);
        group.setLayout((Layout)gl);
        GridDataFactory.fillDefaults().grab(true, false).span(3, -1).applyTo((Control)group);
        group.setText("Select data to import:");
        this.taskListCheckBox = this.createCheckBox((Composite)group, "Task List");
        this.taskActivationHistoryCheckBox = this.createCheckBox((Composite)group, "Task Activation History");
        this.taskContextsCheckBox = this.createCheckBox((Composite)group, "Task Contexts");
        this.overwriteCheckBox = this.createCheckBox((Composite)group, "OVERWRITE existing files without warning");
    }

    private void createImportFromZipControl(Composite parent) {
        this.importViaZipButton = new Button(parent, 16);
        this.importViaZipButton.setText(LABEL_IMPORT_ZIP);
        this.sourceZipText = new Text(parent, 2048);
        this.sourceZipText.setEditable(true);
        GridDataFactory.fillDefaults().grab(true, false).hint(250, -1).applyTo((Control)this.sourceZipText);
        this.sourceZipText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TaskDataImportWizardPage.this.controlChanged();
            }
        });
        this.browseButtonZip = new Button(parent, 8);
        this.browseButtonZip.setText("Browse...");
        this.browseButtonZip.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(TaskDataImportWizardPage.this.getShell());
                dialog.setText("Zip File Selection");
                String dir = TaskDataImportWizardPage.this.sourceZipText.getText();
                dialog.setFilterPath(dir);
                dir = dialog.open();
                if (dir == null || dir.equals("")) {
                    return;
                }
                TaskDataImportWizardPage.this.sourceZipText.setText(dir);
            }
        });
    }

    private void createImportBackupControl(Composite container) {
        this.importViaBackupButton = new Button(container, 16);
        this.importViaBackupButton.setText(LABEL_IMPORT_BACKUP);
        this.addBackupFileView(container);
    }

    private void addBackupFileView(Composite composite) {
        File[] backupFileArray;
        File file;
        int n;
        int n2;
        File[] fileArray;
        this.backupFilesTable = new Table(composite, 2048);
        GridDataFactory.fillDefaults().span(2, -1).grab(true, true).applyTo((Control)this.backupFilesTable);
        TableColumn filenameColumn = new TableColumn(this.backupFilesTable, 16384);
        filenameColumn.setWidth(200);
        String destination = TasksUiPlugin.getDefault().getBackupFolderPath();
        File backupFolder = new File(destination);
        ArrayList<File> backupFiles = new ArrayList<File>();
        if (backupFolder.exists()) {
            File[] files;
            fileArray = files = backupFolder.listFiles();
            n2 = files.length;
            n = 0;
            while (n < n2) {
                file = fileArray[n];
                if (file.getName().startsWith("mylyndata")) {
                    backupFiles.add(file);
                }
                ++n;
            }
        }
        if ((backupFileArray = backupFiles.toArray(new File[backupFiles.size()])) != null && backupFileArray.length > 0) {
            Arrays.sort(backupFileArray, new Comparator<File>(){

                @Override
                public int compare(File file1, File file2) {
                    return new Long(file1.lastModified()).compareTo(new Long(file2.lastModified())) * -1;
                }
            });
            fileArray = backupFileArray;
            n2 = backupFileArray.length;
            n = 0;
            while (n < n2) {
                file = fileArray[n];
                TableItem item = new TableItem(this.backupFilesTable, 0);
                item.setData((Object)file.getAbsolutePath());
                item.setText(DateFormat.getDateTimeInstance().format(file.lastModified()));
                ++n;
            }
        }
        this.backupFilesTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TaskDataImportWizardPage.this.controlChanged();
            }
        });
    }

    protected void initSettings() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings.get(SETTINGS_SAVED) == null) {
            this.taskListCheckBox.setSelection(true);
            this.taskActivationHistoryCheckBox.setSelection(true);
            this.taskContextsCheckBox.setSelection(true);
            this.overwriteCheckBox.setSelection(true);
            this.importViaZipButton.setSelection(true);
            this.sourceZipText.setEnabled(true);
            this.backupFilesTable.setEnabled(false);
        } else {
            this.taskListCheckBox.setSelection(settings.getBoolean(TASKLIST_SETTING));
            this.taskActivationHistoryCheckBox.setSelection(settings.getBoolean(ACTIVATION_HISTORY_SETTING));
            this.taskContextsCheckBox.setSelection(settings.getBoolean(CONTEXTS_SETTING));
            this.importViaZipButton.setSelection(settings.getBoolean(IMPORT_ZIPMETHOD_SETTING));
            this.importViaBackupButton.setSelection(settings.getBoolean(IMPORT_BACKUPMETHOD_SETTING));
            this.browseButtonZip.setEnabled(this.importViaZipButton.getSelection());
            this.sourceZipText.setEnabled(this.importViaZipButton.getSelection());
            this.backupFilesTable.setEnabled(this.importViaBackupButton.getSelection());
            String zipFile = settings.get(SOURCE_ZIP_SETTING);
            if (zipFile != null) {
                this.sourceZipText.setText(settings.get(SOURCE_ZIP_SETTING));
            }
            this.overwriteCheckBox.setSelection(settings.getBoolean(OVERWRITE_SETTING));
        }
    }

    public void saveSettings() {
        IDialogSettings settings = this.getDialogSettings();
        settings.put(TASKLIST_SETTING, this.taskListCheckBox.getSelection());
        settings.put(ACTIVATION_HISTORY_SETTING, this.taskActivationHistoryCheckBox.getSelection());
        settings.put(CONTEXTS_SETTING, this.taskContextsCheckBox.getSelection());
        settings.put(SOURCE_ZIP_SETTING, this.sourceZipText.getText());
        settings.put(OVERWRITE_SETTING, this.overwriteCheckBox.getSelection());
        settings.put(IMPORT_ZIPMETHOD_SETTING, this.importViaZipButton.getSelection());
        settings.put(IMPORT_BACKUPMETHOD_SETTING, this.importViaBackupButton.getSelection());
        settings.put(SETTINGS_SAVED, SETTINGS_SAVED);
    }

    protected Button createCheckBox(Composite parent, String text) {
        Button newButton = new Button(parent, 32);
        newButton.setText(text);
        newButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TaskDataImportWizardPage.this.controlChanged();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return newButton;
    }

    public void controlChanged() {
        this.setPageComplete(this.validate());
    }

    protected boolean validate() {
        if (!(this.taskListCheckBox.getSelection() || this.taskActivationHistoryCheckBox.getSelection() || this.taskContextsCheckBox.getSelection())) {
            return false;
        }
        if (this.importViaZipButton.getSelection() && this.sourceZipText.getText().equals("")) {
            return false;
        }
        return !this.importViaBackupButton.getSelection() || this.backupFilesTable.getSelection().length != 0;
    }

    public String getSourceZipFile() {
        if (this.importViaZipButton.getSelection()) {
            return this.sourceZipText.getText();
        }
        if (this.backupFilesTable.getSelectionIndex() != -1) {
            return (String)this.backupFilesTable.getSelection()[0].getData();
        }
        return "<unspecified>";
    }

    public boolean importTaskList() {
        return this.taskListCheckBox.getSelection();
    }

    public boolean importActivationHistory() {
        return this.taskActivationHistoryCheckBox.getSelection();
    }

    public boolean importTaskContexts() {
        return this.taskContextsCheckBox.getSelection();
    }

    public boolean overwrite() {
        return this.overwriteCheckBox.getSelection();
    }

    public boolean zip() {
        return true;
    }

    public void setParameters(boolean overwrite, boolean importTaskList, boolean importActivationHistory, boolean importTaskContexts, boolean zip, String sourceDir, String sourceZip) {
        this.overwriteCheckBox.setSelection(overwrite);
        this.taskListCheckBox.setSelection(importTaskList);
        this.taskActivationHistoryCheckBox.setSelection(importActivationHistory);
        this.taskContextsCheckBox.setSelection(importTaskContexts);
        this.sourceZipText.setText(sourceZip);
        this.importViaZipButton.setSelection(zip);
    }
}

