/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.ui;

import java.util.Collections;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mylyn.internal.tasks.ui.OpenRepositoryTaskJob;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.internal.tasks.ui.wizards.CommonAddExistingTaskWizard;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryQuery;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.tasks.core.RepositoryTaskData;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.TaskRepositoryManager;
import org.eclipse.mylyn.tasks.core.TaskSelection;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.ui.wizards.AbstractRepositorySettingsPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRepositoryConnectorUi {
    private static final String LABEL_TASK_DEFAULT = "Task";
    private boolean customNotificationHandling = false;

    public abstract String getConnectorKind();

    public abstract AbstractRepositorySettingsPage getSettingsPage();

    public abstract IWizard getQueryWizard(TaskRepository var1, AbstractRepositoryQuery var2);

    public abstract IWizard getNewTaskWizard(TaskRepository var1);

    public IWizard getNewTaskWizard(TaskRepository taskRepository, TaskSelection selection) {
        return null;
    }

    public String getTaskEditorId(AbstractTask repositoryTask) {
        return "org.eclipse.mylyn.tasks.ui.editors.task";
    }

    public abstract boolean hasSearchPage();

    public List<AbstractTaskContainer> getLegendItems() {
        return Collections.emptyList();
    }

    public String getTaskKindLabel(AbstractTask repositoryTask) {
        return LABEL_TASK_DEFAULT;
    }

    public String getTaskKindLabel(RepositoryTaskData taskData) {
        return LABEL_TASK_DEFAULT;
    }

    public ImageDescriptor getTaskListElementIcon(AbstractTaskContainer element) {
        if (element instanceof AbstractRepositoryQuery) {
            return TasksUiImages.QUERY;
        }
        if (element instanceof AbstractTask) {
            return TasksUiImages.TASK;
        }
        return null;
    }

    public ImageDescriptor getTaskKindOverlay(AbstractTask task) {
        return null;
    }

    public ImageDescriptor getTaskPriorityOverlay(AbstractTask task) {
        return TasksUiImages.getImageDescriptorForPriority(AbstractTask.PriorityLevel.fromString((String)task.getPriority()));
    }

    public void openEditQueryDialog(AbstractRepositoryQuery query) {
        try {
            TaskRepository repository = TasksUiPlugin.getRepositoryManager().getRepository(query.getRepositoryKind(), query.getRepositoryUrl());
            if (repository == null) {
                return;
            }
            IWizard wizard = this.getQueryWizard(repository, query);
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            if (wizard != null && shell != null && !shell.isDisposed()) {
                WizardDialog dialog = new WizardDialog(shell, wizard);
                dialog.create();
                dialog.setTitle("Edit Repository Query");
                dialog.setBlockOnOpen(true);
                if (dialog.open() == 1) {
                    dialog.close();
                    return;
                }
            }
        }
        catch (Exception e) {
            StatusHandler.fail((Throwable)e, (String)e.getMessage(), (boolean)true);
        }
    }

    public IWizard getAddExistingTaskWizard(TaskRepository repository) {
        return new CommonAddExistingTaskWizard(repository);
    }

    public WizardPage getSearchPage(TaskRepository repository, IStructuredSelection selection) {
        return null;
    }

    public String getAccountCreationUrl(TaskRepository taskRepository) {
        return null;
    }

    public String getAccountManagementUrl(TaskRepository taskRepository) {
        return null;
    }

    public boolean openRepositoryTask(String repositoryUrl, String id) {
        IWorkbenchWindow[] windows;
        TaskRepositoryManager repositoryManager = TasksUiPlugin.getRepositoryManager();
        AbstractRepositoryConnector connector = repositoryManager.getRepositoryConnector(this.getConnectorKind());
        String taskUrl = connector.getTaskUrl(repositoryUrl, id);
        if (taskUrl == null) {
            return false;
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null && (windows = PlatformUI.getWorkbench().getWorkbenchWindows()) != null && windows.length > 0) {
            window = windows[0];
        }
        if (window == null) {
            return false;
        }
        IWorkbenchPage page = window.getActivePage();
        OpenRepositoryTaskJob job = new OpenRepositoryTaskJob(this.getConnectorKind(), repositoryUrl, id, taskUrl, page);
        job.schedule();
        return true;
    }

    public IHyperlink[] findHyperlinks(TaskRepository repository, String text, int lineOffset, int regionOffset) {
        return null;
    }

    public void setCustomNotificationHandling(boolean customNotifications) {
        this.customNotificationHandling = customNotifications;
    }

    public boolean isCustomNotificationHandling() {
        return this.customNotificationHandling;
    }

    public boolean supportsDueDates(AbstractTask task) {
        return false;
    }

    public String getKindLabel(String kindLabel) {
        return null;
    }

    public boolean forceSubtaskHierarchy() {
        return false;
    }
}

