/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.ui;

import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.mylyn.internal.tasks.core.TaskDataManager;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryQuery;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.RepositoryTaskAttribute;
import org.eclipse.mylyn.tasks.core.RepositoryTaskData;
import org.eclipse.mylyn.tasks.core.TaskList;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.SynchronizeQueryJob;
import org.eclipse.mylyn.tasks.ui.SynchronizeTaskJob;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RepositorySynchronizationManager {
    private final MutexRule taskRule = new MutexRule();
    private final MutexRule queryRule = new MutexRule();
    protected boolean forceSyncExecForTesting = false;

    public final Job synchronize(AbstractRepositoryConnector connector, AbstractTask repositoryTask, boolean forceSynch, IJobChangeListener listener) {
        HashSet<AbstractTask> toSync = new HashSet<AbstractTask>();
        toSync.add(repositoryTask);
        return this.synchronize(connector, toSync, forceSynch, listener);
    }

    public final Job synchronize(AbstractRepositoryConnector connector, Set<AbstractTask> repositoryTasks, boolean forceSynch, final IJobChangeListener listener) {
        final SynchronizeTaskJob synchronizeJob = new SynchronizeTaskJob(connector, repositoryTasks);
        synchronizeJob.setForced(forceSynch);
        synchronizeJob.setPriority(50);
        synchronizeJob.setRule(this.taskRule);
        if (listener != null) {
            synchronizeJob.addJobChangeListener(listener);
        }
        for (AbstractTask repositoryTask : repositoryTasks) {
            repositoryTask.setSynchronizing(true);
        }
        if (!this.forceSyncExecForTesting) {
            synchronizeJob.schedule();
        } else {
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                public void run() {
                    synchronizeJob.run((IProgressMonitor)new NullProgressMonitor());
                    if (listener != null) {
                        listener.done(null);
                    }
                }
            });
        }
        return synchronizeJob;
    }

    public final Job synchronize(AbstractRepositoryConnector connector, AbstractRepositoryQuery repositoryQuery, IJobChangeListener listener, boolean forceSync) {
        TaskRepository repository = TasksUiPlugin.getRepositoryManager().getRepository(repositoryQuery.getRepositoryKind(), repositoryQuery.getRepositoryUrl());
        return this.synchronize(connector, repository, Collections.singleton(repositoryQuery), listener, 30, 0L, forceSync);
    }

    public final Job synchronize(AbstractRepositoryConnector connector, TaskRepository repository, Set<AbstractRepositoryQuery> repositoryQueries, IJobChangeListener listener, int priority, long delay, boolean userForcedSync) {
        return this.synchronize(connector, repository, repositoryQueries, listener, priority, delay, userForcedSync, true);
    }

    public final Job synchronize(AbstractRepositoryConnector connector, TaskRepository repository, Set<AbstractRepositoryQuery> repositoryQueries, final IJobChangeListener listener, int priority, long delay, boolean userForcedSync, boolean fullSynchronization) {
        TaskList taskList = TasksUiPlugin.getTaskListManager().getTaskList();
        for (AbstractRepositoryQuery repositoryQuery : repositoryQueries) {
            repositoryQuery.setSynchronizing(true);
        }
        taskList.notifyContainersUpdated(repositoryQueries);
        final SynchronizeQueryJob job = new SynchronizeQueryJob(connector, repository, repositoryQueries, taskList);
        job.setSynchronizeChangedTasks(true);
        job.setFullSynchronization(fullSynchronization);
        job.setForced(userForcedSync);
        if (listener != null) {
            job.addJobChangeListener(listener);
        }
        job.setRule(this.queryRule);
        job.setPriority(priority);
        if (!this.forceSyncExecForTesting) {
            job.schedule(delay);
        } else {
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                public void run() {
                    job.run((IProgressMonitor)new NullProgressMonitor());
                    if (listener != null) {
                        listener.done(null);
                    }
                }
            });
        }
        return job;
    }

    public final void synchronizeChanged(AbstractRepositoryConnector connector, TaskRepository repository) {
        Set<AbstractRepositoryQuery> emptySet = Collections.emptySet();
        this.synchronize(connector, repository, emptySet, null, 30, 0L, false);
    }

    public synchronized void saveOutgoing(AbstractTask repositoryTask, Set<RepositoryTaskAttribute> modifiedAttributes) {
        repositoryTask.setSynchronizationState(AbstractTask.RepositoryTaskSyncState.OUTGOING);
        TasksUiPlugin.getTaskDataManager().saveEdits(repositoryTask.getRepositoryUrl(), repositoryTask.getTaskId(), Collections.unmodifiableSet(modifiedAttributes));
        TasksUiPlugin.getTaskListManager().getTaskList().notifyTaskChanged(repositoryTask, false);
    }

    public synchronized boolean saveIncoming(AbstractTask repositoryTask, RepositoryTaskData newTaskData, boolean forceSync) {
        AbstractTask.RepositoryTaskSyncState startState = repositoryTask.getSynchronizationState();
        AbstractTask.RepositoryTaskSyncState status = repositoryTask.getSynchronizationState();
        if (newTaskData == null) {
            StatusHandler.log((String)("Download of " + repositoryTask.getSummary() + " from " + repositoryTask.getRepositoryUrl() + " failed."), (Object)this);
            return false;
        }
        RepositoryTaskData previousTaskData = TasksUiPlugin.getTaskDataManager().getNewTaskData(repositoryTask.getRepositoryUrl(), repositoryTask.getTaskId());
        if (repositoryTask.isSubmitting()) {
            status = AbstractTask.RepositoryTaskSyncState.SYNCHRONIZED;
            repositoryTask.setSubmitting(false);
            TaskDataManager dataManager = TasksUiPlugin.getTaskDataManager();
            dataManager.discardEdits(repositoryTask.getRepositoryUrl(), repositoryTask.getTaskId());
            TasksUiPlugin.getTaskDataManager().setNewTaskData(newTaskData);
        } else {
            switch (status) {
                case OUTGOING: {
                    if (this.checkHasIncoming(repositoryTask, newTaskData)) {
                        status = AbstractTask.RepositoryTaskSyncState.CONFLICT;
                    }
                    TasksUiPlugin.getTaskDataManager().setNewTaskData(newTaskData);
                    break;
                }
                case INCOMING: 
                case CONFLICT: {
                    TasksUiPlugin.getTaskDataManager().setNewTaskData(newTaskData);
                    break;
                }
                case SYNCHRONIZED: {
                    boolean hasIncoming = this.checkHasIncoming(repositoryTask, newTaskData);
                    if (hasIncoming) {
                        status = AbstractTask.RepositoryTaskSyncState.INCOMING;
                        repositoryTask.setNotified(false);
                    }
                    if (!hasIncoming && previousTaskData != null && !forceSync) break;
                    TasksUiPlugin.getTaskDataManager().setNewTaskData(newTaskData);
                }
            }
        }
        repositoryTask.setSynchronizationState(status);
        return startState != repositoryTask.getSynchronizationState();
    }

    public void saveOffline(AbstractTask task, RepositoryTaskData taskData) {
        TasksUiPlugin.getTaskDataManager().setNewTaskData(taskData);
    }

    public boolean checkHasIncoming(AbstractTask repositoryTask, RepositoryTaskData newData) {
        if (repositoryTask.getSynchronizationState() == AbstractTask.RepositoryTaskSyncState.INCOMING) {
            return true;
        }
        String lastModified = repositoryTask.getLastReadTimeStamp();
        RepositoryTaskAttribute modifiedDateAttribute = newData.getAttribute("task.common.date.modified");
        if (lastModified != null && modifiedDateAttribute != null && modifiedDateAttribute.getValue() != null) {
            if (lastModified.trim().compareTo(modifiedDateAttribute.getValue().trim()) == 0) {
                return false;
            }
            Date modifiedDate = newData.getAttributeFactory().getDateForAttributeType("task.common.date.modified", modifiedDateAttribute.getValue());
            Date lastModifiedDate = newData.getAttributeFactory().getDateForAttributeType("task.common.date.modified", lastModified);
            if (modifiedDate != null && lastModifiedDate != null && modifiedDate.equals(lastModifiedDate)) {
                return false;
            }
        }
        return true;
    }

    public void setTaskRead(AbstractTask repositoryTask, boolean read) {
        TaskDataManager dataManager = TasksUiPlugin.getTaskDataManager();
        RepositoryTaskData taskData = TasksUiPlugin.getTaskDataManager().getNewTaskData(repositoryTask.getRepositoryUrl(), repositoryTask.getTaskId());
        if (read && repositoryTask.getSynchronizationState().equals((Object)AbstractTask.RepositoryTaskSyncState.INCOMING)) {
            if (taskData != null && taskData.getLastModified() != null) {
                repositoryTask.setLastReadTimeStamp(taskData.getLastModified());
                dataManager.setOldTaskData(taskData);
            }
            repositoryTask.setSynchronizationState(AbstractTask.RepositoryTaskSyncState.SYNCHRONIZED);
            TasksUiPlugin.getTaskListManager().getTaskList().notifyTaskChanged(repositoryTask, false);
        } else if (read && repositoryTask.getSynchronizationState().equals((Object)AbstractTask.RepositoryTaskSyncState.CONFLICT)) {
            if (taskData != null && taskData.getLastModified() != null) {
                repositoryTask.setLastReadTimeStamp(taskData.getLastModified());
            }
            repositoryTask.setSynchronizationState(AbstractTask.RepositoryTaskSyncState.OUTGOING);
            TasksUiPlugin.getTaskListManager().getTaskList().notifyTaskChanged(repositoryTask, false);
        } else if (read && repositoryTask.getSynchronizationState().equals((Object)AbstractTask.RepositoryTaskSyncState.SYNCHRONIZED)) {
            if (taskData != null && taskData.getLastModified() != null) {
                repositoryTask.setLastReadTimeStamp(taskData.getLastModified());
                dataManager.setOldTaskData(taskData);
            }
        } else if (!read && repositoryTask.getSynchronizationState().equals((Object)AbstractTask.RepositoryTaskSyncState.SYNCHRONIZED)) {
            repositoryTask.setSynchronizationState(AbstractTask.RepositoryTaskSyncState.INCOMING);
            TasksUiPlugin.getTaskListManager().getTaskList().notifyTaskChanged(repositoryTask, false);
        }
        if (read && taskData == null && repositoryTask.isLocal()) {
            repositoryTask.setLastReadTimeStamp(new Date().toString());
        }
    }

    public void discardOutgoing(AbstractTask repositoryTask) {
        TaskDataManager dataManager = TasksUiPlugin.getTaskDataManager();
        dataManager.discardEdits(repositoryTask.getRepositoryUrl(), repositoryTask.getTaskId());
        repositoryTask.setSynchronizationState(AbstractTask.RepositoryTaskSyncState.SYNCHRONIZED);
        TasksUiPlugin.getTaskListManager().getTaskList().notifyTaskChanged(repositoryTask, true);
    }

    public final void setForceSyncExec(boolean forceSyncExec) {
        this.forceSyncExecForTesting = forceSyncExec;
    }

    public final boolean isForcedSyncExec() {
        return this.forceSyncExecForTesting;
    }

    private static class MutexRule
    implements ISchedulingRule {
        private MutexRule() {
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }
    }
}

