/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.ui.editors;

import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityUtil;
import org.eclipse.mylyn.internal.tasks.core.TaskCategory;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.internal.tasks.ui.editors.RepositoryTaskOutlineNode;
import org.eclipse.mylyn.internal.tasks.ui.editors.RepositoryTaskSelection;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.AbstractTaskCategory;
import org.eclipse.mylyn.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.tasks.core.TaskList;
import org.eclipse.mylyn.tasks.ui.DatePicker;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.ui.editors.AbstractRepositoryTaskEditor;
import org.eclipse.mylyn.tasks.ui.editors.NewTaskEditorInput;
import org.eclipse.mylyn.tasks.ui.editors.RepositoryTaskEditorInput;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.Section;

public abstract class AbstractNewRepositoryTaskEditor
extends AbstractRepositoryTaskEditor {
    private static final int DESCRIPTION_WIDTH = 553;
    private static final int DESCRIPTION_HEIGHT = 140;
    private static final int DEFAULT_FIELD_WIDTH = 150;
    private static final int DEFAULT_ESTIMATED_TIME = 1;
    private static final String LABEL_SUMBIT = "Submit";
    private static final String ERROR_CREATING_BUG_REPORT = "Error creating bug report";
    protected DatePicker scheduledForDate;
    protected Spinner estimatedTime;
    @Deprecated
    protected String newSummary = "";
    protected Button addToCategory;
    protected CCombo categoryChooser;

    public AbstractNewRepositoryTaskEditor(FormEditor editor) {
        super(editor);
    }

    public void init(IEditorSite site, IEditorInput input) {
        if (!(input instanceof NewTaskEditorInput)) {
            return;
        }
        this.initTaskEditor(site, (RepositoryTaskEditorInput)input);
        this.setTaskOutlineModel(RepositoryTaskOutlineNode.parseBugReport(this.taskData, false));
        this.newSummary = this.taskData.getSummary();
    }

    protected void createDescriptionLayout(Composite composite) {
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        Section section = toolkit.createSection(composite, 256);
        section.setText(this.getSectionLabel(AbstractRepositoryTaskEditor.SECTION_NAME.DESCRIPTION_SECTION));
        section.setExpanded(true);
        section.setLayout((Layout)new GridLayout());
        section.setLayoutData((Object)new GridData(1808));
        Composite descriptionComposite = toolkit.createComposite((Composite)section);
        GridLayout descriptionLayout = new GridLayout();
        descriptionComposite.setLayout((Layout)descriptionLayout);
        GridData descriptionData = new GridData(1808);
        descriptionData.grabExcessVerticalSpace = true;
        descriptionComposite.setLayoutData((Object)descriptionData);
        section.setClient((Control)descriptionComposite);
        this.descriptionTextViewer = this.addTextEditor(this.repository, descriptionComposite, this.taskData.getDescription(), true, 8389186);
        this.descriptionTextViewer.setEditable(true);
        GridData gd = new GridData(1808);
        gd.widthHint = 553;
        gd.minimumHeight = 140;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.descriptionTextViewer.getControl().setLayoutData((Object)gd);
        this.descriptionTextViewer.getControl().setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        this.addDuplicateDetection(descriptionComposite);
        toolkit.paintBordersFor(descriptionComposite);
    }

    protected void createSummaryLayout(Composite composite) {
        this.addSummaryText(composite);
        if (this.summaryTextViewer != null) {
            this.summaryTextViewer.prependVerifyKeyListener((VerifyKeyListener)new TabVerifyKeyListener());
            this.summaryTextViewer.getTextWidget().addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String sel = AbstractNewRepositoryTaskEditor.this.summaryText.getText();
                    if (!AbstractNewRepositoryTaskEditor.this.newSummary.equals(sel)) {
                        AbstractNewRepositoryTaskEditor.this.newSummary = sel;
                    }
                }
            });
        }
    }

    protected void createAttachmentLayout(Composite comp) {
    }

    protected void createCommentLayout(Composite comp) {
    }

    protected void createNewCommentLayout(Composite comp) {
        this.createPlanningLayout(comp);
    }

    protected void createPlanningLayout(Composite comp) {
        Section section = this.createSection(comp, "Personal Planning");
        section.setLayout((Layout)new GridLayout());
        section.setLayoutData((Object)new GridData(768));
        section.setExpanded(true);
        Composite sectionClient = this.getManagedForm().getToolkit().createComposite((Composite)section);
        section.setClient((Control)sectionClient);
        GridLayout layout = new GridLayout();
        layout.numColumns = 7;
        layout.makeColumnsEqualWidth = false;
        sectionClient.setLayout((Layout)layout);
        GridData clientDataLayout = new GridData(32);
        sectionClient.setLayoutData((Object)clientDataLayout);
        this.getManagedForm().getToolkit().createLabel(sectionClient, "Scheduled for:");
        this.scheduledForDate = new DatePicker(sectionClient, 0x800000, "<choose date>");
        this.scheduledForDate.setBackground(Display.getDefault().getSystemColor(1));
        this.scheduledForDate.setData("FormWidgetFactory.drawBorder", "textBorder");
        Calendar newTaskSchedule = Calendar.getInstance();
        int scheduledEndHour = TasksUiPlugin.getDefault().getPreferenceStore().getInt("org.eclipse.mylyn.tasks.ui.planning.end.hour");
        if (newTaskSchedule.get(11) >= scheduledEndHour) {
            TaskActivityUtil.snapForwardNumDays((Calendar)newTaskSchedule, (int)1);
        } else {
            TaskActivityUtil.snapEndOfWorkDay((Calendar)newTaskSchedule);
        }
        this.scheduledForDate.setDate(newTaskSchedule);
        ImageHyperlink clearReminder = this.getManagedForm().getToolkit().createImageHyperlink(sectionClient, 0);
        clearReminder.setImage(TasksUiImages.getImage(TasksUiImages.REMOVE));
        clearReminder.setToolTipText("Clear");
        clearReminder.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                AbstractNewRepositoryTaskEditor.this.scheduledForDate.setDate(null);
            }
        });
        Label dummy = this.getManagedForm().getToolkit().createLabel(sectionClient, "");
        GridData dummyLabelDataLayout = new GridData(64);
        dummyLabelDataLayout.horizontalSpan = 1;
        dummyLabelDataLayout.widthHint = 30;
        dummy.setLayoutData((Object)dummyLabelDataLayout);
        this.getManagedForm().getToolkit().createLabel(sectionClient, "Estimated hours:");
        this.estimatedTime = new Spinner(sectionClient, 0x800000);
        this.estimatedTime.setDigits(0);
        this.estimatedTime.setMaximum(100);
        this.estimatedTime.setMinimum(0);
        this.estimatedTime.setIncrement(1);
        this.estimatedTime.setSelection(1);
        this.estimatedTime.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        GridData estimatedDataLayout = new GridData();
        estimatedDataLayout.widthHint = 30;
        this.estimatedTime.setLayoutData((Object)estimatedDataLayout);
        ImageHyperlink clearEstimated = this.getManagedForm().getToolkit().createImageHyperlink(sectionClient, 0);
        clearEstimated.setImage(TasksUiImages.getImage(TasksUiImages.REMOVE));
        clearEstimated.setToolTipText("Clear");
        clearEstimated.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                AbstractNewRepositoryTaskEditor.this.estimatedTime.setSelection(0);
            }
        });
        this.getManagedForm().getToolkit().paintBordersFor(sectionClient);
    }

    protected void addRadioButtons(Composite buttonComposite) {
    }

    protected void createCustomAttributeLayout(Composite composite) {
    }

    protected void saveTaskOffline(IProgressMonitor progressMonitor) {
        this.taskData.setSummary(this.newSummary);
        this.taskData.setDescription(this.descriptionTextViewer.getTextWidget().getText());
        this.updateEditorTitle();
    }

    protected void validateInput() {
    }

    public boolean isDirty() {
        return true;
    }

    public void setFocus() {
        if (this.summaryText != null) {
            this.summaryText.setFocus();
        }
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    protected void createActionsLayout(Composite formComposite) {
        Section section = this.getManagedForm().getToolkit().createSection(formComposite, 256);
        section.setText(this.getSectionLabel(AbstractRepositoryTaskEditor.SECTION_NAME.ACTIONS_SECTION));
        section.setExpanded(true);
        section.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().align(4, 128).grab(true, true).applyTo((Control)section);
        Composite buttonComposite = this.getManagedForm().getToolkit().createComposite((Composite)section);
        buttonComposite.setLayout((Layout)new GridLayout(4, false));
        buttonComposite.setLayoutData((Object)new GridData(256));
        section.setClient((Control)buttonComposite);
        this.addToCategory = this.getManagedForm().getToolkit().createButton(buttonComposite, "Add to Category", 32);
        this.categoryChooser = new CCombo(buttonComposite, 0x800008);
        this.categoryChooser.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        this.categoryChooser.setLayoutData((Object)GridDataFactory.swtDefaults().hint(150, -1).create());
        this.getManagedForm().getToolkit().adapt((Control)this.categoryChooser, true, true);
        this.categoryChooser.setFont(TEXT_FONT);
        TaskList taskList = TasksUiPlugin.getTaskListManager().getTaskList();
        List categories = taskList.getUserCategories();
        Collections.sort(categories, new Comparator<AbstractTaskContainer>(){

            @Override
            public int compare(AbstractTaskContainer c1, AbstractTaskContainer c2) {
                if (c1.equals((Object)TasksUiPlugin.getTaskListManager().getTaskList().getDefaultCategory())) {
                    return -1;
                }
                if (c2.equals((Object)TasksUiPlugin.getTaskListManager().getTaskList().getDefaultCategory())) {
                    return 1;
                }
                return c1.getSummary().compareToIgnoreCase(c2.getSummary());
            }
        });
        for (AbstractTaskContainer category : categories) {
            this.categoryChooser.add(category.getSummary());
        }
        this.categoryChooser.select(0);
        this.categoryChooser.setEnabled(false);
        this.categoryChooser.setData((Object)categories);
        this.addToCategory.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractNewRepositoryTaskEditor.this.categoryChooser.setEnabled(AbstractNewRepositoryTaskEditor.this.addToCategory.getSelection());
            }
        });
        GridDataFactory.fillDefaults().hint(150, -1).span(3, -1).applyTo((Control)this.categoryChooser);
        this.addActionButtons(buttonComposite);
        this.getManagedForm().getToolkit().paintBordersFor(buttonComposite);
    }

    protected AbstractTaskCategory getCategory() {
        int index = this.categoryChooser.getSelectionIndex();
        if (this.addToCategory.getSelection() && index != -1) {
            return (AbstractTaskCategory)((List)this.categoryChooser.getData()).get(index);
        }
        return null;
    }

    protected void addActionButtons(Composite buttonComposite) {
        FormToolkit toolkit = new FormToolkit(buttonComposite.getDisplay());
        this.submitButton = toolkit.createButton(buttonComposite, LABEL_SUMBIT, 0);
        GridData submitButtonData = new GridData(32);
        submitButtonData.widthHint = 100;
        this.submitButton.setImage(TasksUiImages.getImage(TasksUiImages.REPOSITORY_SUBMIT));
        this.submitButton.setLayoutData((Object)submitButtonData);
        this.submitButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                AbstractNewRepositoryTaskEditor.this.submitToRepository();
            }
        });
        this.submitButton.setToolTipText("Submit to " + this.repository.getUrl());
    }

    protected boolean prepareSubmit() {
        this.submitButton.setEnabled(false);
        this.showBusy(true);
        if (this.summaryText != null && this.summaryText.getText().trim().equals("")) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    MessageDialog.openInformation((Shell)AbstractNewRepositoryTaskEditor.this.getSite().getShell(), (String)AbstractNewRepositoryTaskEditor.ERROR_CREATING_BUG_REPORT, (String)"A summary must be provided with new bug reports.");
                    AbstractNewRepositoryTaskEditor.this.summaryText.setFocus();
                    AbstractNewRepositoryTaskEditor.this.submitButton.setEnabled(true);
                    AbstractNewRepositoryTaskEditor.this.showBusy(false);
                }
            });
            return false;
        }
        if (this.descriptionTextViewer != null && this.descriptionTextViewer.getTextWidget().getText().trim().equals("")) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    MessageDialog.openInformation((Shell)AbstractNewRepositoryTaskEditor.this.getSite().getShell(), (String)AbstractNewRepositoryTaskEditor.ERROR_CREATING_BUG_REPORT, (String)"A summary must be provided with new reports.");
                    AbstractNewRepositoryTaskEditor.this.descriptionTextViewer.getTextWidget().setFocus();
                    AbstractNewRepositoryTaskEditor.this.submitButton.setEnabled(true);
                    AbstractNewRepositoryTaskEditor.this.showBusy(false);
                }
            });
            return false;
        }
        return true;
    }

    protected void createPeopleLayout(Composite composite) {
    }

    public AbstractTask updateSubmittedTask(String id, IProgressMonitor monitor) throws CoreException {
        final AbstractTask newTask = super.updateSubmittedTask(id, monitor);
        if (newTask != null) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    Calendar selectedDate = AbstractNewRepositoryTaskEditor.this.scheduledForDate.getDate();
                    if (selectedDate != null) {
                        TasksUiPlugin.getTaskActivityManager().setScheduledFor(newTask, selectedDate.getTime());
                    }
                    newTask.setEstimatedTimeHours(AbstractNewRepositoryTaskEditor.this.estimatedTime.getSelection());
                    Object selectedObject = null;
                    if (TaskListView.getFromActivePerspective() != null) {
                        selectedObject = ((IStructuredSelection)TaskListView.getFromActivePerspective().getViewer().getSelection()).getFirstElement();
                    }
                    if (selectedObject instanceof TaskCategory) {
                        TasksUiPlugin.getTaskListManager().getTaskList().moveTask(newTask, (AbstractTaskContainer)((TaskCategory)selectedObject));
                    }
                }
            });
        }
        return newTask;
    }

    public void doSave(IProgressMonitor monitor) {
        new MessageDialog(null, "Operation not supported", null, "Save of un-submitted new tasks is not currently supported.\nPlease submit all new tasks.", 2, new String[]{IDialogConstants.OK_LABEL}, 0).open();
        monitor.setCanceled(true);
    }

    public static String getStackTraceFromDescription(String description) {
        String stackTrace = null;
        if (description == null) {
            return null;
        }
        String punct = "!\"#$%&'\\(\\)*+,-./:;\\<=\\>?@\\[\\]^_`\\{|\\}~\n";
        String lineRegex = " *at\\s+[\\w" + punct + "]+ ?\\(.*\\) *\n?";
        Pattern tracePattern = Pattern.compile(lineRegex);
        Matcher match = tracePattern.matcher(description);
        if (match.find()) {
            int start = match.start();
            int lastEnd = match.end();
            while (match.find()) {
                lastEnd = match.end();
            }
            if (start <= 0) {
                return null;
            }
            int stackStart = 0;
            int index = start - 1;
            while (index > 1 && description.charAt(index) == ' ') {
                --index;
            }
            stackStart = description.substring(0, index - 1).lastIndexOf("\n");
            stackStart = stackStart == -1 ? 0 : stackStart + 1;
            stackTrace = description.substring(stackStart, lastEnd);
        }
        return stackTrace;
    }

    public boolean searchForDuplicates() {
        this.saveTaskOffline((IProgressMonitor)new NullProgressMonitor());
        return super.searchForDuplicates();
    }

    protected boolean supportsRefreshAttributes() {
        return false;
    }

    protected class DescriptionListener
    implements Listener {
        protected DescriptionListener() {
        }

        public void handleEvent(Event event) {
            AbstractNewRepositoryTaskEditor.this.fireSelectionChanged(new SelectionChangedEvent(AbstractNewRepositoryTaskEditor.this.selectionProvider, (ISelection)new StructuredSelection((Object)new RepositoryTaskSelection(AbstractNewRepositoryTaskEditor.this.taskData.getId(), AbstractNewRepositoryTaskEditor.this.taskData.getRepositoryUrl(), AbstractNewRepositoryTaskEditor.this.taskData.getRepositoryKind(), "New Description", false, AbstractNewRepositoryTaskEditor.this.taskData.getSummary()))));
        }
    }

    protected class TabVerifyKeyListener
    implements VerifyKeyListener {
        protected TabVerifyKeyListener() {
        }

        public void verifyKey(VerifyEvent event) {
            if (event.keyCode == 9) {
                event.doit = false;
                AbstractNewRepositoryTaskEditor.this.focusAttributes();
            }
        }
    }
}

