/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.ui.editors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.internal.tasks.core.LocalTask;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.internal.tasks.ui.editors.EditorBusyIndicator;
import org.eclipse.mylyn.internal.tasks.ui.editors.IBusyEditor;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorActionContributor;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskPlanningEditor;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.RepositoryTaskData;
import org.eclipse.mylyn.tasks.ui.AbstractRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.mylyn.tasks.ui.editors.AbstractNewRepositoryTaskEditor;
import org.eclipse.mylyn.tasks.ui.editors.AbstractRepositoryTaskEditor;
import org.eclipse.mylyn.tasks.ui.editors.AbstractRepositoryTaskEditorInput;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorFactory;
import org.eclipse.mylyn.tasks.ui.editors.NewTaskEditorInput;
import org.eclipse.mylyn.tasks.ui.editors.RepositoryTaskEditorInput;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditorInput;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.editor.SharedHeaderFormEditor;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskEditor
extends SharedHeaderFormEditor
implements IBusyEditor {
    public static final String ID_EDITOR = "org.eclipse.mylyn.tasks.ui.editors.task";
    protected AbstractTask task;
    private TaskPlanningEditor taskPlanningEditor;
    private TaskEditorInput taskEditorInput;
    private List<IEditorPart> editors = new ArrayList<IEditorPart>();
    private Menu contextMenu;
    private IEditorPart contentOutlineProvider = null;
    public final Object FAMILY_SUBMIT = new Object();
    private EditorBusyIndicator editorBusyIndicator;

    public TaskEditor() {
        this.taskPlanningEditor = new TaskPlanningEditor((FormEditor)this);
        this.taskPlanningEditor.setParentEditor(this);
    }

    protected void contextMenuAboutToShow(IMenuManager manager) {
        TaskEditorActionContributor contributor = this.getContributor();
        if (contributor != null) {
            contributor.contextMenuAboutToShow(manager);
        }
    }

    public TaskEditorActionContributor getContributor() {
        return (TaskEditorActionContributor)this.getEditorSite().getActionBarContributor();
    }

    public Object getAdapter(Class adapter) {
        return this.getAdapterDelgate(adapter);
    }

    public Object getAdapterDelgate(Class<?> adapter) {
        if (this.contentOutlineProvider != null) {
            return this.contentOutlineProvider.getAdapter(adapter);
        }
        return super.getAdapter(adapter);
    }

    public IEditorPart getActiveEditor() {
        return super.getActiveEditor();
    }

    public void doSave(IProgressMonitor monitor) {
        IFormPage[] iFormPageArray = this.getPages();
        int n = iFormPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFormPage page = iFormPageArray[n2];
            if (page.isDirty()) {
                page.doSave(monitor);
            }
            ++n2;
        }
        this.editorDirtyStateChanged();
    }

    IFormPage[] getPages() {
        ArrayList formPages = new ArrayList();
        if (this.pages != null) {
            int i = 0;
            while (i < this.pages.size()) {
                Object page = this.pages.get(i);
                if (page instanceof IFormPage) {
                    formPages.add(page);
                }
                ++i;
            }
        }
        return formPages.toArray(new IFormPage[formPages.size()]);
    }

    public void refreshEditorContents() {
        IFormPage[] iFormPageArray = this.getPages();
        int n = iFormPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFormPage page = iFormPageArray[n2];
            if (page instanceof AbstractRepositoryTaskEditor) {
                AbstractRepositoryTaskEditor editor = (AbstractRepositoryTaskEditor)page;
                editor.refreshEditor();
            }
            ++n2;
        }
    }

    public void doSaveAs() {
        IEditorPart editor = this.getEditor(0);
        if (editor != null) {
            editor.doSaveAs();
            this.setPageText(0, editor.getTitle());
            this.setInput(editor.getEditorInput());
        }
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.setSite((IWorkbenchPartSite)site);
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isDirty() {
        IFormPage[] iFormPageArray = this.getPages();
        int n = iFormPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFormPage page = iFormPageArray[n2];
            if (page.isDirty()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void changeTitle() {
        this.setPartName(this.taskEditorInput.getLabel());
    }

    public void markDirty() {
        this.firePropertyChange(257);
    }

    public void setFocusOfActivePage() {
        IFormPage page;
        if (this.getActivePage() > -1 && (page = this.getPages()[this.getActivePage()]) != null) {
            page.setFocus();
        }
    }

    protected void pageChange(int newPageIndex) {
        super.pageChange(newPageIndex);
    }

    public void dispose() {
        if (this.editorBusyIndicator != null) {
            this.editorBusyIndicator.stop();
        }
        for (IEditorPart part : this.editors) {
            part.dispose();
        }
        if (this.taskPlanningEditor != null) {
            this.taskPlanningEditor.dispose();
        }
        super.dispose();
    }

    public TaskEditorInput getTaskEditorInput() {
        return this.taskEditorInput;
    }

    protected void addPages() {
        this.editorBusyIndicator = new EditorBusyIndicator(this);
        try {
            MenuManager manager = new MenuManager();
            IMenuListener listener = new IMenuListener(){

                public void menuAboutToShow(IMenuManager manager) {
                    TaskEditor.this.contextMenuAboutToShow(manager);
                }
            };
            manager.setRemoveAllWhenShown(true);
            manager.addMenuListener(listener);
            this.contextMenu = manager.createContextMenu((Control)this.getContainer());
            this.getContainer().setMenu(this.contextMenu);
            int index = -1;
            if (this.getEditorInput() instanceof TaskEditorInput) {
                this.addPage((IFormPage)this.taskPlanningEditor);
                ++index;
                this.taskEditorInput = (TaskEditorInput)this.getEditorInput();
                this.task = this.taskEditorInput.getTask();
                this.setPartName(this.taskEditorInput.getLabel());
                this.setPageImage(0, TasksUiImages.getImage(TasksUiImages.CALENDAR_SMALL));
            }
            int selectedIndex = index;
            ArrayList<AbstractTaskEditorFactory> factories = new ArrayList<AbstractTaskEditorFactory>(TasksUiPlugin.getDefault().getTaskEditorFactories());
            Collections.sort(factories, new Comparator<AbstractTaskEditorFactory>(){

                @Override
                public int compare(AbstractTaskEditorFactory o1, AbstractTaskEditorFactory o2) {
                    return o1.getTabOrderPriority() - o2.getTabOrderPriority();
                }
            });
            for (AbstractTaskEditorFactory factory : TasksUiPlugin.getDefault().getTaskEditorFactories()) {
                if (!factory.canCreateEditorFor(this.task) && !factory.canCreateEditorFor(this.getEditorInput())) continue;
                try {
                    IEditorInput input;
                    IEditorPart editor = factory.createEditor(this, this.getEditorInput());
                    IEditorInput iEditorInput = input = this.task != null ? factory.createEditorInput(this.task) : this.getEditorInput();
                    if (editor != null && input != null) {
                        FormPage taskEditor = (FormPage)editor;
                        editor.init(this.getEditorSite(), input);
                        index = this.addPage((IFormPage)taskEditor);
                        if (input.getImageDescriptor() != null) {
                            this.setPageImage(index, TasksUiImages.getImage(input.getImageDescriptor()));
                        }
                        if (editor instanceof AbstractRepositoryTaskEditor) {
                            ((AbstractRepositoryTaskEditor)editor).setParentEditor(this);
                            if (this.getEditorInput() instanceof RepositoryTaskEditorInput) {
                                RepositoryTaskEditorInput existingInput = (RepositoryTaskEditorInput)this.getEditorInput();
                                this.setPartName(existingInput.getName());
                            } else if (this.getEditorInput() instanceof NewTaskEditorInput) {
                                String label = ((NewTaskEditorInput)this.getEditorInput()).getName();
                                this.setPartName(label);
                            }
                            this.setPageText(index, factory.getTitle());
                            selectedIndex = index;
                        }
                    }
                    if (!factory.providesOutline()) continue;
                    this.contentOutlineProvider = editor;
                }
                catch (Exception e) {
                    StatusHandler.fail((Throwable)e, (String)("Could not create editor via factory: " + factory), (boolean)true);
                }
            }
            if (selectedIndex != -1) {
                this.setActivePage(selectedIndex);
            }
            if (this.task != null) {
                AbstractRepositoryConnectorUi connectorUi = TasksUiPlugin.getConnectorUi(this.task.getConnectorKind());
                if (connectorUi != null) {
                    ImageDescriptor overlayDescriptor = connectorUi.getTaskKindOverlay(this.task);
                    this.setTitleImage(TasksUiImages.getCompositeTaskImage(TasksUiImages.TASK, overlayDescriptor, false));
                } else {
                    this.setTitleImage(TasksUiImages.getImage(TasksUiImages.TASK));
                }
            } else if (this.getEditorInput() instanceof AbstractRepositoryTaskEditorInput) {
                this.setTitleImage(TasksUiImages.getImage(TasksUiImages.TASK_REMOTE));
            } else {
                this.setTitleImage(TasksUiImages.getImage(TasksUiImages.TASK));
            }
        }
        catch (PartInitException e) {
            StatusHandler.fail((Throwable)e, (String)"failed to create task editor pages", (boolean)false);
        }
    }

    public void setFocus() {
        if (this.getActivePageInstance() instanceof AbstractNewRepositoryTaskEditor) {
            this.getActivePageInstance().setFocus();
        } else {
            super.setFocus();
        }
    }

    public void updateTitle(String name) {
        this.setPartName(name);
        this.setTitleToolTip(name);
        this.updateFormTitle();
    }

    public void showBusy(boolean busy) {
        if (busy) {
            if (TasksUiUtil.isAnimationsEnabled()) {
                this.editorBusyIndicator.start();
            }
        } else {
            this.editorBusyIndicator.stop();
        }
        IFormPage[] iFormPageArray = this.getPages();
        int n = iFormPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFormPage page = iFormPageArray[n2];
            if (page instanceof AbstractRepositoryTaskEditor) {
                AbstractRepositoryTaskEditor editor = (AbstractRepositoryTaskEditor)page;
                editor.showBusy(busy);
            }
            ++n2;
        }
    }

    public ISelection getSelection() {
        if (this.getSite() != null && this.getSite().getSelectionProvider() != null) {
            return this.getSite().getSelectionProvider().getSelection();
        }
        return StructuredSelection.EMPTY;
    }

    protected void createHeaderContents(IManagedForm headerForm) {
        this.getToolkit().decorateFormHeading(headerForm.getForm().getForm());
        headerForm.getForm().setImage(TasksUiImages.getImage(TasksUiImages.TASK));
        this.updateFormTitle();
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void updateFormTitle() {
        IEditorInput input = this.getEditorInput();
        if (input instanceof TaskEditorInput) {
            AbstractTask task = ((TaskEditorInput)input).getTask();
            if (task instanceof LocalTask) {
                this.getHeaderForm().getForm().setText("Task: " + task.getSummary());
                return;
            }
            this.setFormHeaderImage(task.getConnectorKind());
            this.setFormHeaderLabel(task);
            return;
        }
        if (!(input instanceof RepositoryTaskEditorInput)) return;
        AbstractTask task = ((RepositoryTaskEditorInput)input).getRepositoryTask();
        RepositoryTaskData data = ((RepositoryTaskEditorInput)input).getTaskData();
        if (task != null && data != null && !data.isNew()) {
            this.setFormHeaderImage(task.getConnectorKind());
            this.setFormHeaderLabel(task);
            return;
        }
        if (data == null) return;
        this.setFormHeaderImage(data.getRepositoryKind());
        this.setFormHeaderLabel(data);
    }

    private void setFormHeaderImage(String repositoryKind) {
        ImageDescriptor overlay = TasksUiPlugin.getDefault().getOverlayIcon(repositoryKind);
        Image image = TasksUiImages.getImageWithOverlay(TasksUiImages.REPOSITORY, overlay, false, false);
        if (this.getHeaderForm() != null) {
            this.getHeaderForm().getForm().setImage(image);
        }
    }

    public Form getTopForm() {
        return this.getHeaderForm().getForm().getForm();
    }

    public void setMessage(String message, int type) {
        if (this.getHeaderForm() != null && this.getHeaderForm().getForm() != null && !this.getHeaderForm().getForm().isDisposed()) {
            this.getHeaderForm().getForm().setMessage(message, type);
        }
    }

    protected IWorkbenchSiteProgressService getProgressService() {
        Object siteService = this.getEditorSite().getAdapter(IWorkbenchSiteProgressService.class);
        if (siteService != null) {
            return (IWorkbenchSiteProgressService)siteService;
        }
        return null;
    }

    private void setFormHeaderLabel(RepositoryTaskData taskData) {
        AbstractRepositoryConnectorUi connectorUi = TasksUiPlugin.getConnectorUi(taskData.getRepositoryKind());
        String kindLabel = taskData.getTaskKind();
        if (connectorUi != null) {
            kindLabel = connectorUi.getTaskKindLabel(taskData);
        }
        String idLabel = taskData.getTaskKey();
        if (taskData.isNew()) {
            kindLabel = connectorUi != null ? "New " + connectorUi.getTaskKindLabel(taskData) : "New " + taskData.getTaskKind();
            idLabel = "";
        }
        if (idLabel != null) {
            if (this.getHeaderForm().getForm() != null) {
                this.getHeaderForm().getForm().setText(String.valueOf(kindLabel) + " " + idLabel);
            }
        } else if (this.getHeaderForm().getForm() != null) {
            this.getHeaderForm().getForm().setText(kindLabel);
        }
    }

    private void setFormHeaderLabel(AbstractTask repositoryTask) {
        String idLabel;
        AbstractRepositoryConnectorUi connectorUi = TasksUiPlugin.getConnectorUi(repositoryTask.getConnectorKind());
        String kindLabel = "";
        if (connectorUi != null) {
            kindLabel = connectorUi.getTaskKindLabel(repositoryTask);
        }
        if ((idLabel = repositoryTask.getTaskKey()) != null) {
            if (this.getHeaderForm().getForm() != null) {
                this.getHeaderForm().getForm().setText(String.valueOf(kindLabel) + " " + idLabel);
            }
        } else if (this.getHeaderForm() != null && this.getHeaderForm().getForm() != null) {
            this.getHeaderForm().getForm().setText(kindLabel);
        }
    }

    @Override
    public void setTitleImage(Image titleImage) {
        super.setTitleImage(titleImage);
    }
}

