/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.ui.search;

import java.util.Set;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryQuery;
import org.eclipse.mylyn.tasks.core.AbstractTaskCategory;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TaskFactory;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.ui.search.SearchHitCollector;
import org.eclipse.mylyn.tasks.ui.wizards.AbstractEditQueryWizard;
import org.eclipse.search.ui.ISearchPage;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractRepositoryQueryPage
extends WizardPage
implements ISearchPage {
    private static final String TITLE_QUERY_TITLE = "&Query Title:";
    private static final String TITLE = "Enter query parameters";
    private static final String DESCRIPTION = "If attributes are blank or stale press the Update button.";
    private String titleString;
    protected Text title;
    protected ISearchPageContainer scontainer = null;
    protected TaskRepository repository;

    public AbstractRepositoryQueryPage(String wizardTitle) {
        this(wizardTitle, null);
        this.setTitle(TITLE);
        this.setDescription(DESCRIPTION);
        this.setImageDescriptor(TasksUiImages.BANNER_REPOSITORY);
        this.setPageComplete(false);
    }

    public AbstractRepositoryQueryPage(String wizardTitle, String queryTitle) {
        super(wizardTitle);
        this.titleString = queryTitle == null ? "" : queryTitle;
    }

    public void createControl(Composite parent) {
        if (this.scontainer == null) {
            this.createTitleGroup(parent);
            this.title.setFocus();
        }
    }

    private void createTitleGroup(Composite parent) {
        Composite group = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        group.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 1;
        group.setLayoutData((Object)gd);
        Label label = new Label(group, 0);
        label.setText(TITLE_QUERY_TITLE);
        this.title = new Text(group, 2048);
        this.title.setLayoutData((Object)new GridData(768));
        this.title.setText(this.titleString);
        this.title.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractRepositoryQueryPage.this.setPageComplete(AbstractRepositoryQueryPage.this.isPageComplete());
            }
        });
    }

    public boolean isPageComplete() {
        String oldSummary;
        Set queries = TasksUiPlugin.getTaskListManager().getTaskList().getQueries();
        Set categories = TasksUiPlugin.getTaskListManager().getTaskList().getCategories();
        if (this.title == null || this.title.getText().equals("")) {
            this.setErrorMessage("Please specify a title for the query.");
            return false;
        }
        if (this.getWizard() instanceof AbstractEditQueryWizard && (oldSummary = ((AbstractEditQueryWizard)this.getWizard()).getQuerySummary()) != null && this.title.getText().equals(oldSummary)) {
            this.setErrorMessage(null);
            return true;
        }
        for (AbstractTaskCategory category : categories) {
            if (!this.title.getText().equals(category.getSummary())) continue;
            this.setErrorMessage("A category with this name already exists, please choose another name.");
            return false;
        }
        for (AbstractRepositoryQuery query : queries) {
            if (!this.title.getText().equals(query.getSummary())) continue;
            this.setErrorMessage("A query with this name already exists, please choose another name.");
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    public String getQueryTitle() {
        return this.title != null ? this.title.getText() : "";
    }

    public abstract AbstractRepositoryQuery getQuery();

    public void saveState() {
    }

    public void setContainer(ISearchPageContainer container) {
        this.scontainer = container;
    }

    public boolean inSearchContainer() {
        return this.scontainer != null;
    }

    public boolean performAction() {
        if (this.repository == null) {
            MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Mylyn Information", (String)"No repository available, please add one using the Task Repositories view.");
            return false;
        }
        NewSearchUI.activateSearchResultView();
        AbstractRepositoryConnector connector = TasksUiPlugin.getRepositoryManager().getRepositoryConnector(this.repository.getConnectorKind());
        if (connector != null) {
            SearchHitCollector collector = new SearchHitCollector(TasksUiPlugin.getTaskListManager().getTaskList(), this.repository, this.getQuery(), new TaskFactory(this.repository, false, false));
            NewSearchUI.runQueryInBackground((ISearchQuery)collector);
        }
        return true;
    }

    public void setControlsEnabled(boolean enabled) {
        this.setControlsEnabled(this.getControl(), enabled);
    }

    private void setControlsEnabled(Control control, boolean enabled) {
        if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control childControl = controlArray[n2];
                childControl.setEnabled(enabled);
                this.setControlsEnabled(childControl, enabled);
                ++n2;
            }
        }
        this.setPageComplete(this.isPageComplete());
    }
}

