/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.AbstractAttributeFactory;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.AbstractTaskDataHandler;
import org.eclipse.mylyn.tasks.core.RepositoryStatus;
import org.eclipse.mylyn.tasks.core.RepositoryTaskData;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.TaskSelection;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.mylyn.tasks.ui.editors.NewTaskEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class NewTaskWizard
extends Wizard
implements INewWizard {
    private TaskRepository taskRepository;
    private TaskSelection taskSelection;

    public NewTaskWizard(TaskRepository taskRepository, TaskSelection taskSelection) {
        this.taskRepository = taskRepository;
        this.taskSelection = taskSelection;
    }

    public NewTaskWizard(TaskRepository taskRepository) {
        this.taskRepository = taskRepository;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
    }

    public boolean canFinish() {
        return true;
    }

    public boolean performFinish() {
        AbstractRepositoryConnector connector = TasksUiPlugin.getRepositoryManager().getRepositoryConnector(this.taskRepository.getConnectorKind());
        final AbstractTaskDataHandler taskDataHandler = connector.getTaskDataHandler();
        if (taskDataHandler == null) {
            StatusHandler.displayStatus((String)"Error creating new task", (IStatus)new RepositoryStatus(4, "org.eclipse.mylyn.tasks.ui", 1, "The selected repository does not support creating new tasks."));
            return false;
        }
        AbstractAttributeFactory attributeFactory = taskDataHandler.getAttributeFactory(this.taskRepository.getUrl(), this.taskRepository.getConnectorKind(), "task");
        final RepositoryTaskData taskData = new RepositoryTaskData(attributeFactory, this.taskRepository.getConnectorKind(), this.taskRepository.getUrl(), TasksUiPlugin.getDefault().getNextNewRepositoryTaskId());
        taskData.setNew(true);
        try {
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        if (!taskDataHandler.initializeTaskData(NewTaskWizard.this.taskRepository, taskData, monitor)) {
                            throw new CoreException((IStatus)new RepositoryStatus(4, "org.eclipse.mylyn.tasks.ui", 1, "The selected repository does not support creating new tasks."));
                        }
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            this.getContainer().run(true, true, runnable);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof CoreException) {
                StatusHandler.displayStatus((String)"Error creating new task", (IStatus)((CoreException)e.getCause()).getStatus());
            } else {
                StatusHandler.fail((Throwable)e.getCause(), (String)"Error creating new task", (boolean)true);
            }
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        if (this.taskSelection != null) {
            taskDataHandler.cloneTaskData(this.taskSelection.getTaskData(), taskData);
        }
        NewTaskEditorInput editorInput = new NewTaskEditorInput(this.taskRepository, taskData);
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        TasksUiUtil.openEditor(editorInput, "org.eclipse.mylyn.tasks.ui.editors.task", page);
        return true;
    }
}

