/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.trac.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mylyn.internal.trac.core.TracRepositoryConnector;
import org.eclipse.mylyn.internal.trac.core.TracRepositoryQuery;
import org.eclipse.mylyn.internal.trac.core.TracTask;
import org.eclipse.mylyn.internal.trac.ui.TracHyperlinkUtil;
import org.eclipse.mylyn.internal.trac.ui.TracImages;
import org.eclipse.mylyn.internal.trac.ui.wizard.EditTracQueryWizard;
import org.eclipse.mylyn.internal.trac.ui.wizard.NewTracQueryWizard;
import org.eclipse.mylyn.internal.trac.ui.wizard.TracCustomQueryPage;
import org.eclipse.mylyn.internal.trac.ui.wizard.TracRepositorySettingsPage;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryQuery;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.tasks.core.RepositoryTaskData;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.TaskSelection;
import org.eclipse.mylyn.tasks.ui.AbstractRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.ui.wizards.AbstractRepositorySettingsPage;
import org.eclipse.mylyn.tasks.ui.wizards.NewTaskWizard;
import org.eclipse.mylyn.tasks.ui.wizards.NewWebTaskWizard;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TracConnectorUi
extends AbstractRepositoryConnectorUi {
    public IHyperlink[] findHyperlinks(TaskRepository repository, String text, int lineOffset, int regionOffset) {
        return TracHyperlinkUtil.findHyperlinks(repository, text, lineOffset, regionOffset);
    }

    public String getTaskKindLabel(AbstractTask repositoryTask) {
        return "Ticket";
    }

    public String getTaskKindLabel(RepositoryTaskData taskData) {
        return "Ticket";
    }

    public AbstractRepositorySettingsPage getSettingsPage() {
        return new TracRepositorySettingsPage(this);
    }

    public WizardPage getSearchPage(TaskRepository repository, IStructuredSelection selection) {
        return new TracCustomQueryPage(repository);
    }

    public boolean hasSearchPage() {
        return true;
    }

    public IWizard getNewTaskWizard(TaskRepository repository) {
        if (TracRepositoryConnector.hasRichEditor((TaskRepository)repository)) {
            return new NewTaskWizard(repository);
        }
        return new NewWebTaskWizard(repository, String.valueOf(repository.getUrl()) + "/newticket");
    }

    public IWizard getNewTaskWizard(TaskRepository repository, TaskSelection selection) {
        if (TracRepositoryConnector.hasRichEditor((TaskRepository)repository)) {
            return new NewTaskWizard(repository, selection);
        }
        return null;
    }

    public IWizard getQueryWizard(TaskRepository repository, AbstractRepositoryQuery query) {
        if (query instanceof TracRepositoryQuery) {
            return new EditTracQueryWizard(repository, query);
        }
        return new NewTracQueryWizard(repository);
    }

    public String getConnectorKind() {
        return "trac";
    }

    public ImageDescriptor getTaskKindOverlay(AbstractTask task) {
        TracTask.Kind kind = TracTask.Kind.fromString((String)task.getTaskKind());
        if (kind == TracTask.Kind.DEFECT) {
            return TracImages.OVERLAY_DEFECT;
        }
        if (kind == TracTask.Kind.ENHANCEMENT) {
            return TracImages.OVERLAY_ENHANCEMENT;
        }
        if (kind == TracTask.Kind.TASK) {
            return null;
        }
        return super.getTaskKindOverlay(task);
    }

    public List<AbstractTaskContainer> getLegendItems() {
        ArrayList<AbstractTaskContainer> legendItems = new ArrayList<AbstractTaskContainer>();
        TracTask defect = new TracTask("", TracTask.Kind.DEFECT.name(), TracTask.Kind.DEFECT.toString());
        defect.setTaskKind(TracTask.Kind.DEFECT.toString());
        legendItems.add((AbstractTaskContainer)defect);
        TracTask enhancement = new TracTask("", TracTask.Kind.ENHANCEMENT.name(), TracTask.Kind.ENHANCEMENT.toString());
        enhancement.setTaskKind(TracTask.Kind.ENHANCEMENT.toString());
        legendItems.add((AbstractTaskContainer)enhancement);
        TracTask task = new TracTask("", TracTask.Kind.TASK.name(), TracTask.Kind.TASK.toString());
        task.setTaskKind(TracTask.Kind.TASK.toString());
        legendItems.add((AbstractTaskContainer)task);
        return legendItems;
    }
}

