/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.ui;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaCorePlugin;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaRepositoryConnector;
import org.eclipse.mylyn.internal.bugzilla.core.RepositoryConfiguration;
import org.eclipse.mylyn.internal.bugzilla.ui.BugzillaUiExtensionReader;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.ITaskRepositoryListener;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BugzillaUiPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.mylyn.bugzilla.ui";
    public static final String SEARCH_PAGE_ID = "org.eclipse.mylyn.bugzilla.ui.search.bugzillaSearchPage";
    public static final String SEARCH_PAGE_CONTEXT = "org.eclipse.mylyn.bugzilla.ui.bugzillaSearchContext";
    public static final String EDITOR_PAGE_CONTEXT = "org.eclipse.mylyn.bugzilla.ui.bugzillaEditorContext";
    public static final String HIT_MARKER_ATTR_ID = "taskId";
    public static final String HIT_MARKER_ATTR_REPOSITORY = "repository";
    public static final String HIT_MARKER_ATTR_HREF = "href";
    public static final String HIT_MARKER_ATTR_DESC = "summary";
    public static final String HIT_MARKER_ATTR_LABEL = "label";
    public static final String HIT_MARKER_ATTR_SEVERITY = "severity";
    public static final String HIT_MARKER_ATTR_PRIORITY = "priority";
    public static final String HIT_MARKER_ATTR_PLATFORM = "platform";
    public static final String HIT_MARKER_ATTR_STATE = "state";
    public static final String HIT_MARKER_ATTR_RESULT = "result";
    public static final String HIT_MARKER_ATTR_OWNER = "owner";
    public static final String HIT_MARKER_ATTR_QUERY = "query";
    public static final String HIT_MARKER_ID = "org.eclipse.mylyn.bugzilla.ui.searchHit";
    private static BugzillaUiPlugin plugin;
    public static final char PREF_DELIM_REPOSITORY = ':';
    private static final int WRAP_LENGTH = 90;

    public BugzillaUiPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.getPreferenceStore().setDefault("org.eclipse.mylyn.bugzilla.search.results.max", 100);
        IPath repConfigCacheFile = BugzillaUiPlugin.getProductConfigurationCachePath();
        if (repConfigCacheFile != null) {
            BugzillaCorePlugin.setConfigurationCacheFile((File)repConfigCacheFile.toFile());
        }
        BugzillaRepositoryConnector bugzillaConnector = (BugzillaRepositoryConnector)TasksUiPlugin.getRepositoryManager().getRepositoryConnector("bugzilla");
        TasksUiPlugin.getRepositoryManager().addListener((ITaskRepositoryListener)bugzillaConnector.getClientManager());
        BugzillaUiExtensionReader.initStartupExtensions();
    }

    private static IPath getProductConfigurationCachePath() {
        IPath stateLocation = Platform.getStateLocation((Bundle)BugzillaCorePlugin.getDefault().getBundle());
        IPath configFile = stateLocation.append("repositoryConfigurations");
        return configFile;
    }

    public int getMaxResults() {
        return this.getPreferenceStore().getInt("org.eclipse.mylyn.bugzilla.search.results.max");
    }

    public void stop(BundleContext context) throws Exception {
        BugzillaRepositoryConnector bugzillaConnector = (BugzillaRepositoryConnector)TasksUiPlugin.getRepositoryManager().getRepositoryConnector("bugzilla");
        TasksUiPlugin.getRepositoryManager().removeListener((ITaskRepositoryListener)bugzillaConnector.getClientManager());
        super.stop(context);
        plugin = null;
    }

    public static BugzillaUiPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static String[] getQueryOptions(String prefId, String[] selectedProducts, String repositoryUrl) {
        IPreferenceStore prefs = BugzillaUiPlugin.getDefault().getPreferenceStore();
        if ((prefId.equals("org.eclipse.mylyn.bugzilla.values.component") || prefId.equals("org.eclipse.mylyn.bugzilla.values.version") || prefId.equals("org.eclipse.mylyn.bugzilla.values.target")) && selectedProducts != null) {
            ArrayList<String> options = new ArrayList<String>();
            String[] stringArray = selectedProducts;
            int n = selectedProducts.length;
            int n2 = 0;
            while (n2 < n) {
                String product = stringArray[n2];
                String[] stringArray2 = BugzillaUiPlugin.convertQueryOptionsToArray(prefs.getString(String.valueOf(prefId) + ':' + repositoryUrl + ':' + product));
                int n3 = stringArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    String option = stringArray2[n4];
                    if (!options.contains(option)) {
                        options.add(option);
                    }
                    ++n4;
                }
                ++n2;
            }
            return options.toArray(new String[options.size()]);
        }
        return BugzillaUiPlugin.convertQueryOptionsToArray(prefs.getString(String.valueOf(prefId) + ':' + repositoryUrl));
    }

    private static String queryOptionsToString(List<String> array) {
        StringBuffer buffer = new StringBuffer();
        for (String string : array) {
            buffer.append(string);
            buffer.append("!");
        }
        return buffer.toString();
    }

    private static String[] convertQueryOptionsToArray(String values) {
        StringBuffer buffer = new StringBuffer();
        ArrayList<String> options = new ArrayList<String>();
        char[] chars = values.toCharArray();
        int i = 0;
        while (i < chars.length) {
            if (chars[i] == '!') {
                options.add(buffer.toString());
                buffer = new StringBuffer();
            } else {
                buffer.append(chars[i]);
            }
            ++i;
        }
        String[] array = new String[options.size()];
        int j = 0;
        while (j < options.size()) {
            array[j] = (String)options.get(j);
            ++j;
        }
        return array;
    }

    public static String getMostRecentQuery() {
        return plugin.getPreferenceStore().getString("org.eclipse.mylyn.bugzilla.query.last");
    }

    public static void updateQueryOptions(TaskRepository repository, IProgressMonitor monitor) {
        String repositoryUrl = repository.getUrl();
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        RepositoryConfiguration config = null;
        try {
            config = BugzillaCorePlugin.getRepositoryConfiguration((TaskRepository)repository, (boolean)false);
        }
        catch (Exception e) {
            StatusHandler.fail((Throwable)e, (String)("Could not retrieve repository configuration for: " + repository), (boolean)true);
            return;
        }
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        IPreferenceStore prefs = BugzillaUiPlugin.getDefault().getPreferenceStore();
        prefs.setValue("org.eclipse.mylyn.bugzilla.values.status:" + repositoryUrl, BugzillaUiPlugin.queryOptionsToString(config.getStatusValues()));
        monitor.worked(1);
        prefs.setValue("org.eclipse.mylyn.bugzilla.values.status.preselected:" + repositoryUrl, BugzillaUiPlugin.queryOptionsToString(config.getOpenStatusValues()));
        monitor.worked(1);
        prefs.setValue("org.eclipse.mylyn.bugzilla.values.resolution:" + repositoryUrl, BugzillaUiPlugin.queryOptionsToString(config.getResolutions()));
        monitor.worked(1);
        prefs.setValue("org.eclipse.mylyn.bugzilla.values.severity:" + repositoryUrl, BugzillaUiPlugin.queryOptionsToString(config.getSeverities()));
        monitor.worked(1);
        prefs.setValue("org.eclipse.mylyn.bugzilla.values.priority:" + repositoryUrl, BugzillaUiPlugin.queryOptionsToString(config.getPriorities()));
        monitor.worked(1);
        prefs.setValue("org.eclipse.mylyn.bugzilla.values.hardware:" + repositoryUrl, BugzillaUiPlugin.queryOptionsToString(config.getPlatforms()));
        monitor.worked(1);
        prefs.setValue("org.eclipse.mylyn.bugzilla.values.os:" + repositoryUrl, BugzillaUiPlugin.queryOptionsToString(config.getOSs()));
        monitor.worked(1);
        prefs.setValue("org.eclipse.mylyn.bugzilla.values.product:" + repositoryUrl, BugzillaUiPlugin.queryOptionsToString(config.getProducts()));
        monitor.worked(1);
        prefs.setValue("org.eclipse.mylyn.bugzilla.values.component:" + repositoryUrl, BugzillaUiPlugin.queryOptionsToString(config.getComponents()));
        monitor.worked(1);
        prefs.setValue("org.eclipse.mylyn.bugzilla.values.version:" + repositoryUrl, BugzillaUiPlugin.queryOptionsToString(config.getVersions()));
        monitor.worked(1);
        prefs.setValue("org.eclipse.mylyn.bugzilla.values.target:" + repositoryUrl, BugzillaUiPlugin.queryOptionsToString(config.getTargetMilestones()));
        monitor.worked(1);
        prefs.setValue("org.eclipse.mylyn.bugzilla.values.keywords:" + repositoryUrl, BugzillaUiPlugin.queryOptionsToString(config.getKeywords()));
        monitor.worked(1);
        for (String product : config.getProducts()) {
            prefs.setValue("org.eclipse.mylyn.bugzilla.values.component:" + repositoryUrl + ':' + product, BugzillaUiPlugin.queryOptionsToString(config.getComponents(product)));
            monitor.worked(1);
            prefs.setValue("org.eclipse.mylyn.bugzilla.values.version:" + repositoryUrl + ':' + product, BugzillaUiPlugin.queryOptionsToString(config.getVersions(product)));
            monitor.worked(1);
            prefs.setValue("org.eclipse.mylyn.bugzilla.values.target:" + repositoryUrl + ':' + product, BugzillaUiPlugin.queryOptionsToString(config.getTargetMilestones(product)));
            monitor.worked(1);
        }
    }

    public static String formatTextToLineWrap(String origText, boolean hardWrap) {
        if (!hardWrap) {
            return origText;
        }
        String[] textArray = new String[(origText.length() / 90 + 1) * 2];
        int i = 0;
        while (i < textArray.length) {
            textArray[i] = null;
            ++i;
        }
        int j = 0;
        while (true) {
            int spaceIndex;
            if ((spaceIndex = origText.indexOf(" ", 85)) == origText.length() || spaceIndex == -1) break;
            textArray[j] = origText.substring(0, spaceIndex);
            origText = origText.substring(spaceIndex + 1, origText.length());
            ++j;
        }
        textArray[j] = origText;
        String newText = "";
        int i2 = 0;
        while (i2 < textArray.length) {
            if (textArray[i2] == null) break;
            newText = String.valueOf(newText) + textArray[i2] + "\n";
            ++i2;
        }
        return newText;
    }
}

