/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.ui.tasklist;

import org.eclipse.mylyn.internal.bugzilla.core.BugzillaRepositoryQuery;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.search.AbstractRepositoryQueryPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class BugzillaCustomQueryWizardPage
extends AbstractRepositoryQueryPage {
    private static final String LABEL_CUSTOM_TITLE = "&Query Title:";
    private static final String LABEL_CUSTOM_QUERY = "Query &URL";
    private static final String TITLE = "Create query from URL";
    private static final String DESCRIPTION = "Enter the title and URL for the query";
    private Text queryText;
    private BugzillaRepositoryQuery query;

    public BugzillaCustomQueryWizardPage(TaskRepository repository, BugzillaRepositoryQuery query) {
        super(TITLE, query.getSummary());
        this.query = query;
        this.repository = repository;
        this.setTitle(TITLE);
        this.setDescription(DESCRIPTION);
        this.setImageDescriptor(TasksUiImages.BANNER_REPOSITORY);
    }

    public BugzillaCustomQueryWizardPage(TaskRepository repository) {
        super(TITLE);
        this.repository = repository;
        this.setTitle(TITLE);
        this.setDescription(DESCRIPTION);
        this.setImageDescriptor(TasksUiImages.BANNER_REPOSITORY);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.setControl((Control)composite);
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BugzillaCustomQueryWizardPage.this.setPageComplete(BugzillaCustomQueryWizardPage.this.isPageComplete());
            }
        };
        Label queryTitleLabel = new Label(composite, 0);
        queryTitleLabel.setText(LABEL_CUSTOM_TITLE);
        Text queryTitle = new Text(composite, 2048);
        queryTitle.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        queryTitle.addModifyListener(modifyListener);
        this.title = queryTitle;
        this.title.setFocus();
        Label queryUrlLabel = new Label(composite, 0);
        queryUrlLabel.setText(LABEL_CUSTOM_QUERY);
        this.queryText = new Text(composite, 2048);
        GridData gd_queryText = new GridData(4, 0x1000000, true, false);
        gd_queryText.widthHint = 300;
        this.queryText.setLayoutData((Object)gd_queryText);
        this.queryText.addModifyListener(modifyListener);
        if (this.query != null) {
            queryTitle.setText(this.query.getSummary());
            this.queryText.setText(this.query.getUrl());
        }
    }

    public boolean canFlipToNextPage() {
        return false;
    }

    public boolean isPageComplete() {
        if (super.isPageComplete()) {
            if (this.queryText.getText().length() > 0) {
                return true;
            }
            this.setErrorMessage("Please specify Query URL");
        }
        return false;
    }

    public BugzillaRepositoryQuery getQuery() {
        if (this.query == null) {
            this.query = new BugzillaRepositoryQuery(this.repository.getUrl(), this.queryText.getText(), this.getQueryTitle());
            this.query.setCustomQuery(true);
        } else {
            this.query.setHandleIdentifier(this.getQueryTitle());
            this.query.setUrl(this.queryText.getText());
        }
        return this.query;
    }
}

