/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.context.ui;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.context.core.ContextCorePlugin;
import org.eclipse.mylyn.context.core.IInteractionContext;
import org.eclipse.mylyn.context.core.IInteractionContextListener;
import org.eclipse.mylyn.context.core.IInteractionContextListener2;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractContextUiPlugin
extends AbstractUIPlugin
implements IInteractionContextListener2 {
    private AtomicBoolean lazyStarted = new AtomicBoolean(false);

    public void start(BundleContext context) throws Exception {
        super.start(context);
        ContextCorePlugin.getContextManager().addListener((IInteractionContextListener)this);
        if (ContextCorePlugin.getContextManager().isContextActive()) {
            this.initLazyStart();
        }
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        if (this.lazyStarted.get()) {
            this.lazyStop();
        }
        if (TasksUiPlugin.getTaskListManager() != null) {
            ContextCorePlugin.getContextManager().removeListener((IInteractionContextListener)this);
        }
    }

    protected abstract void lazyStart(IWorkbench var1);

    protected abstract void lazyStop();

    public void contextPreActivated(IInteractionContext context) {
        this.initLazyStart();
    }

    public void contextActivated(IInteractionContext context) {
    }

    private void initLazyStart() {
        if (!this.lazyStarted.getAndSet(true)) {
            IWorkbench workbench = PlatformUI.getWorkbench();
            try {
                this.lazyStart(workbench);
            }
            catch (Throwable t) {
                StatusHandler.log((IStatus)new Status(4, super.getBundle().getSymbolicName(), 4, "Could not lazy start context plug-in", t));
            }
            if (TasksUiPlugin.getTaskListManager() != null) {
                ContextCorePlugin.getContextManager().removeListener((IInteractionContextListener)this);
            }
        }
    }

    public void contextCleared(IInteractionContext context) {
    }

    public void contextDeactivated(IInteractionContext context) {
    }

    public void elementDeleted(IInteractionElement element) {
    }

    public void interestChanged(List<IInteractionElement> elements) {
    }

    public void landmarkAdded(IInteractionElement element) {
    }

    public void landmarkRemoved(IInteractionElement element) {
    }

    public void relationsChanged(IInteractionElement element) {
    }

    public void elementsDeleted(List<IInteractionElement> elements) {
    }
}

