/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.context.ui;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.mylyn.context.ui.InterestFilter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.progress.UIJob;

public class BrowseFilteredListener
implements MouseListener,
KeyListener {
    private StructuredViewer viewer;

    public BrowseFilteredListener(StructuredViewer viewer) {
        this.viewer = viewer;
    }

    public void unfilterSelection(TreeViewer treeViewer, IStructuredSelection targetSelection) {
        InterestFilter filter = this.getInterestFilter((StructuredViewer)treeViewer);
        Object targetObject = targetSelection.getFirstElement();
        if (targetObject != null) {
            filter.setTemporarilyUnfiltered(targetObject);
            if (targetObject instanceof Tree) {
                treeViewer.refresh();
            } else {
                treeViewer.refresh(targetObject, true);
                treeViewer.expandToLevel(targetObject, 1);
            }
        }
    }

    private void unfilter(InterestFilter filter, TreeViewer treeViewer, Object targetObject) {
        if (targetObject != null) {
            filter.setTemporarilyUnfiltered(targetObject);
            if (targetObject instanceof Tree) {
                treeViewer.refresh();
            } else {
                treeViewer.refresh(targetObject, true);
                treeViewer.expandToLevel(targetObject, 1);
            }
        }
    }

    public void keyPressed(KeyEvent event) {
    }

    public void keyReleased(KeyEvent event) {
        InterestFilter filter = this.getInterestFilter(this.viewer);
        if (event.keyCode == 0x1000004) {
            if (filter == null || !(this.viewer instanceof TreeViewer)) {
                return;
            }
            TreeViewer treeViewer = (TreeViewer)this.viewer;
            ISelection selection = treeViewer.getSelection();
            if (selection instanceof IStructuredSelection) {
                Object targetObject = ((IStructuredSelection)selection).getFirstElement();
                this.unfilter(filter, treeViewer, targetObject);
            }
        }
    }

    public void mouseDown(MouseEvent event) {
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseUp(MouseEvent event) {
        final InterestFilter filter = this.getInterestFilter(this.viewer);
        if (filter == null || !(this.viewer instanceof TreeViewer)) {
            return;
        }
        TreeViewer treeViewer = (TreeViewer)this.viewer;
        Object selectedObject = null;
        Object clickedObject = this.getClickedItem(event);
        selectedObject = clickedObject != null ? clickedObject : treeViewer.getTree();
        if (BrowseFilteredListener.isUnfilterEvent(event)) {
            if (treeViewer instanceof CommonViewer) {
                CommonViewer commonViewer = (CommonViewer)treeViewer;
                commonViewer.setSelection((ISelection)new StructuredSelection(selectedObject), true);
            }
            this.unfilter(filter, treeViewer, selectedObject);
        } else if (event.button == 1) {
            if ((event.stateMask & SWT.MOD1) != 0) {
                this.viewer.refresh(selectedObject);
            } else {
                final Object unfiltered = filter.getTemporarilyUnfiltered();
                if (unfiltered != null) {
                    new UIJob(""){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            filter.resetTemporarilyUnfiltered();
                            BrowseFilteredListener.this.viewer.refresh(unfiltered);
                            return Status.OK_STATUS;
                        }
                    }.schedule((long)(event.display.getDoubleClickTime() + 50));
                }
            }
        }
    }

    private Object getClickedItem(MouseEvent event) {
        if (event.getSource() instanceof Table) {
            TableItem item = ((Table)event.getSource()).getItem(new Point(event.x, event.y));
            if (item != null) {
                return item.getData();
            }
            return null;
        }
        if (event.getSource() instanceof Tree) {
            TreeItem item = ((Tree)event.getSource()).getItem(new Point(event.x, event.y));
            if (item != null) {
                return item.getData();
            }
            return null;
        }
        return null;
    }

    public static boolean isUnfilterEvent(MouseEvent event) {
        return (event.stateMask & 0x10000) != 0;
    }

    private InterestFilter getInterestFilter(StructuredViewer structuredViewer) {
        ViewerFilter[] filters = structuredViewer.getFilters();
        int i = 0;
        while (i < filters.length) {
            if (filters[i] instanceof InterestFilter) {
                return (InterestFilter)filters[i];
            }
            ++i;
        }
        return null;
    }
}

