/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.context.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.mylyn.context.core.AbstractContextStructureBridge;
import org.eclipse.mylyn.context.core.ContextCorePlugin;
import org.eclipse.mylyn.context.core.IInteractionContext;
import org.eclipse.mylyn.context.core.IInteractionContextListener2;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.context.ui.ContextUiPlugin;
import org.eclipse.mylyn.internal.context.ui.BrowseFilteredListener;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FocusedViewerManager
implements IInteractionContextListener2,
ISelectionListener {
    private CopyOnWriteArrayList<StructuredViewer> managedViewers = new CopyOnWriteArrayList();
    private CopyOnWriteArrayList<StructuredViewer> filteredViewers = new CopyOnWriteArrayList();
    private Map<StructuredViewer, BrowseFilteredListener> listenerMap = new HashMap<StructuredViewer, BrowseFilteredListener>();
    private Map<IWorkbenchPart, StructuredViewer> partToViewerMap = new HashMap<IWorkbenchPart, StructuredViewer>();
    private boolean syncRefreshMode = false;

    public void dispose() {
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
    }

    public void addManagedViewer(StructuredViewer viewer, IWorkbenchPart viewPart) {
        if (viewer != null && !this.managedViewers.contains(viewer)) {
            this.managedViewers.add(viewer);
            this.partToViewerMap.put(viewPart, viewer);
            BrowseFilteredListener listener = new BrowseFilteredListener(viewer);
            this.listenerMap.put(viewer, listener);
            viewer.getControl().addMouseListener((MouseListener)listener);
            viewer.getControl().addKeyListener((KeyListener)listener);
        }
    }

    public void removeManagedViewer(StructuredViewer viewer, IWorkbenchPart viewPart) {
        this.managedViewers.remove(viewer);
        this.partToViewerMap.remove(viewPart);
        BrowseFilteredListener listener = this.listenerMap.get(viewer);
        if (listener != null && viewer != null && !viewer.getControl().isDisposed()) {
            viewer.getControl().removeMouseListener((MouseListener)listener);
            viewer.getControl().removeKeyListener((KeyListener)listener);
        }
    }

    public void addFilteredViewer(StructuredViewer viewer) {
        if (viewer != null && !this.filteredViewers.contains(viewer)) {
            this.filteredViewers.add(viewer);
        }
    }

    public void removeFilteredViewer(StructuredViewer viewer) {
        this.filteredViewers.remove(viewer);
    }

    public void contextActivated(IInteractionContext context) {
        this.refreshViewers();
    }

    public void contextDeactivated(IInteractionContext context) {
        this.refreshViewers();
        for (StructuredViewer structuredViewer : this.managedViewers) {
            if (!(structuredViewer instanceof TreeViewer)) continue;
            ((TreeViewer)structuredViewer).collapseAll();
        }
    }

    public void contextCleared(IInteractionContext context) {
        this.contextDeactivated(context);
    }

    protected void refreshViewers() {
        List<IInteractionElement> toRefresh = Collections.emptyList();
        this.refreshViewers(toRefresh, true);
    }

    protected void refreshViewers(IInteractionElement node, boolean updateLabels) {
        ArrayList<IInteractionElement> toRefresh = new ArrayList<IInteractionElement>();
        toRefresh.add(node);
        this.refreshViewers(toRefresh, updateLabels);
    }

    public void interestChanged(List<IInteractionElement> nodes) {
        this.refreshViewers(nodes, false);
    }

    protected void refreshViewers(final List<IInteractionElement> nodesToRefresh, final boolean updateLabels) {
        if (nodesToRefresh == null) {
            return;
        }
        if (this.syncRefreshMode) {
            this.internalRefresh(new HashSet<IInteractionElement>(nodesToRefresh), updateLabels);
        } else {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    FocusedViewerManager.this.internalRefresh(new HashSet(nodesToRefresh), updateLabels);
                }
            });
        }
    }

    private void internalRefresh(Set<IInteractionElement> nodesToRefresh, boolean updateLabels) {
        try {
            for (StructuredViewer viewer : this.managedViewers) {
                this.refreshViewer(nodesToRefresh, updateLabels, viewer);
            }
        }
        catch (Throwable t) {
            StatusHandler.fail((Throwable)t, (String)"could not refresh viewer", (boolean)false);
        }
    }

    private void refreshViewer(Set<IInteractionElement> nodesToRefresh, boolean minor, StructuredViewer viewer) {
        if (viewer == null) {
            return;
        }
        if (viewer.getControl().isDisposed()) {
            this.managedViewers.remove(viewer);
        } else if (nodesToRefresh == null || nodesToRefresh.isEmpty()) {
            if (!minor) {
                viewer.refresh(false);
                this.updateExpansionState(viewer, null);
            } else {
                try {
                    viewer.getControl().setRedraw(false);
                    viewer.refresh(true);
                    this.updateExpansionState(viewer, null);
                }
                finally {
                    viewer.getControl().setRedraw(true);
                }
            }
        } else {
            if (this.filteredViewers.contains(viewer)) {
                try {
                    viewer.getControl().setRedraw(false);
                    viewer.refresh(minor);
                    this.updateExpansionState(viewer, null);
                }
                finally {
                    viewer.getControl().setRedraw(true);
                }
            }
            try {
                viewer.getControl().setRedraw(false);
                for (IInteractionElement node : nodesToRefresh) {
                    AbstractContextStructureBridge structureBridge = ContextCorePlugin.getDefault().getStructureBridge(node.getContentType());
                    Object objectToRefresh = structureBridge.getObjectForHandle(node.getHandleIdentifier());
                    if (objectToRefresh == null) continue;
                    viewer.update(objectToRefresh, null);
                    this.updateExpansionState(viewer, objectToRefresh);
                }
            }
            finally {
                viewer.getControl().setRedraw(true);
            }
        }
    }

    private void updateExpansionState(StructuredViewer viewer, Object objectToRefresh) {
        if (viewer instanceof TreeViewer && this.filteredViewers.contains(viewer) && ContextUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.ide.ui.expansion.auto.manage")) {
            TreeViewer treeViewer = (TreeViewer)viewer;
            if (objectToRefresh == null) {
                treeViewer.expandAll();
            } else {
                treeViewer.expandToLevel(objectToRefresh, -1);
            }
        }
    }

    public void elementDeleted(IInteractionElement node) {
        AbstractContextStructureBridge structureBridge = ContextCorePlugin.getDefault().getStructureBridge(node.getContentType());
        IInteractionElement parent = ContextCorePlugin.getContextManager().getElement(structureBridge.getParentHandle(node.getHandleIdentifier()));
        if (parent != null) {
            ArrayList<IInteractionElement> toRefresh = new ArrayList<IInteractionElement>();
            toRefresh.add(parent);
            this.refreshViewers(toRefresh, false);
        }
    }

    public void elementsDeleted(List<IInteractionElement> elements) {
        this.refreshViewers();
    }

    public void landmarkAdded(IInteractionElement node) {
        this.refreshViewers(node, true);
    }

    public void landmarkRemoved(IInteractionElement node) {
        this.refreshViewers(node, true);
    }

    public void relationsChanged(IInteractionElement node) {
    }

    public void setSyncRefreshMode(boolean syncRefreshMode) {
        this.syncRefreshMode = syncRefreshMode;
    }

    public void contextPreActivated(IInteractionContext context) {
    }

    public void forceReferesh() {
        this.refreshViewers();
    }
}

