/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.context.ui;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class HighlighterImageDescriptor
extends ImageDescriptor {
    private Image image;
    static final int[][] DITHER_MATRIX;

    static {
        int[][] nArrayArray = new int[8][];
        nArrayArray[0] = new int[]{0xFC0000, 0x7C0000, 0xDC0000, 0x5C0000, 0xF40000, 0x740000, 0xD40000, 0x540000};
        nArrayArray[1] = new int[]{0x3C0000, 0xBC0000, 0x1C0000, 0x9C0000, 0x340000, 0xB40000, 0x140000, 0x940000};
        nArrayArray[2] = new int[]{0xCC0000, 0x4C0000, 0xEC0000, 0x6C0000, 0xC40000, 0x440000, 0xE40000, 0x640000};
        nArrayArray[3] = new int[]{786432, 0x8C0000, 0x2C0000, 0xAC0000, 262144, 0x840000, 0x240000, 0xA40000};
        nArrayArray[4] = new int[]{0xF00000, 0x700000, 0xD00000, 0x500000, 0xF80000, 0x780000, 0xD80000, 0x580000};
        nArrayArray[5] = new int[]{0x300000, 0xB00000, 0x100000, 0x900000, 0x380000, 0xB80000, 0x180000, 0x980000};
        nArrayArray[6] = new int[]{0xC00000, 0x400000, 0xE00000, 0x600000, 0xC80000, 0x480000, 0xE80000, 0x680000};
        int[] nArray = new int[8];
        nArray[1] = 0x800000;
        nArray[2] = 0x200000;
        nArray[3] = 0xA00000;
        nArray[4] = 524288;
        nArray[5] = 0x880000;
        nArray[6] = 0x280000;
        nArray[7] = 0xA80000;
        nArrayArray[7] = nArray;
        DITHER_MATRIX = nArrayArray;
    }

    public HighlighterImageDescriptor(Color fromColor, Color toColor) {
        if (fromColor == null) {
            fromColor = Display.getCurrent().getSystemColor(22);
        }
        if (toColor == null) {
            toColor = Display.getCurrent().getSystemColor(22);
        }
        ImageData band = HighlighterImageDescriptor.createGradientBand(50, 20, false, new RGB(fromColor.getRed(), fromColor.getGreen(), fromColor.getBlue()), new RGB(toColor.getRed(), toColor.getGreen(), toColor.getBlue()), 7, 7, 7);
        this.image = new Image((Device)Display.getCurrent(), band);
    }

    public void destroyResource(Object previouslyCreatedObject) {
        this.image.dispose();
        super.destroyResource(previouslyCreatedObject);
    }

    public boolean equals(Object obj) {
        return obj instanceof HighlighterImageDescriptor && this.image.equals((Object)((HighlighterImageDescriptor)((Object)obj)).image);
    }

    public ImageData getImageData() {
        return this.image.getImageData();
    }

    public int hashCode() {
        return this.image.hashCode();
    }

    public Image getImage() {
        return this.image;
    }

    static ImageData createGradientBand(int width, int height, boolean vertical, RGB fromRGB, RGB toRGB, int redBits, int greenBits, int blueBits) {
        byte[] bitmapData;
        int bandHeight;
        int bandWidth;
        int bitmapDepth;
        PaletteData paletteData;
        if (redBits != 0 && greenBits != 0 && blueBits != 0) {
            paletteData = new PaletteData(65280, 0xFF0000, -16777216);
            bitmapDepth = 32;
            if (redBits >= 8 && greenBits >= 8 && blueBits >= 8) {
                int steps;
                if (vertical) {
                    bandWidth = 1;
                    bandHeight = height;
                    steps = bandHeight > 1 ? bandHeight - 1 : 1;
                } else {
                    bandWidth = width;
                    bandHeight = 1;
                    steps = bandWidth > 1 ? bandWidth - 1 : 1;
                }
                int bytesPerLine = bandWidth * 4;
                bitmapData = new byte[bandHeight * bytesPerLine];
                HighlighterImageDescriptor.buildPreciseGradientChannel(fromRGB.blue, toRGB.blue, steps, bandWidth, bandHeight, vertical, bitmapData, 0, bytesPerLine);
                HighlighterImageDescriptor.buildPreciseGradientChannel(fromRGB.green, toRGB.green, steps, bandWidth, bandHeight, vertical, bitmapData, 1, bytesPerLine);
                HighlighterImageDescriptor.buildPreciseGradientChannel(fromRGB.red, toRGB.red, steps, bandWidth, bandHeight, vertical, bitmapData, 2, bytesPerLine);
            } else {
                int steps;
                if (vertical) {
                    bandWidth = width < 8 ? width : 8;
                    bandHeight = height;
                    steps = bandHeight > 1 ? bandHeight - 1 : 1;
                } else {
                    bandWidth = width;
                    bandHeight = height < 8 ? height : 8;
                    steps = bandWidth > 1 ? bandWidth - 1 : 1;
                }
                int bytesPerLine = bandWidth * 4;
                bitmapData = new byte[bandHeight * bytesPerLine];
                HighlighterImageDescriptor.buildDitheredGradientChannel(fromRGB.blue, toRGB.blue, steps, bandWidth, bandHeight, vertical, bitmapData, 0, bytesPerLine, blueBits);
                HighlighterImageDescriptor.buildDitheredGradientChannel(fromRGB.green, toRGB.green, steps, bandWidth, bandHeight, vertical, bitmapData, 1, bytesPerLine, greenBits);
                HighlighterImageDescriptor.buildDitheredGradientChannel(fromRGB.red, toRGB.red, steps, bandWidth, bandHeight, vertical, bitmapData, 2, bytesPerLine, redBits);
            }
        } else {
            int blendi;
            paletteData = new PaletteData(new RGB[]{fromRGB, toRGB});
            bitmapDepth = 8;
            if (vertical) {
                bandWidth = width < 8 ? width : 8;
                bandHeight = height;
                blendi = bandHeight > 1 ? 0x1040000 / (bandHeight - 1) + 1 : 1;
            } else {
                bandWidth = width;
                bandHeight = height < 8 ? height : 8;
                blendi = bandWidth > 1 ? 0x1040000 / (bandWidth - 1) + 1 : 1;
            }
            int bytesPerLine = bandWidth + 3 & 0xFFFFFFFC;
            bitmapData = new byte[bandHeight * bytesPerLine];
            if (vertical) {
                int dy = 0;
                int blend = 0;
                int dp = 0;
                while (dy < bandHeight) {
                    int dx = 0;
                    while (dx < bandWidth) {
                        bitmapData[dp + dx] = blend + DITHER_MATRIX[dy & 7][dx] < 0x1000000 ? (byte)0 : 1;
                        ++dx;
                    }
                    ++dy;
                    blend += blendi;
                    dp += bytesPerLine;
                }
            } else {
                int dx = 0;
                int blend = 0;
                while (dx < bandWidth) {
                    int dy = 0;
                    int dptr = dx;
                    while (dy < bandHeight) {
                        bitmapData[dptr] = blend + DITHER_MATRIX[dy][dx & 7] < 0x1000000 ? (byte)0 : 1;
                        ++dy;
                        dptr += bytesPerLine;
                    }
                    ++dx;
                    blend += blendi;
                }
            }
        }
        return new ImageData(bandWidth, bandHeight, bitmapDepth, paletteData, 4, bitmapData);
    }

    static final void buildDitheredGradientChannel(int from, int to, int steps, int bandWidth, int bandHeight, boolean vertical, byte[] bitmapData, int dp, int bytesPerLine, int bits) {
        int mask = 65280 >>> bits;
        int val = from << 16;
        int inc = ((to << 16) - val) / steps + 1;
        if (vertical) {
            int dy = 0;
            while (dy < bandHeight) {
                int dx = 0;
                int dptr = dp;
                while (dx < bandWidth) {
                    int thresh = DITHER_MATRIX[dy & 7][dx] >>> bits;
                    int temp = val + thresh;
                    bitmapData[dptr] = temp > 0xFFFFFF ? -1 : (byte)(temp >>> 16 & mask);
                    ++dx;
                    dptr += 4;
                }
                val += inc;
                ++dy;
                dp += bytesPerLine;
            }
        } else {
            int dx = 0;
            while (dx < bandWidth) {
                int dy = 0;
                int dptr = dp;
                while (dy < bandHeight) {
                    int thresh = DITHER_MATRIX[dy][dx & 7] >>> bits;
                    int temp = val + thresh;
                    bitmapData[dptr] = temp > 0xFFFFFF ? -1 : (byte)(temp >>> 16 & mask);
                    ++dy;
                    dptr += bytesPerLine;
                }
                val += inc;
                ++dx;
                dp += 4;
            }
        }
    }

    static final void buildPreciseGradientChannel(int from, int to, int steps, int bandWidth, int bandHeight, boolean vertical, byte[] bitmapData, int dp, int bytesPerLine) {
        int val = from << 16;
        int inc = ((to << 16) - val) / steps + 1;
        if (vertical) {
            int dy = 0;
            while (dy < bandHeight) {
                bitmapData[dp] = (byte)(val >>> 16);
                val += inc;
                ++dy;
                dp += bytesPerLine;
            }
        } else {
            int dx = 0;
            while (dx < bandWidth) {
                bitmapData[dp] = (byte)(val >>> 16);
                val += inc;
                ++dx;
                dp += 4;
            }
        }
    }
}

