/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.context.ui.views;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.util.TransferDragSourceListener;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.mylyn.context.core.AbstractContextStructureBridge;
import org.eclipse.mylyn.context.core.AbstractRelationProvider;
import org.eclipse.mylyn.context.core.ContextCorePlugin;
import org.eclipse.mylyn.context.core.IInteractionContext;
import org.eclipse.mylyn.context.core.IInteractionContextListener;
import org.eclipse.mylyn.context.core.IInteractionContextListener2;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.context.ui.AbstractContextUiBridge;
import org.eclipse.mylyn.context.ui.ContextUiPlugin;
import org.eclipse.mylyn.internal.context.ui.ActiveViewSelectionDragAdapter;
import org.eclipse.mylyn.internal.context.ui.ContextUiImages;
import org.eclipse.mylyn.internal.context.ui.DoiOrderSorter;
import org.eclipse.mylyn.internal.context.ui.actions.LinkActiveSearchWithEditorAction;
import org.eclipse.mylyn.internal.context.ui.actions.ShowQualifiedNamesAction;
import org.eclipse.mylyn.internal.context.ui.actions.ToggleRelationshipProviderAction;
import org.eclipse.mylyn.internal.context.ui.views.ActiveViewDelegatingDragAdapter;
import org.eclipse.mylyn.internal.context.ui.views.ActiveViewDropAdapter;
import org.eclipse.mylyn.internal.context.ui.views.ContextContentProvider;
import org.eclipse.mylyn.internal.context.ui.views.ContextNodeOpenListener;
import org.eclipse.mylyn.internal.context.ui.views.DelegatingContextLabelProvider;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActiveSearchView
extends ViewPart {
    private static final String STOP_JOBS_LABEL = "Stop Active Search Jobs";
    public static final String ID = "org.eclipse.mylyn.ui.views.active.search";
    private TreeViewer viewer;
    private List<ToggleRelationshipProviderAction> relationshipProviderActions = new ArrayList<ToggleRelationshipProviderAction>();
    private DelegatingContextLabelProvider labelProvider = new DelegatingContextLabelProvider();
    private boolean syncExecForTesting = true;
    private final IInteractionContextListener REFRESH_UPDATE_LISTENER = new IInteractionContextListener2(){

        public void interestChanged(List<IInteractionElement> nodes) {
            ActiveSearchView.this.refresh(nodes.get(nodes.size() - 1), false);
        }

        public void contextActivated(IInteractionContext taskscape) {
            ActiveSearchView.this.refreshRelatedElements();
            ActiveSearchView.this.refresh(null, true);
        }

        public void contextDeactivated(IInteractionContext taskscape) {
            ActiveSearchView.this.refresh(null, true);
        }

        public void contextCleared(IInteractionContext context) {
            ActiveSearchView.this.refresh(null, true);
        }

        public void landmarkAdded(IInteractionElement node) {
            ActiveSearchView.this.refresh(null, true);
        }

        public void landmarkRemoved(IInteractionElement node) {
            ActiveSearchView.this.refresh(null, true);
        }

        public void relationsChanged(IInteractionElement node) {
            ActiveSearchView.this.refresh(node, true);
        }

        public void elementDeleted(IInteractionElement node) {
            ActiveSearchView.this.refresh(null, true);
        }

        public void elementsDeleted(List<IInteractionElement> elements) {
            ActiveSearchView.this.refresh(null, true);
        }

        public void contextPreActivated(IInteractionContext context) {
        }
    };

    public void refreshRelatedElements() {
        try {
            for (AbstractRelationProvider provider : ContextCorePlugin.getDefault().getRelationProviders()) {
                ArrayList<AbstractRelationProvider> providerList = new ArrayList<AbstractRelationProvider>();
                providerList.add(provider);
                this.updateDegreesOfSeparation(providerList, provider.getCurrentDegreeOfSeparation());
            }
        }
        catch (Throwable t) {
            StatusHandler.fail((Throwable)t, (String)"Could not refresn related elements", (boolean)false);
        }
    }

    public static ActiveSearchView getFromActivePerspective() {
        if (PlatformUI.getWorkbench() == null) {
            return null;
        }
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (activePage == null) {
            return null;
        }
        IViewPart view = activePage.findView(ID);
        if (view instanceof ActiveSearchView) {
            return (ActiveSearchView)view;
        }
        return null;
    }

    public ActiveSearchView() {
        ContextCorePlugin.getContextManager().addListener(this.REFRESH_UPDATE_LISTENER);
        for (AbstractRelationProvider provider : ContextCorePlugin.getDefault().getRelationProviders()) {
            provider.setEnabled(true);
        }
        this.refreshRelatedElements();
    }

    public void updateDegreesOfSeparation(Collection<AbstractRelationProvider> providers, int degreeOfSeparation) {
        for (AbstractRelationProvider provider : providers) {
            this.updateDegreeOfSeparation(provider, degreeOfSeparation);
        }
    }

    public void updateDegreeOfSeparation(AbstractRelationProvider provider, int degreeOfSeparation) {
        ContextCorePlugin.getContextManager().resetLandmarkRelationshipsOfKind(provider.getId());
        ContextUiPlugin.getDefault().getPreferenceStore().setValue(provider.getGenericId(), degreeOfSeparation);
        provider.setDegreeOfSeparation(degreeOfSeparation);
        for (IInteractionElement element : ContextCorePlugin.getContextManager().getActiveContext().getInteresting()) {
            if (!element.getInterest().isLandmark()) continue;
            provider.landmarkAdded(element);
        }
    }

    public void dispose() {
        super.dispose();
        ContextCorePlugin.getContextManager().removeListener(this.REFRESH_UPDATE_LISTENER);
    }

    void refresh(final IInteractionElement node, final boolean updateLabels) {
        if (!this.syncExecForTesting) {
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                public void run() {
                    try {
                        ActiveSearchView.this.internalRefresh(node, updateLabels);
                    }
                    catch (Throwable t) {
                        StatusHandler.log((Throwable)t, (String)"active searchrefresh failed");
                    }
                }
            });
        } else {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    try {
                        ActiveSearchView.this.internalRefresh(node, updateLabels);
                    }
                    catch (Throwable t) {
                        StatusHandler.log((Throwable)t, (String)"active searchrefresh failed");
                    }
                }
            });
        }
    }

    private void internalRefresh(IInteractionElement node, boolean updateLabels) {
        Object toRefresh = null;
        if (node != null) {
            AbstractContextStructureBridge bridge = ContextCorePlugin.getDefault().getStructureBridge(node.getContentType());
            toRefresh = bridge.getObjectForHandle(node.getHandleIdentifier());
        }
        if (this.viewer != null && !this.viewer.getTree().isDisposed()) {
            this.viewer.getControl().setRedraw(false);
            if (toRefresh != null && this.containsNode(this.viewer.getTree(), toRefresh)) {
                this.viewer.refresh(toRefresh, updateLabels);
            } else if (node == null) {
                this.viewer.refresh();
            }
            this.viewer.expandToLevel(3);
            this.viewer.getControl().setRedraw(true);
        }
    }

    private boolean containsNode(Tree tree, Object object) {
        boolean contains = false;
        int i = 0;
        while (i < tree.getItems().length) {
            TreeItem item = tree.getItems()[i];
            if (object.equals(item.getData())) {
                contains = true;
            }
            ++i;
        }
        return contains;
    }

    private void initDrop() {
        Transfer[] types = new Transfer[]{LocalSelectionTransfer.getTransfer()};
        this.viewer.addDropSupport(2, types, (DropTargetListener)new ActiveViewDropAdapter((Viewer)this.viewer));
    }

    private void initDrag() {
        int ops = 7;
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getTransfer()};
        TransferDragSourceListener[] dragListeners = new TransferDragSourceListener[]{new ActiveViewSelectionDragAdapter((ISelectionProvider)this.viewer)};
        this.viewer.addDragSupport(ops, transfers, (DragSourceListener)new ActiveViewDelegatingDragAdapter(dragListeners));
    }

    public void createPartControl(Composite parent) {
        this.viewer = new TreeViewer(parent, 770);
        this.viewer.setUseHashlookup(true);
        this.viewer.setContentProvider((IContentProvider)new ContextContentProvider(this.viewer.getTree(), this.getViewSite(), true));
        this.viewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)this.labelProvider, PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator()));
        this.viewer.setSorter((ViewerSorter)new DoiOrderSorter());
        this.viewer.setInput((Object)this.getViewSite());
        this.hookContextMenu();
        this.initDrop();
        this.initDrag();
        this.getSite().setSelectionProvider((ISelectionProvider)this.getViewer());
        this.viewer.addOpenListener((IOpenListener)new ContextNodeOpenListener((Viewer)this.viewer));
        this.contributeToActionBars();
        this.viewer.expandToLevel(2);
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ActiveSearchView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        ShowQualifiedNamesAction qualifyElements = new ShowQualifiedNamesAction(this);
        manager.add((IAction)qualifyElements);
        this.fillActions((IContributionManager)manager);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalPullDown(IMenuManager manager) {
        this.fillActions((IContributionManager)manager);
        Action stopAction = new Action(){

            public void run() {
                for (AbstractRelationProvider provider : ContextCorePlugin.getDefault().getRelationProviders()) {
                    provider.stopAllRunningJobs();
                }
            }
        };
        stopAction.setToolTipText(STOP_JOBS_LABEL);
        stopAction.setText(STOP_JOBS_LABEL);
        stopAction.setImageDescriptor(ContextUiImages.STOP_SEARCH);
        manager.add((IAction)stopAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new LinkActiveSearchWithEditorAction());
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillActions(IContributionManager manager) {
        List<AbstractContextUiBridge> bridges = ContextUiPlugin.getDefault().getUiBridges();
        for (AbstractContextUiBridge uiBridge : bridges) {
            Set providers = ContextCorePlugin.getDefault().getRelationProviders(uiBridge.getContentType());
            if (providers == null || providers.size() <= 0) continue;
            ToggleRelationshipProviderAction action = new ToggleRelationshipProviderAction(this, providers, uiBridge);
            this.relationshipProviderActions.add(action);
            manager.add((IAction)action);
        }
    }

    public void setFocus() {
        this.viewer.refresh();
        this.viewer.getControl().setFocus();
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }

    public void setSyncExecForTesting(boolean asyncRefreshMode) {
        this.syncExecForTesting = asyncRefreshMode;
    }

    public void setQualifiedNameMode(boolean qualifiedNameMode) {
        DelegatingContextLabelProvider.setQualifyNamesMode(qualifiedNameMode);
        this.refresh(null, true);
    }
}

