/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.trac.core;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.mylyn.internal.trac.core.model.TracTicket;
import org.eclipse.mylyn.internal.trac.core.util.TracUtils;
import org.eclipse.mylyn.tasks.core.AbstractAttributeFactory;

public class TracAttributeFactory
extends AbstractAttributeFactory {
    private static final long serialVersionUID = 5333211422546115138L;
    private static Map<String, Attribute> attributeByTracKey = new HashMap<String, Attribute>();
    private static Map<String, String> tracKeyByTaskKey = new HashMap<String, String>();

    static {
        Attribute.values();
    }

    public boolean isHidden(String key) {
        if (TracAttributeFactory.isInternalAttribute(key)) {
            return true;
        }
        Attribute attribute = attributeByTracKey.get(key);
        return attribute != null ? attribute.isHidden() : false;
    }

    public String getName(String key) {
        Attribute attribute = attributeByTracKey.get(key);
        return attribute != null ? attribute.toString() : key;
    }

    public boolean isReadOnly(String key) {
        Attribute attribute = attributeByTracKey.get(key);
        return attribute != null ? attribute.isReadOnly() : false;
    }

    public String mapCommonAttributeKey(String key) {
        String tracKey = tracKeyByTaskKey.get(key);
        return tracKey != null ? tracKey : key;
    }

    static boolean isInternalAttribute(String id) {
        return "task.common.comment.new".equals(id) || "task.common.removecc".equals(id) || "task.common.newcc".equals(id) || "task.common.addselfcc".equals(id);
    }

    public Date getDateForAttributeType(String attributeKey, String dateString) {
        if (dateString == null || dateString.length() == 0) {
            return null;
        }
        try {
            String mappedKey = this.mapCommonAttributeKey(attributeKey);
            if (mappedKey.equals(Attribute.TIME.getTracKey()) || mappedKey.equals(Attribute.CHANGE_TIME.getTracKey())) {
                return TracUtils.parseDate(Integer.valueOf(dateString).intValue());
            }
        }
        catch (Exception exception) {}
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Attribute {
        CC(TracTicket.Key.CC, "CC:", "task.common.user.cc", true, false),
        CHANGE_TIME(TracTicket.Key.CHANGE_TIME, "Last Modification:", "task.common.date.modified", true, true),
        COMPONENT(TracTicket.Key.COMPONENT, "Component:", "task.common.product"),
        DESCRIPTION(TracTicket.Key.DESCRIPTION, "Description:", "task.common.description", true, false),
        ID(TracTicket.Key.ID, "<used by search engine>", null, true),
        KEYWORDS(TracTicket.Key.KEYWORDS, "Keywords:", "task.common.keywords"),
        MILESTONE(TracTicket.Key.MILESTONE, "Milestone:", null),
        NEW_CC("task.common.newcc", "Add CC:"),
        OWNER(TracTicket.Key.OWNER, "Assigned to:", "task.common.user.assigned", true, true),
        PRIORITY(TracTicket.Key.PRIORITY, "Priority:", null),
        REPORTER(TracTicket.Key.REPORTER, "Reporter:", "task.common.user.reporter", true, true),
        RESOLUTION(TracTicket.Key.RESOLUTION, "Resolution:", "task.common.resolution", false, true),
        SEVERITY(TracTicket.Key.SEVERITY, "Severity:", null),
        STATUS(TracTicket.Key.STATUS, "Status:", "task.common.status", false, true),
        SUMMARY(TracTicket.Key.SUMMARY, "Summary:", "task.common.summary", true),
        TIME(TracTicket.Key.TIME, "Created:", "task.common.date.created", true, true),
        TYPE(TracTicket.Key.TYPE, "Type:", null),
        VERSION(TracTicket.Key.VERSION, "Version:", null);

        private final boolean isHidden;
        private final boolean isReadOnly;
        private final String tracKey;
        private final String prettyName;
        private final String taskKey;

        private Attribute(String tracKey, String prettyName, String taskKey, boolean hidden, boolean readonly) {
            this.tracKey = tracKey;
            this.taskKey = taskKey;
            this.prettyName = prettyName;
            this.isHidden = hidden;
            this.isReadOnly = readonly;
            attributeByTracKey.put(tracKey, this);
            if (taskKey != null) {
                tracKeyByTaskKey.put(taskKey, tracKey);
            }
        }

        private Attribute(TracTicket.Key key, String prettyName, String taskKey, boolean hidden, boolean readonly) {
            this(key.getKey(), prettyName, taskKey, hidden, readonly);
        }

        private Attribute(TracTicket.Key key, String prettyName, String taskKey, boolean hidden) {
            this(key.getKey(), prettyName, taskKey, hidden, false);
        }

        private Attribute(TracTicket.Key key, String prettyName, String taskKey) {
            this(key.getKey(), prettyName, taskKey, false, false);
        }

        private Attribute(String taskKey, String prettyName) {
            this(taskKey, prettyName, taskKey, true, false);
        }

        public String getTaskKey() {
            return this.taskKey;
        }

        public String getTracKey() {
            return this.tracKey;
        }

        public boolean isHidden() {
            return this.isHidden;
        }

        public boolean isReadOnly() {
            return this.isReadOnly;
        }

        public String toString() {
            return this.prettyName;
        }
    }
}

