/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.trac.core;

import java.net.MalformedURLException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.mylyn.internal.trac.core.TracException;
import org.eclipse.mylyn.internal.trac.core.TracLoginException;
import org.eclipse.mylyn.internal.trac.core.TracPermissionDeniedException;
import org.eclipse.mylyn.internal.trac.core.TracRepositoryConnector;
import org.eclipse.mylyn.internal.trac.core.TracStatus;
import org.eclipse.mylyn.tasks.core.RepositoryStatus;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class TracCorePlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.mylyn.trac.core";
    public static final String ENCODING_UTF_8 = "UTF-8";
    private static TracCorePlugin plugin;
    public static final String REPOSITORY_KIND = "trac";
    private TracRepositoryConnector connector;

    public static TracCorePlugin getDefault() {
        return plugin;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        if (this.connector != null) {
            this.connector.stop();
            this.connector = null;
        }
        plugin = null;
        super.stop(context);
    }

    public TracRepositoryConnector getConnector() {
        return this.connector;
    }

    void setConnector(TracRepositoryConnector connector) {
        this.connector = connector;
    }

    protected IPath getRepostioryAttributeCachePath() {
        IPath stateLocation = Platform.getStateLocation((Bundle)this.getBundle());
        IPath cacheFile = stateLocation.append("repositoryConfigurations");
        return cacheFile;
    }

    public static IStatus toStatus(Throwable e, TaskRepository repository) {
        if (e instanceof TracLoginException) {
            return RepositoryStatus.createLoginError((String)repository.getUrl(), (String)PLUGIN_ID);
        }
        if (e instanceof TracPermissionDeniedException) {
            return TracStatus.createPermissionDeniedError(repository.getUrl(), PLUGIN_ID);
        }
        if (e instanceof TracException) {
            String message = e.getMessage();
            if (message == null) {
                message = "I/O error has occured";
            }
            return new RepositoryStatus(repository.getUrl(), 4, PLUGIN_ID, 5, message, e);
        }
        if (e instanceof ClassCastException) {
            return new RepositoryStatus(4, PLUGIN_ID, 5, "Unexpected server response: " + e.getMessage(), e);
        }
        if (e instanceof MalformedURLException) {
            return new RepositoryStatus(4, PLUGIN_ID, 5, "Repository URL is invalid", e);
        }
        return new RepositoryStatus(4, PLUGIN_ID, 7, "Unexpected error", e);
    }
}

