/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.trac.core;

import org.eclipse.mylyn.tasks.core.AbstractTask;

public class TracTask
extends AbstractTask {
    public TracTask(String repositoryUrl, String id, String label) {
        super(repositoryUrl, id, label);
        this.setUrl(String.valueOf(repositoryUrl) + "/ticket/" + id);
    }

    public String getConnectorKind() {
        return "trac";
    }

    public static String getMylynPriority(String tracPriority) {
        PriorityLevel priority;
        if (tracPriority != null && (priority = PriorityLevel.fromPriority(tracPriority)) != null) {
            return priority.toString();
        }
        return AbstractTask.PriorityLevel.P3.toString();
    }

    public static boolean isCompleted(String tracStatus) {
        Status status = Status.fromStatus(tracStatus);
        return status == Status.CLOSED;
    }

    public boolean isLocal() {
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Kind {
        DEFECT,
        ENHANCEMENT,
        TASK;


        public String toString() {
            switch (this) {
                case DEFECT: {
                    return "Defect";
                }
                case ENHANCEMENT: {
                    return "Enhancement";
                }
                case TASK: {
                    return "Task";
                }
            }
            return "";
        }

        public static Kind fromType(String type) {
            if (type == null) {
                return null;
            }
            if (type.equals("defect")) {
                return DEFECT;
            }
            if (type.equals("enhancement")) {
                return ENHANCEMENT;
            }
            if (type.equals("task")) {
                return TASK;
            }
            return null;
        }

        public static Kind fromString(String type) {
            if (type == null) {
                return null;
            }
            if (type.equals("Defect")) {
                return DEFECT;
            }
            if (type.equals("Enhancement")) {
                return ENHANCEMENT;
            }
            if (type.equals("Task")) {
                return TASK;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PriorityLevel {
        BLOCKER,
        CRITICAL,
        MAJOR,
        MINOR,
        TRIVIAL;


        public String toString() {
            switch (this) {
                case BLOCKER: {
                    return "P1";
                }
                case CRITICAL: {
                    return "P2";
                }
                case MAJOR: {
                    return "P3";
                }
                case MINOR: {
                    return "P4";
                }
                case TRIVIAL: {
                    return "P5";
                }
            }
            return "P5";
        }

        public static PriorityLevel fromPriority(String priority) {
            if (priority == null) {
                return null;
            }
            if (priority.equals("blocker")) {
                return BLOCKER;
            }
            if (priority.equals("critical")) {
                return CRITICAL;
            }
            if (priority.equals("major")) {
                return MAJOR;
            }
            if (priority.equals("minor")) {
                return MINOR;
            }
            if (priority.equals("trivial")) {
                return TRIVIAL;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        NEW,
        ASSIGNED,
        REOPENED,
        CLOSED;


        public String toString() {
            switch (this) {
                case NEW: {
                    return "New";
                }
                case ASSIGNED: {
                    return "Assigned";
                }
                case REOPENED: {
                    return "Reopened";
                }
                case CLOSED: {
                    return "Closed";
                }
            }
            return "";
        }

        public static Status fromStatus(String status) {
            if (status == null) {
                return null;
            }
            if (status.equals("new")) {
                return NEW;
            }
            if (status.equals("assigned")) {
                return ASSIGNED;
            }
            if (status.equals("reopened")) {
                return REOPENED;
            }
            if (status.equals("closed")) {
                return CLOSED;
            }
            return null;
        }

        public String toStatusString() {
            switch (this) {
                case NEW: {
                    return "new";
                }
                case ASSIGNED: {
                    return "assigned";
                }
                case REOPENED: {
                    return "reopened";
                }
                case CLOSED: {
                    return "closed";
                }
            }
            return "";
        }
    }
}

