/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.trac.core.model;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.mylyn.internal.trac.core.InvalidTicketException;
import org.eclipse.mylyn.internal.trac.core.model.TracAttachment;
import org.eclipse.mylyn.internal.trac.core.model.TracComment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TracTicket {
    public static final int INVALID_ID = -1;
    private Date created;
    private Map<String, String> customValueByKey;
    private int id = -1;
    private Date lastChanged;
    private Map<Key, String> valueByKey = new HashMap<Key, String>();
    private List<TracComment> comments;
    private List<TracAttachment> attachments;
    private String[] actions;
    private String[] resolutions;

    public TracTicket() {
    }

    public TracTicket(int id) {
        this.id = id;
    }

    public Date getCreated() {
        return this.created;
    }

    public int getId() {
        return this.id;
    }

    public Date getLastChanged() {
        return this.lastChanged;
    }

    public String getCustomValue(String key) {
        if (this.customValueByKey == null) {
            return null;
        }
        return this.customValueByKey.get(key);
    }

    public String getValue(Key key) {
        return this.valueByKey.get((Object)key);
    }

    public Map<String, String> getValues() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Key key : this.valueByKey.keySet()) {
            result.put(key.getKey(), this.valueByKey.get((Object)key));
        }
        if (this.customValueByKey != null) {
            result.putAll(this.customValueByKey);
        }
        return result;
    }

    public boolean isValid() {
        return this.getId() != -1;
    }

    public void putBuiltinValue(Key key, String value) throws InvalidTicketException {
        this.valueByKey.put(key, value);
    }

    public void putCustomValue(String key, String value) {
        if (this.customValueByKey == null) {
            this.customValueByKey = new HashMap<String, String>();
        }
        this.customValueByKey.put(key, value);
    }

    public boolean putValue(String keyName, String value) throws InvalidTicketException {
        Key key = Key.fromKey(keyName);
        if (key != null) {
            if (key == Key.ID || key == Key.TIME || key == Key.CHANGE_TIME) {
                return false;
            }
            this.putBuiltinValue(key, value);
        } else if (value != null) {
            this.putCustomValue(keyName, value);
        } else {
            throw new InvalidTicketException("Expected string value for custom key '" + keyName + "', got '" + value + "'");
        }
        return true;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setLastChanged(Date lastChanged) {
        this.lastChanged = lastChanged;
    }

    public void addComment(TracComment comment) {
        if (this.comments == null) {
            this.comments = new ArrayList<TracComment>();
        }
        this.comments.add(comment);
    }

    public void addAttachment(TracAttachment attachment) {
        if (this.attachments == null) {
            this.attachments = new ArrayList<TracAttachment>();
        }
        this.attachments.add(attachment);
    }

    public TracComment[] getComments() {
        return this.comments != null ? this.comments.toArray(new TracComment[0]) : null;
    }

    public TracAttachment[] getAttachments() {
        return this.attachments != null ? this.attachments.toArray(new TracAttachment[0]) : null;
    }

    public void setActions(String[] actions) {
        this.actions = actions;
    }

    public String[] getActions() {
        return this.actions;
    }

    public void setResolutions(String[] resolutions) {
        this.resolutions = resolutions;
    }

    public String[] getResolutions() {
        return this.resolutions;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Key {
        CC("cc"),
        CHANGE_TIME("changetime"),
        COMPONENT("component"),
        DESCRIPTION("description"),
        ID("id"),
        KEYWORDS("keywords"),
        MILESTONE("milestone"),
        OWNER("owner"),
        PRIORITY("priority"),
        REPORTER("reporter"),
        RESOLUTION("resolution"),
        STATUS("status"),
        SEVERITY("severity"),
        SUMMARY("summary"),
        TIME("time"),
        TYPE("type"),
        VERSION("version");

        private String key;

        public static Key fromKey(String name) {
            Key[] keyArray = Key.values();
            int n = keyArray.length;
            int n2 = 0;
            while (n2 < n) {
                Key key = keyArray[n2];
                if (key.getKey().equals(name)) {
                    return key;
                }
                ++n2;
            }
            return null;
        }

        private Key(String key) {
            this.key = key;
        }

        public String toString() {
            return this.key;
        }

        public String getKey() {
            return this.key;
        }
    }
}

